/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.order;

import com.tydic.order.pec.atom.el.other.UocPebBusiOperRecordAtomService;
import com.tydic.order.pec.atom.el.other.UocPebSendMsgAtomService;
import com.tydic.order.pec.atom.el.other.bo.UocPebBusiOperRecordReqBO;
import com.tydic.order.pec.atom.el.other.bo.UocPebBusiOperRecordRspBO;
import com.tydic.order.pec.atom.el.other.bo.UocPebSendMsgReqBO;
import com.tydic.order.pec.atom.el.other.bo.UocPebSendMsgRspBO;
import com.tydic.order.pec.atom.es.others.GenerateOrderShipSeqAtomService;
import com.tydic.order.pec.atom.es.others.bo.GenerateOrderShipSeqRspBO;
import com.tydic.order.pec.bo.el.order.ProcessOrderCountBO;
import com.tydic.order.pec.bo.el.order.UocPebAccessoryBO;
import com.tydic.order.pec.busi.el.order.UocPebOrderProcessBusiService;
import com.tydic.order.pec.busi.el.order.bo.UocPebOrderProcessReqBO;
import com.tydic.order.pec.busi.el.order.bo.UocPebOrderProcessRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.pec.dic.SelectDictValByCode;
import com.tydic.order.pec.dic.bo.DicDictionaryBO;
import com.tydic.order.pec.dic.bo.SelectDictReqBO;
import com.tydic.order.pec.dic.bo.SelectDictRspBO;
import com.tydic.order.uoc.atom.core.UocCoreChgVoucherStateAtomService;
import com.tydic.order.uoc.atom.core.UocCoreQryTaskInstAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreChgVoucherStateReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreChgVoucherStateRspBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreQryTaskInstRspBO;
import com.tydic.order.uoc.atom.order.UocCoreQryOrderDetailAtomService;
import com.tydic.order.uoc.atom.other.UocCoreCreateAccessoryAtomService;
import com.tydic.order.uoc.atom.ship.UocCoreOrderShipAtomService;
import com.tydic.order.uoc.bo.order.OrdSaleRspBO;
import com.tydic.order.uoc.bo.order.OrderRspBO;
import com.tydic.order.uoc.bo.order.UocCoreOryOrderReqBO;
import com.tydic.order.uoc.bo.order.UocCoreQryOrderDetailRspBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryReqBO;
import com.tydic.order.uoc.bo.other.UocCoreCreateAccessoryRspBO;
import com.tydic.order.uoc.bo.other.VoucherStateBO;
import com.tydic.order.uoc.bo.ship.ShipCruxFieldBO;
import com.tydic.order.uoc.bo.ship.UocCoreOrderShipReqBO;
import com.tydic.order.uoc.bo.ship.UocCoreOrderShipRspBO;
import com.tydic.order.uoc.bo.ship.UocCoreShipItemReqBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdItemMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.po.OrdItemMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uocPebOrderProcessBusiService")
public class UocPebOrderProcessBusiServiceImpl
implements UocPebOrderProcessBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebOrderProcessBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private final String errorMsg = "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:";
    @Autowired
    private UocCoreQryTaskInstAtomService uocCoreQryTaskInstAtomService;
    @Autowired
    private UocCoreQryOrderDetailAtomService uocCoreQryOrderDetailAtomService;
    @Autowired
    private UocCoreChgVoucherStateAtomService uocCoreChgVoucherStateAtomService;
    @Autowired
    private UocCoreOrderShipAtomService uocCoreOrderShipAtomService;
    @Autowired
    private GenerateOrderShipSeqAtomService generateOrderShipSeqAtomService;
    @Autowired
    UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;
    @Autowired
    UocPebSendMsgAtomService uocPebSendMsgAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private UocPebBusiOperRecordAtomService uocPebBusiOperRecordAtomService;
    @Autowired
    private SelectDictValByCode selectDictValByCode;

    public UocPebOrderProcessRspBO createShipOrder(UocPebOrderProcessReqBO uocPebOrderProcessReqBO) {
        UocPebOrderProcessRspBO rspBO = new UocPebOrderProcessRspBO();
        this.validationParams(uocPebOrderProcessReqBO);
        this.verifyTacheCode(uocPebOrderProcessReqBO);
        UocCoreQryOrderDetailRspBO uocCoreQryOrderDetailRspBO = this.qryOrderSaleAndVerifyStatus(uocPebOrderProcessReqBO);
        List<OrdItemPO> ordItemPOList = this.qryOrdItemList(uocPebOrderProcessReqBO, uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getPurchaseType(), uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getOrderMethod());
        UocCoreOrderShipReqBO uocCoreOrderShipReqBO = this.buildShipAndItemData(uocPebOrderProcessReqBO, ordItemPOList, uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getPurchaseType());
        Long shipVoucherId = this.executeCoerOrderShipAtomService(uocCoreOrderShipReqBO);
        this.modifySaleAndItem(uocPebOrderProcessReqBO);
        this.createAccessory(uocPebOrderProcessReqBO, shipVoucherId);
        this.insertOprRecord(uocPebOrderProcessReqBO, shipVoucherId);
        if (PecConstant.PURCHASE_TYPE.MATERIALS_TYPE.equals(uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getPurchaseType())) {
            this.sendMsg(uocPebOrderProcessReqBO, uocCoreQryOrderDetailRspBO, ordItemPOList, uocCoreOrderShipReqBO.getShipVoucherCode());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRemark("\u6267\u884c\u53d1\u8d27\u670d\u52a1\u6210\u529f");
        return rspBO;
    }

    private void verifyTacheCode(UocPebOrderProcessReqBO reqBO) {
        UocCoreQryTaskInstReqBO uocCoreQryTaskInstReqBO = new UocCoreQryTaskInstReqBO();
        uocCoreQryTaskInstReqBO.setOrderId(reqBO.getOrderId());
        uocCoreQryTaskInstReqBO.setTacheCode("PEB23");
        UocCoreQryTaskInstRspBO uocCoreQryTaskInstRspBO = this.uocCoreQryTaskInstAtomService.qryTaskInst(uocCoreQryTaskInstReqBO);
        if (!"0000".equals(uocCoreQryTaskInstRspBO.getRespCode()) || uocCoreQryTaskInstRspBO.getTaskInstBO() == null) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u7684\u5f53\u524d\u53d1\u8d27\u4efb\u52a1\u5b9e\u4f8b");
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u7684\u5f53\u524d\u53d1\u8d27\u4efb\u52a1\u5b9e\u4f8b");
        }
        if (!"PEB23".equals(uocCoreQryTaskInstRspBO.getTaskInstBO().getTacheCode())) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u7684\u5f53\u524d\u73af\u8282\u4e0d\u4e3aPEB23");
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u7684\u5f53\u524d\u73af\u8282\u4e0d\u4e3aPEB23");
        }
    }

    private UocCoreQryOrderDetailRspBO qryOrderSaleAndVerifyStatus(UocPebOrderProcessReqBO reqBO) {
        UocCoreOryOrderReqBO uocCoreOryOrderReqBO = new UocCoreOryOrderReqBO();
        uocCoreOryOrderReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOryOrderReqBO.setOrderId(reqBO.getOrderId());
        UocCoreQryOrderDetailRspBO uocCoreQryOrderDetailRspBO = this.uocCoreQryOrderDetailAtomService.qryCoreQryOrderDetail(uocCoreOryOrderReqBO);
        if (!"0000".equals(uocCoreQryOrderDetailRspBO.getRespCode()) || uocCoreQryOrderDetailRspBO == null) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u8c03\u7528[\u6838\u5fc3\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1]\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25!");
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u8c03\u7528[\u6838\u5fc3\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1]\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25!");
        }
        if (uocCoreQryOrderDetailRspBO.getOrdSaleRspBO() == null) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u6838\u5fc3\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u7684\u4fe1\u606f!");
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u6838\u5fc3\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u7684\u4fe1\u606f!");
        }
        if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(uocCoreQryOrderDetailRspBO.getOrdSaleRspBO().getSaleState())) {
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u9500\u552e\u8ba2\u5355[" + reqBO.getSaleVoucherId() + "]\u5df2\u7ecf\u9a8c\u6536\u5b8c\u6bd5\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d27!");
        }
        return uocCoreQryOrderDetailRspBO;
    }

    private List<OrdItemPO> qryOrdItemList(UocPebOrderProcessReqBO reqBO, Integer purchaseType, Integer orderMethod) {
        ArrayList<OrdItemPO> ordItemPOList = new ArrayList<OrdItemPO>();
        BigDecimal shipTotalCount = BigDecimal.ZERO;
        BigDecimal purchaseTotalCount = BigDecimal.ZERO;
        List processOrderCountBOS = reqBO.getProcessCountList();
        for (ProcessOrderCountBO processOrderCountBO : processOrderCountBOS) {
            OrdItemPO ordItemPO = this.qryOrdItem(reqBO.getOrderId(), processOrderCountBO.getSaleOrderItemId());
            shipTotalCount = shipTotalCount.add(ordItemPO.getSendCount().add(processOrderCountBO.getProcessCount()));
            purchaseTotalCount = purchaseTotalCount.add(ordItemPO.getPurchaseCount());
            ordItemPO.setSendCount(ordItemPO.getSendCount().add(processOrderCountBO.getProcessCount()));
            ordItemPOList.add(ordItemPO);
        }
        if (purchaseType == null && shipTotalCount.compareTo(purchaseTotalCount) > 0) {
            if (this.isDebugEnabled) {
                log.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
        }
        if (PecConstant.PURCHASE_TYPE.MATERIALS_TYPE.equals(purchaseType)) {
            if (PecConstant.ORDER_METHOD.FRAMEWORK_TYPE.equals(orderMethod) || PecConstant.ORDER_METHOD.TOTAL_TYPE.equals(orderMethod)) {
                if (shipTotalCount.compareTo(purchaseTotalCount) > 0) {
                    if (this.isDebugEnabled) {
                        log.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
                    }
                    throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
                }
            } else if (PecConstant.ORDER_METHOD.SINGLE_TYPE.equals(orderMethod)) {
                BigDecimal newPurchaseTotalCount;
                SelectDictReqBO selectDictReqBO = new SelectDictReqBO();
                selectDictReqBO.setPcode(PecConstant.RATIO_P_CODE);
                SelectDictRspBO selectDictRspBO = this.selectDictValByCode.selectDictValByCode(selectDictReqBO);
                String ratio = "1.2";
                if (selectDictRspBO.getDicDictionarys() != null && !selectDictRspBO.getDicDictionarys().isEmpty() && selectDictRspBO.getDicDictionarys().size() == 1) {
                    DicDictionaryBO dicDictionaryBO = (DicDictionaryBO)selectDictRspBO.getDicDictionarys().get(0);
                    ratio = dicDictionaryBO.getCode();
                }
                if (shipTotalCount.compareTo(newPurchaseTotalCount = purchaseTotalCount.multiply(new BigDecimal(ratio)).setScale(2, 4)) > 0) {
                    if (this.isDebugEnabled) {
                        log.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf\u7684120%");
                    }
                    throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf\u7684120%");
                }
            }
        }
        return ordItemPOList;
    }

    private OrdItemPO qryOrdItem(Long orderId, Long ordItemId) {
        try {
            OrdItemPO ordItemModel = new OrdItemPO();
            ordItemModel.setOrdItemId(ordItemId);
            ordItemModel.setOrderId(orderId);
            OrdItemPO ordItemPO = this.ordItemMapper.getModelBy(ordItemModel);
            if (ordItemPO == null) {
                throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u672a\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + ordItemId + "]\u4fe1\u606f");
            }
            return ordItemPO;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + ordItemId + "]\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + ordItemId + "]\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private void modifySaleAndItem(UocPebOrderProcessReqBO reqBO) {
        boolean isAllSending = true;
        OrdItemPO itemPO = new OrdItemPO();
        itemPO.setOrderId(reqBO.getOrderId());
        itemPO.setSaleVoucherId(reqBO.getSaleVoucherId());
        List ordItemPOList = new ArrayList();
        try {
            ordItemPOList = this.ordItemMapper.getList(itemPO);
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u5355[" + reqBO.getSaleVoucherId() + "]\u4e0b\u7684\u9500\u552e\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38" + e);
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u5355[" + reqBO.getSaleVoucherId() + "]\u4e0b\u7684\u9500\u552e\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
        for (OrdItemPO ordItemPO : ordItemPOList) {
            if (ordItemPO.getPurchaseCount().compareTo(ordItemPO.getSendCount()) <= 0) continue;
            isAllSending = false;
            break;
        }
        this.modifySaleOrderState(reqBO, isAllSending);
    }

    private void modifySaleOrderState(UocPebOrderProcessReqBO reqBO, boolean isAllSending) {
        UocCoreChgVoucherStateReqBO uocCoreChgVoucherStateReqBO = new UocCoreChgVoucherStateReqBO();
        ArrayList<VoucherStateBO> voucherStateList = new ArrayList<VoucherStateBO>();
        VoucherStateBO voucherSaleState = new VoucherStateBO();
        voucherSaleState.setObjId(reqBO.getSaleVoucherId());
        voucherSaleState.setObjType(UocConstant.OBJ_TYPE.SALE);
        if (isAllSending) {
            voucherSaleState.setAfterState(UocConstant.SALE_ORDER_STATUS.DELIVERED);
        } else {
            voucherSaleState.setAfterState(UocConstant.SALE_ORDER_STATUS.PART_DELIVERED);
        }
        VoucherStateBO voucherPurchaseState = new VoucherStateBO();
        voucherPurchaseState.setObjId(reqBO.getSaleVoucherId());
        voucherPurchaseState.setObjType(UocConstant.OBJ_TYPE.PURCHASE);
        if (isAllSending) {
            voucherPurchaseState.setAfterState(UocConstant.ORDER_PURCHASE_STATUS.ALL_DELIVERED);
        } else {
            voucherPurchaseState.setAfterState(UocConstant.ORDER_PURCHASE_STATUS.PART_DELIVERED);
        }
        voucherStateList.add(voucherSaleState);
        voucherStateList.add(voucherPurchaseState);
        uocCoreChgVoucherStateReqBO.setVoucherStateList(voucherStateList);
        uocCoreChgVoucherStateReqBO.setOrderId(reqBO.getOrderId());
        uocCoreChgVoucherStateReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        uocCoreChgVoucherStateReqBO.setDealDesc("\u9500\u552e\u5355\u53d1\u8d27\u540e\u66f4\u65b0\u9500\u552e\u5355\u72b6\u6001");
        UocCoreChgVoucherStateRspBO uocCoreChgVoucherStateRspBO = this.uocCoreChgVoucherStateAtomService.dealCoreChgVoucherState(uocCoreChgVoucherStateReqBO);
        if (!"0000".equals(uocCoreChgVoucherStateRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u9500\u552e\u5355\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + uocCoreChgVoucherStateRspBO.getRespDesc());
        }
    }

    private UocCoreOrderShipReqBO buildShipAndItemData(UocPebOrderProcessReqBO reqBO, List<OrdItemPO> ordItemPOList, Integer purchaseType) {
        GenerateOrderShipSeqRspBO generateOrderShipSeqRspBO = this.generateOrderShipSeqAtomService.generateOrderShipSeq();
        if (generateOrderShipSeqRspBO == null) {
            throw new BusinessException("8888", "\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u83b7\u53d6\u53d1\u8d27\u5355code\u7801\u5931\u8d25");
        }
        UocCoreOrderShipReqBO uocCoreOrderShipReqBO = new UocCoreOrderShipReqBO();
        uocCoreOrderShipReqBO.setShipVoucherCode(generateOrderShipSeqRspBO.getShipOrderId());
        uocCoreOrderShipReqBO.setSaleVoucherId(reqBO.getSaleVoucherId());
        uocCoreOrderShipReqBO.setOrderId(reqBO.getOrderId());
        uocCoreOrderShipReqBO.setPackageId(reqBO.getProcessNum());
        uocCoreOrderShipReqBO.setShipStatus("1202");
        if (reqBO.getAccessoryShipList() == null || reqBO.getAccessoryShipList().isEmpty()) {
            uocCoreOrderShipReqBO.setIsEnclosure(PecConstant.IS_ENCLOSURE_NO);
        } else if (reqBO.getAccessoryShipList() != null && !reqBO.getAccessoryShipList().isEmpty()) {
            uocCoreOrderShipReqBO.setIsEnclosure(PecConstant.IS_ENCLOSURE_YES);
        }
        if (PecConstant.PURCHASE_TYPE.CONSTRUCTION_TYPE.equals(purchaseType) || PecConstant.PURCHASE_TYPE.SERVICE_TYPE.equals(purchaseType)) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getProcessDate())) {
                throw new BusinessException("7777", "\u8ba2\u5355\u7c7b\u578b\u4e3a\u65bd\u5de5\u6216\u670d\u52a1\u5355\u65f6\uff0c\u53c2\u6570processDate\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<ShipCruxFieldBO> cruxFieldList = new ArrayList<ShipCruxFieldBO>();
            ShipCruxFieldBO shipCruxFieldBO = new ShipCruxFieldBO();
            shipCruxFieldBO.setFieldCode("processDate");
            if (PecConstant.PURCHASE_TYPE.CONSTRUCTION_TYPE.equals(purchaseType)) {
                shipCruxFieldBO.setFieldName("\u65bd\u5de5\u65f6\u95f4");
            } else if (PecConstant.PURCHASE_TYPE.SERVICE_TYPE.equals(purchaseType)) {
                shipCruxFieldBO.setFieldName("\u5b8c\u5de5\u65f6\u95f4");
            }
            shipCruxFieldBO.setFieldValue(reqBO.getProcessDate());
            cruxFieldList.add(shipCruxFieldBO);
            uocCoreOrderShipReqBO.setCruxFieldList(cruxFieldList);
        }
        uocCoreOrderShipReqBO.setCreateOperId(String.valueOf(reqBO.getUserId()));
        uocCoreOrderShipReqBO.setCreateTime(new Date());
        uocCoreOrderShipReqBO.setShipRemark("\u4e13\u533a\u53d1\u8d27");
        ArrayList<UocCoreShipItemReqBO> shipItemList = new ArrayList<UocCoreShipItemReqBO>();
        for (OrdItemPO ordItemPO : ordItemPOList) {
            Long ordItemId = ordItemPO.getOrdItemId();
            UocCoreShipItemReqBO uocCoreShipItemReqBO = new UocCoreShipItemReqBO();
            uocCoreShipItemReqBO.setOrdItemId(ordItemId);
            uocCoreShipItemReqBO.setOrderId(ordItemPO.getOrderId());
            uocCoreShipItemReqBO.setUnitName(ordItemPO.getUnitName());
            for (ProcessOrderCountBO processOrderCountBO : reqBO.getProcessCountList()) {
                if (!ordItemPO.getOrdItemId().equals(processOrderCountBO.getSaleOrderItemId())) continue;
                uocCoreShipItemReqBO.setSendCount(processOrderCountBO.getProcessCount());
                break;
            }
            uocCoreShipItemReqBO.setArriveCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setRefuseCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setReturnCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setAcceptanceCount(BigDecimal.ZERO);
            shipItemList.add(uocCoreShipItemReqBO);
        }
        uocCoreOrderShipReqBO.setShipItemList(shipItemList);
        return uocCoreOrderShipReqBO;
    }

    private Long executeCoerOrderShipAtomService(UocCoreOrderShipReqBO uocCoreOrderShipReqBO) {
        UocCoreOrderShipRspBO uocCoreOrderShipRspBO = this.uocCoreOrderShipAtomService.dealCoreOrderShip(uocCoreOrderShipReqBO);
        if (!"0000".equals(uocCoreOrderShipRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + uocCoreOrderShipRspBO.getRespDesc());
        }
        return uocCoreOrderShipRspBO.getShipVoucherId();
    }

    private void createAccessory(UocPebOrderProcessReqBO reqBO, Long shipVoucherId) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryShipList())) {
            for (UocPebAccessoryBO accessoryBO : reqBO.getAccessoryShipList()) {
                UocCoreCreateAccessoryReqBO createAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                createAccessoryReqBO.setOrderId(reqBO.getOrderId());
                createAccessoryReqBO.setObjectId(shipVoucherId);
                createAccessoryReqBO.setObjectType(UocConstant.OBJ_TYPE.SHIP);
                createAccessoryReqBO.setAccessoryId(accessoryBO.getAccessoryId());
                createAccessoryReqBO.setAccessoryName(accessoryBO.getAccessoryName());
                createAccessoryReqBO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
                createAccessoryReqBO.setAttachmentType(accessoryBO.getAttachmentType());
                UocCoreCreateAccessoryRspBO createAccessoryRspBO = this.uocCoreCreateAccessoryAtomService.createAccessory(createAccessoryReqBO);
                if ("0000".equals(createAccessoryRspBO.getRespCode())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + createAccessoryRspBO.getRespDesc());
                }
                throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + createAccessoryRspBO.getRespDesc());
            }
        }
    }

    private void insertOprRecord(UocPebOrderProcessReqBO reqBO, Long shipVoucherId) {
        UocPebBusiOperRecordReqBO uocPebBusiOperRecordReqBO = new UocPebBusiOperRecordReqBO();
        uocPebBusiOperRecordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        uocPebBusiOperRecordReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
        uocPebBusiOperRecordReqBO.setDealTypeId("A_17");
        uocPebBusiOperRecordReqBO.setDealCode("B_17");
        uocPebBusiOperRecordReqBO.setOrderId(reqBO.getOrderId());
        uocPebBusiOperRecordReqBO.setObjId(shipVoucherId);
        uocPebBusiOperRecordReqBO.setDealOperId(reqBO.getUserId().toString());
        uocPebBusiOperRecordReqBO.setDealOperName(reqBO.getUsername());
        uocPebBusiOperRecordReqBO.setDealCompId(reqBO.getOrgId());
        uocPebBusiOperRecordReqBO.setDealCompName(reqBO.getOrgName());
        uocPebBusiOperRecordReqBO.setDealDeptId(reqBO.getOrgId());
        uocPebBusiOperRecordReqBO.setDealDeptName(reqBO.getOrgName());
        uocPebBusiOperRecordReqBO.setDealDesc("\u53d1\u8d27");
        UocPebBusiOperRecordRspBO uocPebBusiOperRecordRspBO = this.uocPebBusiOperRecordAtomService.dealBusiOperRecord(uocPebBusiOperRecordReqBO);
        if (!"0000".equals(uocPebBusiOperRecordRspBO.getRespCode()) || uocPebBusiOperRecordRspBO == null) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u8c03\u7528[\u7535\u5546\u901a\u7528\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1]\u8bb0\u5f55\u53d1\u8d27\u64cd\u4f5c\u5931\u8d25!" + uocPebBusiOperRecordRspBO.getRespDesc());
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u8c03\u7528[\u7535\u5546\u901a\u7528\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1]\u8bb0\u5f55\u53d1\u8d27\u64cd\u4f5c\u5931\u8d25!" + uocPebBusiOperRecordRspBO.getRespDesc());
        }
    }

    private void sendMsg(UocPebOrderProcessReqBO reqBO, UocCoreQryOrderDetailRspBO uocCoreQryOrderDetailRspBO, List<OrdItemPO> ordItemPOList, String shipVoucherCode) {
        OrdSaleRspBO ordSaleRspBO = uocCoreQryOrderDetailRspBO.getOrdSaleRspBO();
        OrderRspBO orderRspBO = uocCoreQryOrderDetailRspBO.getOrderRspBO();
        UocPebSendMsgReqBO orderSendMsgBusiReq = new UocPebSendMsgReqBO();
        if (PecConstant.ORDER_SOURCE.INQUIRY_PRICE_A_SINGLE_PURCHASE.equals(Integer.valueOf(ordSaleRspBO.getOrderSource()))) {
            ArrayList<Long> planUserAllList = new ArrayList<Long>();
            for (OrdItemPO ordItemPO : ordItemPOList) {
                OrdItemMapPO ordItemMapPO = this.qryOrdItemMap(ordItemPO);
                if (ordItemMapPO == null || StringUtils.isEmpty((CharSequence)ordItemMapPO.getFieldValue())) continue;
                planUserAllList.add(Long.valueOf(ordItemMapPO.getFieldValue()));
            }
            ArrayList<Long> newUserList = new ArrayList<Long>();
            if (planUserAllList.size() > 0) {
                for (Long userId : planUserAllList) {
                    if (newUserList.contains(userId)) continue;
                    newUserList.add(userId);
                }
            }
            orderSendMsgBusiReq.setReceiveList(newUserList);
        } else if (PecConstant.ORDER_SOURCE.INQUIRY_PRICE_FRAMEWORK_AGREEMENT.equals(Integer.valueOf(ordSaleRspBO.getOrderSource()))) {
            ArrayList<Long> receiveList = new ArrayList<Long>();
            receiveList.add(Long.valueOf(orderRspBO.getCreateOperId()));
            orderSendMsgBusiReq.setReceiveList(receiveList);
        }
        orderSendMsgBusiReq.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_DELIVERY_JHCGY);
        ArrayList<String> sendTypes = new ArrayList<String>();
        sendTypes.add("3");
        orderSendMsgBusiReq.setSendTypes(sendTypes);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("orderId", ordSaleRspBO.getSaleVoucherNo());
        templateParams.put("orderName", (String)ordSaleRspBO.getSaleExtraMap().get("saleVoucherName"));
        templateParams.put("shipId", shipVoucherCode);
        orderSendMsgBusiReq.setTemplateParam(templateParams);
        orderSendMsgBusiReq.setUserId(String.valueOf(reqBO.getUserId()));
        if (orderSendMsgBusiReq.getReceiveList() == null || orderSendMsgBusiReq.getReceiveList().size() == 0) {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            arrayList.add(Long.valueOf(orderRspBO.getCreateOperId()));
            orderSendMsgBusiReq.setReceiveList(arrayList);
        }
        orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getTemplateId());
        orderSendMsgBusiReq.setOrderId(reqBO.getOrderId());
        UocPebSendMsgRspBO uocPebSendMsgRspBO = this.uocPebSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
        if ((uocPebSendMsgRspBO == null || !"0000".equals(uocPebSendMsgRspBO.getRespCode())) && this.isDebugEnabled) {
            log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u7ad9\u5185\u4fe1\u53d1\u9001\u5931\u8d25.");
        }
        if (PecConstant.IS_DISPATCH_YES.equals(ordSaleRspBO.getIsDispatch())) {
            orderSendMsgBusiReq.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_DELIVERY_PSZZ);
            ArrayList<Long> receiveListOther = new ArrayList<Long>();
            receiveListOther.add(ordSaleRspBO.getContactId());
            orderSendMsgBusiReq.setReceiveList(receiveListOther);
            HashMap<String, String> templateParamsOther = new HashMap<String, String>();
            templateParamsOther.put("purchaseId", ordSaleRspBO.getSaleVoucherNo());
            templateParamsOther.put("purchaseName", (String)ordSaleRspBO.getSaleExtraMap().get("saleVoucherName"));
            templateParamsOther.put("shipId", shipVoucherCode);
            orderSendMsgBusiReq.setTemplateParam(templateParamsOther);
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getTemplateId());
            UocPebSendMsgRspBO uocPebSendMsgRspBOOther = this.uocPebSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            if ((uocPebSendMsgRspBOOther == null || !"0000".equals(uocPebSendMsgRspBOOther.getRespCode())) && this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u7ad9\u5185\u4fe1\u53d1\u9001\u5931\u8d25.");
            }
        }
    }

    private OrdItemMapPO qryOrdItemMap(OrdItemPO ordItemPO) {
        try {
            OrdItemMapPO ordItemMapModel = new OrdItemMapPO();
            ordItemMapModel.setOrderId(ordItemPO.getOrderId());
            ordItemMapModel.setOrderItemId(ordItemPO.getOrdItemId());
            ordItemMapModel.setFieldCode("planUserId");
            return this.ordItemMapMapper.getModelBy(ordItemMapModel);
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + ordItemPO.getOrdItemId() + "]\u7684\u6269\u5c55\u8868\u4e2d\u7684\u6269\u5c55\u5b57\u6bb5[planUserId]\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
            }
            throw new BusinessException("8888", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + ordItemPO.getOrdItemId() + "]\u7684\u6269\u5c55\u8868\u4e2d\u7684\u6269\u5c55\u5b57\u6bb5[planUserId]\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private void validationParams(UocPebOrderProcessReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null || reqBO.getOrderId() == 0L) {
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null || reqBO.getSaleVoucherId() == 0L) {
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u5916\u90e8\u5355\u53f7[processNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProcessName())) {
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u53d1\u8d27/\u65bd\u5de5/\u670d\u52a1\u8054\u7cfb\u4eba\u59d3\u540d[processName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getProcessPhone())) {
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u53d1\u8d27/\u65bd\u5de5/\u670d\u52a1\u8054\u7cfb\u4eba\u7535\u8bdd[processPhone]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getProcessCountList() == null || reqBO.getProcessCountList().isEmpty()) {
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u64cd\u4f5c\u8ba2\u5355\u660e\u7ec6\u5217\u8868[processCountList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProcessOrderCountBO processOrderCountBO : reqBO.getProcessCountList()) {
            if (processOrderCountBO.getSaleOrderItemId() == null || processOrderCountBO.getSaleOrderItemId() == 0L) {
                throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u64cd\u4f5c\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u4e2d\u9500\u552e\u8ba2\u5355\u660e\u7ec6ID[saleOrderItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (processOrderCountBO.getProcessCount() != null) continue;
            throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u64cd\u4f5c\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u4e2d\u53d1\u8d27/\u65bd\u5de5/\u670d\u52a1\u8ba2\u5355\u6570\u91cf[processCount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAccessoryShipList() != null && !reqBO.getAccessoryShipList().isEmpty()) {
            for (UocPebAccessoryBO uocPebAccessoryBO : reqBO.getAccessoryShipList()) {
                if (uocPebAccessoryBO.getAccessoryId() == null || uocPebAccessoryBO.getAccessoryId() == 0L) {
                    throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u9644\u4ef6\u5217\u8868\u4e2d\u7684\u9644\u4ef6ID[accessoryId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (uocPebAccessoryBO.getAttachmentType() == null) {
                    throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u9644\u4ef6\u5217\u8868\u4e2d\u7684\u9644\u4ef6\u7c7b\u578b[attachmentType]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)uocPebAccessoryBO.getAccessoryName())) {
                    throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u9644\u4ef6\u5217\u8868\u4e2d\u7684\u9644\u4ef6\u540d\u79f0[accessoryName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isEmpty((CharSequence)uocPebAccessoryBO.getAccessoryUrl())) continue;
                throw new BusinessException("7777", "\u6267\u884c\u7269\u8d44\u53d1\u8d27\uff0c\u65bd\u5de5/\u670d\u52a1\u5b8c\u5de5\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:\u5165\u53c2\u9644\u4ef6\u5217\u8868\u4e2d\u7684\u9644\u4ef6URL[accessoryUrl]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

