/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.el.other;

import com.tydic.order.pec.atom.el.other.UocPebSendMsgAtomService;
import com.tydic.order.pec.atom.el.other.bo.UocPebSendMsgReqBO;
import com.tydic.order.pec.atom.el.other.bo.UocPebSendMsgRspBO;
import com.tydic.order.pec.busi.el.other.UocPebTaskHandleBusiService;
import com.tydic.order.pec.busi.el.other.bo.UocPebTaskHandleReqBO;
import com.tydic.order.pec.busi.el.other.bo.UocPebTaskHandleRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebTaskHandleBusiService")
public class UocPebTaskHandleBusiServiceImpl
implements UocPebTaskHandleBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebTaskHandleBusiServiceImpl.class);
    @Autowired
    UocPebSendMsgAtomService uocPebSendMsgAtomService;
    @Autowired
    OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    OrdSaleMapper ordSaleMapper;
    @Autowired
    OrdExtMapMapper ordExtMapMapper;

    public UocPebTaskHandleRspBO dealTaskHandle(UocPebTaskHandleReqBO reqBO) {
        this.validateArg(reqBO);
        UocPebTaskHandleRspBO rspBO = new UocPebTaskHandleRspBO();
        if (!"PEB15".equals(reqBO.getTacheCode()) && !"PEB22".equals(reqBO.getTacheCode())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        try {
            OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setOrderId(reqBO.getOrderId());
            ordExtMapPO.setFieldCode("saleVoucherName");
            ordExtMapPO = this.ordExtMapMapper.getModelBy(ordExtMapPO);
            if (ordExtMapPO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1,\u67e5\u8be2\u8ba2\u5355\u540d\u79f0\u5931\u8d25");
                }
                throw new BusinessException("8888", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1,\u67e5\u8be2\u8ba2\u5355\u540d\u79f0\u5931\u8d25");
            }
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(reqBO.getOrderId());
            salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (salePO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1,\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5931\u8d25");
                }
                throw new BusinessException("8888", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1,\u67e5\u8be2\u9500\u552e\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
            if (stakeholderPO == null) {
                if (log.isDebugEnabled()) {
                    log.debug("\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1,\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                }
                throw new BusinessException("8888", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1,\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
            }
            if ("PEB15".equals(reqBO.getTacheCode())) {
                this.approvePassed_sendSMS(reqBO, stakeholderPO, salePO, ordExtMapPO);
            }
            if ("PEB22".equals(reqBO.getTacheCode())) {
                this.supplierRefused_sendPrivateLetter(reqBO, stakeholderPO, salePO, ordExtMapPO);
            }
        }
        catch (BusinessException e) {
            rspBO.setRespCode(e.getMsgCode());
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\uff1a" + e);
            }
            throw new BusinessException("8888", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateArg(UocPebTaskHandleReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("7777", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSaleVoucherId() == null) {
            throw new BusinessException("7777", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027saleVoucherId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("7777", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTacheCode())) {
            throw new BusinessException("7777", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5c5e\u6027tacheCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void approvePassed_sendSMS(UocPebTaskHandleReqBO reqBO, OrdStakeholderPO stakeholderPO, OrdSalePO salePO, OrdExtMapPO ordExtMapPO) {
        UocPebSendMsgReqBO sendMsgReqBO = new UocPebSendMsgReqBO();
        sendMsgReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<String> sendTypes = new ArrayList<String>();
        sendTypes.add("1");
        sendMsgReqBO.setSendTypes(sendTypes);
        HashMap<String, String> smsParam = new HashMap<String, String>(8);
        if (PecConstant.IS_DISPATCH_YES.equals(salePO.getIsDispatch())) {
            sendMsgReqBO.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_CONFIRM_DISPATCH_YES);
            smsParam.put("professionalOrgnization", stakeholderPO.getProName());
        } else if (PecConstant.IS_DISPATCH_NO.equals(salePO.getIsDispatch())) {
            sendMsgReqBO.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_CONFIRM_DISPATCH_NO);
            smsParam.put("purchaseName", stakeholderPO.getPurName());
        }
        smsParam.put("orderId", salePO.getSaleVoucherNo());
        smsParam.put("orderName", ordExtMapPO.getFieldValue());
        sendMsgReqBO.setTemplateParam(smsParam);
        sendMsgReqBO.setUserId(reqBO.getUserId() + "");
        sendMsgReqBO.setMobile(stakeholderPO.getSupRelaMobile());
        sendMsgReqBO.setRemindConfigureId(sendMsgReqBO.getTemplateId());
        UocPebSendMsgRspBO sendMsgRspBO = this.uocPebSendMsgAtomService.dealSendMsg(sendMsgReqBO);
        if (!"0000".equals(sendMsgRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + sendMsgRspBO.getRespDesc());
            }
            throw new BusinessException("8888", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + sendMsgRspBO.getRespDesc());
        }
    }

    private void supplierRefused_sendPrivateLetter(UocPebTaskHandleReqBO reqBO, OrdStakeholderPO stakeholderPO, OrdSalePO salePO, OrdExtMapPO ordExtMapPO) {
        UocPebSendMsgReqBO sendMsgReqBO = new UocPebSendMsgReqBO();
        sendMsgReqBO.setOrderId(reqBO.getOrderId());
        ArrayList<String> sendTypes = new ArrayList<String>();
        sendTypes.add("3");
        sendMsgReqBO.setSendTypes(sendTypes);
        HashMap<String, String> smsParam = new HashMap<String, String>(8);
        smsParam.put("orderId", salePO.getSaleVoucherNo());
        smsParam.put("orderName", ordExtMapPO.getFieldValue());
        ArrayList<Long> receivers = new ArrayList<Long>();
        if (PecConstant.IS_DISPATCH_YES.equals(salePO.getIsDispatch())) {
            if (stakeholderPO.getProDeliveryId() == null) {
                if (log.isDebugEnabled()) {
                    log.debug(reqBO.getOrderId() + "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u914d\u9001\u5458\u7f16\u53f7");
                }
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u914d\u9001\u5458\u7f16\u53f7");
            }
            sendMsgReqBO.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_REFUSE_DISPATCH_YES_JHCGY);
            receivers.add(Long.valueOf(stakeholderPO.getProDeliveryId()));
        } else if (PecConstant.IS_DISPATCH_NO.equals(salePO.getIsDispatch())) {
            sendMsgReqBO.setTemplateId(PecConstant.MSG_TEMPLATE_ID.SEND_ORDER_REFUSE_DISPATCH_NO_JHCGY);
            if (stakeholderPO.getPurPlaceOrderId() == null) {
                if (log.isDebugEnabled()) {
                    log.debug(reqBO.getOrderId() + "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u8d2d\u5355\u4f4d\u4e0b\u5355\u4eba\u7f16\u53f7");
                }
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u91c7\u8d2d\u5355\u4f4d\u4e0b\u5355\u4eba\u7f16\u53f7");
            }
            receivers.add(Long.valueOf(stakeholderPO.getPurPlaceOrderId()));
            smsParam.put("supplyName", stakeholderPO.getSupName());
        }
        sendMsgReqBO.setTemplateParam(smsParam);
        sendMsgReqBO.setReceiveList(receivers);
        sendMsgReqBO.setRemindConfigureId(sendMsgReqBO.getTemplateId());
        sendMsgReqBO.setUserId(reqBO.getUserId() + "");
        UocPebSendMsgRspBO sendMsgRspBO = this.uocPebSendMsgAtomService.dealSendMsg(sendMsgReqBO);
        if (!"0000".equals(sendMsgRspBO.getRespCode())) {
            if (log.isDebugEnabled()) {
                log.debug("\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + sendMsgRspBO.getRespDesc());
            }
            throw new BusinessException("8888", "\u4e13\u533a\u7279\u6b8a\u73af\u8282\u5904\u7406\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u4e13\u533a\u8ba2\u5355\u63d0\u9192\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u63cf\u8ff0\uff1a" + sendMsgRspBO.getRespDesc());
        }
    }
}

