/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.busi.impl.es.inspection;

import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.tydic.order.pec.atom.es.inspection.UocPebPushOrderInfo2PayCenterAtomService;
import com.tydic.order.pec.atom.es.inspection.UocPebSaleOrderInfoPushAtomService;
import com.tydic.order.pec.bo.es.inspection.PushOrderInfo2PayCenterReqBO;
import com.tydic.order.pec.bo.es.inspection.SaleOrderInfoPushReqBO;
import com.tydic.order.pec.bo.es.inspection.SaleOrderInfoPushRspBO;
import com.tydic.order.pec.bo.es.ship.UocPebSaleOrderConfirmReqBO;
import com.tydic.order.pec.bo.es.ship.UocPebSaleOrderConfirmRspBO;
import com.tydic.order.pec.busi.es.inspection.UocPebSaleOrderAllConfirmBusiService;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.atom.core.UocCoreExtFieldInAtomService;
import com.tydic.order.uoc.atom.core.bo.UocCoreExtFieldInReqBO;
import com.tydic.order.uoc.atom.core.bo.UocCoreExtFieldInRspBO;
import com.tydic.order.uoc.atom.inspection.UocCoreInspectionAtomService;
import com.tydic.order.uoc.atom.process.UocRunProcessAtomService;
import com.tydic.order.uoc.bo.FieldValueBO;
import com.tydic.order.uoc.bo.inspection.InspectionInfoBO;
import com.tydic.order.uoc.bo.inspection.StatusInfoBO;
import com.tydic.order.uoc.bo.inspection.UocCoreInspectionReqBO;
import com.tydic.order.uoc.bo.inspection.UocCoreInspectionRspBO;
import com.tydic.order.uoc.bo.process.UocProcessRunReqBO;
import com.tydic.order.uoc.bo.process.UocProcessRunRspBO;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.order.uoc.dao.OrdAfterServiceMapper;
import com.tydic.order.uoc.dao.OrdSaleMapper;
import com.tydic.order.uoc.dao.OrdShipItemMapper;
import com.tydic.order.uoc.dao.OrdShipMapper;
import com.tydic.order.uoc.dao.OrdStakeholderMapper;
import com.tydic.order.uoc.dao.po.OrdAfterServicePO;
import com.tydic.order.uoc.dao.po.OrdSalePO;
import com.tydic.order.uoc.dao.po.OrdShipItemPO;
import com.tydic.order.uoc.dao.po.OrdShipPO;
import com.tydic.order.uoc.dao.po.OrdStakeholderPO;
import com.tydic.order.uoc.utils.ElUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uocPebSaleOrderAllConfirmBusiService")
public class UocPebSaleOrderConfirmAllBusiServiceImpl
implements UocPebSaleOrderAllConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebSaleOrderConfirmAllBusiServiceImpl.class);
    public static final Integer ORDER_LEVEL = 2;
    private OrdStakeholderMapper ordStakeholderMapper;
    private UocPebPushOrderInfo2PayCenterAtomService uocPebPushOrderInfo2PayCenterAtomService;
    private UocCoreInspectionAtomService uocCoreInspectionAtomService;
    private OrdShipMapper ordShipMapper;
    private OrdSaleMapper ordSaleMapper;
    private OrdShipItemMapper ordShipItemMapper;
    private UocPebSaleOrderInfoPushAtomService uocPebSaleOrderInfoPushAtomService;
    private OrdAfterServiceMapper ordAfterServiceMapper;
    private UocRunProcessAtomService uocRunProcessAtomService;
    private UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService;
    @Value(value="${isActivationTemp}")
    private boolean isActivationTemp;

    @Autowired
    public UocPebSaleOrderConfirmAllBusiServiceImpl(OrdStakeholderMapper ordStakeholderMapper, OrdShipMapper ordShipMapper, UocPebPushOrderInfo2PayCenterAtomService uocPebPushOrderInfo2PayCenterAtomService, UocCoreInspectionAtomService uocCoreInspectionAtomService, OrdShipItemMapper ordShipItemMapper, OrdSaleMapper ordSaleMapper, UocPebSaleOrderInfoPushAtomService uocPebSaleOrderInfoPushAtomService, OrdAfterServiceMapper ordAfterServiceMapper, UocRunProcessAtomService uocRunProcessAtomService, UocCoreExtFieldInAtomService uocCoreExtFieldInAtomService) {
        this.ordAfterServiceMapper = ordAfterServiceMapper;
        this.ordSaleMapper = ordSaleMapper;
        this.ordShipMapper = ordShipMapper;
        this.ordShipItemMapper = ordShipItemMapper;
        this.ordStakeholderMapper = ordStakeholderMapper;
        this.uocPebPushOrderInfo2PayCenterAtomService = uocPebPushOrderInfo2PayCenterAtomService;
        this.uocCoreInspectionAtomService = uocCoreInspectionAtomService;
        this.uocPebSaleOrderInfoPushAtomService = uocPebSaleOrderInfoPushAtomService;
        this.uocRunProcessAtomService = uocRunProcessAtomService;
        this.uocCoreExtFieldInAtomService = uocCoreExtFieldInAtomService;
    }

    public UocPebSaleOrderConfirmRspBO dealUocPebSaleOrderConfirm(UocPebSaleOrderConfirmReqBO reqBO) {
        this.validateParam(reqBO);
        UocPebSaleOrderConfirmRspBO rsp = new UocPebSaleOrderConfirmRspBO();
        Boolean isCheckSuccess = this.checkIsExistAfsNotExecute(reqBO.getOrderId());
        if (!isCheckSuccess.booleanValue()) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u8ba2\u5355\u8fd8\u5b58\u6709\u672a\u5904\u7406\u7684\u552e\u540e\u8ba2\u5355\uff0c\u4e0d\u80fd\u8fdb\u884c\u5168\u90e8\u5230\u8d27\u9a8c\u6536\u64cd\u4f5c!");
            return rsp;
        }
        OrdSalePO modelBy = this.qryOrdSale(reqBO.getOrderId(), null);
        rsp.setSaleVoucherId(modelBy.getSaleVoucherId());
        List<OrdShipPO> ordShipPOList = this.qryOrdShipList(reqBO.getOrderId());
        for (OrdShipPO ordShipPOL : ordShipPOList) {
            String operId;
            Long orderId;
            UocCoreInspectionReqBO uocCoreInspectionBusiReqBO = this.translateUocCoreInspectionBusiReqBO(ordShipPOL, orderId = reqBO.getOrderId(), operId = reqBO.getOperId());
            UocCoreInspectionRspBO uocCoreInspectionBusiRspBO = this.uocCoreInspectionAtomService.dealCoreInspection(uocCoreInspectionBusiReqBO);
            if (!"0000".equals(uocCoreInspectionBusiRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + uocCoreInspectionBusiRspBO.getRespDesc());
            }
            OrdSalePO ordSale = this.qryOrdSale(orderId, ordShipPOL.getSaleVoucherId());
            SaleOrderInfoPushReqBO saleOrderInfoPushAtomReqBO = new SaleOrderInfoPushReqBO();
            if (ORDER_LEVEL.equals(ordSale.getOrderLevel())) {
                PushOrderInfo2PayCenterReqBO pushOrderInfo2PayCenterReqBO = new PushOrderInfo2PayCenterReqBO();
                pushOrderInfo2PayCenterReqBO.setInspectionVoucherId(uocCoreInspectionBusiRspBO.getInspectionVoucherId());
                pushOrderInfo2PayCenterReqBO.setOrderId(orderId);
                pushOrderInfo2PayCenterReqBO.setShipVocherId(ordShipPOL.getShipVoucherId());
                log.info("\u63a8\u9001\u6d88\u606f\u5230\u7ed3\u7b97\u4e2d\u5fc3\u5165\u53c2\uff1a" + pushOrderInfo2PayCenterReqBO.toString());
                RspBusiBaseBO rspBusiBaseBO = this.uocPebPushOrderInfo2PayCenterAtomService.push(pushOrderInfo2PayCenterReqBO);
                log.info("\u63a8\u9001\u6d88\u606f\u5230\u7ed3\u7b97\u4e2d\u5fc3\u51fa\u53c2\uff1a" + rspBusiBaseBO.toString());
                if ("0000".equals(rspBusiBaseBO.getRespCode())) {
                    saleOrderInfoPushAtomReqBO.setPushResult("0");
                    saleOrderInfoPushAtomReqBO.setRspInfo("\u63a8\u9001\u652f\u4ed8\u7ed3\u7b97\u6210\u529f:" + rspBusiBaseBO.getRespDesc());
                } else {
                    saleOrderInfoPushAtomReqBO.setPushResult("1");
                    saleOrderInfoPushAtomReqBO.setRspInfo("\u63a8\u9001\u652f\u4ed8\u7ed3\u7b97\u5931\u8d25:" + rspBusiBaseBO.getRespDesc());
                }
            } else {
                saleOrderInfoPushAtomReqBO.setPushResult("1");
                saleOrderInfoPushAtomReqBO.setRspInfo("\u975e\u4f01\u4e1a\u8ba2\u5355\u4e0d\u9700\u8981\u63a8\u9001\u652f\u4ed8\u7ed3\u7b97\u4e2d\u5fc3");
            }
            OrdStakeholderPO ordStakeholderPO = this.qryOrdStakeholder(orderId);
            saleOrderInfoPushAtomReqBO.setGoodsSupplierId(ElUtils.string2Long((String)ordStakeholderPO.getSupNo()));
            saleOrderInfoPushAtomReqBO.setOrderId(orderId);
            saleOrderInfoPushAtomReqBO.setPurchaserId(ElUtils.string2Long((String)ordStakeholderPO.getPurNo()));
            if (this.isActivationTemp) {
                String outOrderNo = ordShipPOL.getExtOrderId();
                if (outOrderNo != null && outOrderNo.indexOf("_") > 0) {
                    saleOrderInfoPushAtomReqBO.setOutOrderId(outOrderNo.substring(0, outOrderNo.lastIndexOf("_")));
                }
            } else {
                saleOrderInfoPushAtomReqBO.setOutOrderId(ordShipPOL.getExtOrderId());
            }
            saleOrderInfoPushAtomReqBO.setInspectionId(uocCoreInspectionBusiRspBO.getInspectionVoucherId());
            log.info("\u4e09\u65b9\u7535\u5546\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u5165\u53c2\uff1a" + saleOrderInfoPushAtomReqBO.toString());
            SaleOrderInfoPushRspBO saleOrderInfoPushAtomRspBO = this.uocPebSaleOrderInfoPushAtomService.dealSaleOrderInfoPush(saleOrderInfoPushAtomReqBO);
            log.info("\u4e09\u65b9\u7535\u5546\u786e\u8ba4\u6536\u8d27\u63a5\u53e3\u51fa\u53c2\uff1a" + saleOrderInfoPushAtomRspBO.toString());
        }
        ArrayList<FieldValueBO> extFieldList = new ArrayList<FieldValueBO>();
        FieldValueBO fieldValueBO = new FieldValueBO();
        fieldValueBO.setFieldCode("evaluateState");
        fieldValueBO.setFieldName("\u8ba2\u5355\u8bc4\u4ef7\u72b6\u6001");
        fieldValueBO.setFieldValue("0");
        extFieldList.add(fieldValueBO);
        UocCoreExtFieldInReqBO uocCoreExtFieldInReqBO = new UocCoreExtFieldInReqBO();
        uocCoreExtFieldInReqBO.setOrderId(reqBO.getOrderId());
        uocCoreExtFieldInReqBO.setObjType(PecConstant.OBJECT_TYPE_ORDER_SALE);
        uocCoreExtFieldInReqBO.setObjId(modelBy.getSaleVoucherId());
        uocCoreExtFieldInReqBO.setExtFieldList(extFieldList);
        UocCoreExtFieldInRspBO uocCoreExtFieldInRspBO = this.uocCoreExtFieldInAtomService.dealCoreExtFieldIn(uocCoreExtFieldInReqBO);
        if (!"0000".equals(uocCoreExtFieldInRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8bc4\u4ef7\u72b6\u6001\u6269\u5c55\u5c5e\u6027\u5165\u5e93\u5931\u8d25!" + uocCoreExtFieldInRspBO.getRespDesc());
        }
        this.runProcess(rsp.getSaleVoucherId(), reqBO.getOrderId(), reqBO.getOperId(), UocConstant.OBJ_TYPE.SALE);
        this.runProcess(ordShipPOList.get(0).getShipVoucherId(), reqBO.getOrderId(), reqBO.getOperId(), UocConstant.OBJ_TYPE.SHIP);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u7535\u5b50\u8d85\u5e02\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private OrdSalePO qryOrdSale(Long orderId, Long saleVoucherId) {
        OrdSalePO modelBy;
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(orderId);
        if (null != saleVoucherId) {
            salePO.setSaleVoucherId(saleVoucherId);
        }
        try {
            modelBy = this.ordSaleMapper.getModelBy(salePO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6839\u636eorderId\u67e5\u8be2\u9500\u552e\u5355\u83b7\u53d6saleVoucherId\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        }
        if (!UocConstant.SALE_ORDER_STATUS.ARRIVED.equals(modelBy.getSaleState()) && !UocConstant.SALE_ORDER_STATUS.ARRIVED_PART.equals(modelBy.getSaleState())) {
            throw new BusinessException("8888", "\u8be5\u8ba2\u5355\u7684\u9500\u552e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5230\u8d27\uff0c\u4e0d\u80fd\u8fdb\u884c\u5230\u8d27\u9a8c\u6536\uff01");
        }
        return modelBy;
    }

    private OrdStakeholderPO qryOrdStakeholder(Long orderId) {
        try {
            OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(orderId.longValue());
            if (ordStakeholderPO == null) {
                throw new BusinessException("8888", "\u8be5\u8ba2\u5355ID:" + orderId + "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u7b2c\u4e09\u65b9\u4fe1\u606f\uff01");
            }
            if (log.isDebugEnabled()) {
                log.debug("\u8f6c\u53d6\u8ba2\u5355\u4e09\u65b9\u4fe1\u606f\u8868\u91cc\u7684\u4fe1\u606f\u4e3a\uff1a" + ordStakeholderPO.toString());
            }
            return ordStakeholderPO;
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u6839\u636eorderId\u67e5\u8be2\u8ba2\u5355\u4e09\u65b9\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        }
    }

    private List<OrdShipPO> qryOrdShipList(Long orderId) {
        List ordShipPOList;
        OrdShipPO bliudOrdShipMapperPO = new OrdShipPO();
        bliudOrdShipMapperPO.setOrderId(orderId);
        try {
            ordShipPOList = this.ordShipMapper.getList(bliudOrdShipMapperPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u6839\u636eorderId\u67e5\u8be2\u53d1\u8d27\u5355\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a", (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)ordShipPOList)) {
            throw new BusinessException("8888", "\u8be5\u8ba2\u5355ID:" + orderId + "\u67e5\u8be2\u53d1\u8d27\u5355\u6ca1\u6709\u6570\u636e\uff01");
        }
        return ordShipPOList;
    }

    private Boolean checkIsExistAfsNotExecute(Long orderId) {
        List ordAfterServicePOS;
        boolean isCheckSuccess = true;
        OrdAfterServicePO ordAfterServicePO = new OrdAfterServicePO();
        ordAfterServicePO.setOrderId(orderId);
        try {
            ordAfterServicePOS = this.ordAfterServiceMapper.getList(ordAfterServicePO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
        for (OrdAfterServicePO afterServicePOL : ordAfterServicePOS) {
            if (UocConstant.AFS_ORDER_STATUS.SUCCESS.equals(afterServicePOL.getServState()) || UocConstant.AFS_ORDER_STATUS.CANCEL.equals(afterServicePOL.getServState()) || UocConstant.AFS_ORDER_STATUS.APPROVAL_FAILURE.equals(afterServicePOL.getServState())) continue;
            isCheckSuccess = false;
            break;
        }
        return isCheckSuccess;
    }

    private UocCoreInspectionReqBO translateUocCoreInspectionBusiReqBO(OrdShipPO ordShip, Long orderId, String userId) {
        UocCoreInspectionReqBO uocCoreInspectionBusiReqBO = new UocCoreInspectionReqBO();
        ArrayList<InspectionInfoBO> inspectionInfoList = new ArrayList<InspectionInfoBO>();
        try {
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setSaleVoucherId(ordShip.getSaleVoucherId());
            ordSalePO.setOrderId(orderId);
            OrdSalePO ordSale = this.ordSaleMapper.getModelBy(ordSalePO);
            ArrayList<StatusInfoBO> statusList = new ArrayList<StatusInfoBO>();
            StatusInfoBO statusInfoBO = new StatusInfoBO();
            statusInfoBO.setShipVoucherId(ordShip.getShipVoucherId());
            statusList.add(statusInfoBO);
            uocCoreInspectionBusiReqBO.setStatusList(statusList);
            uocCoreInspectionBusiReqBO.setOrderId(orderId);
            Map<String, Long> refundTotalAmountMap = this.qryAfsReturnAmout(orderId);
            uocCoreInspectionBusiReqBO.setInspectionFee(Long.valueOf(ordSale.getPurchaseFee() - refundTotalAmountMap.get("refundTotalPurchaseAmount")));
            uocCoreInspectionBusiReqBO.setInspectionSaleFee(Long.valueOf(ordSale.getSaleFee() - refundTotalAmountMap.get("refundTotalSaleAmount")));
            uocCoreInspectionBusiReqBO.setInspectionRemark(ordShip.getArriveRemark());
            uocCoreInspectionBusiReqBO.setInspectionOperId(userId);
            OrdShipItemPO ordShipItemPO = new OrdShipItemPO();
            ordShipItemPO.setShipVoucherId(ordShip.getShipVoucherId());
            ordShipItemPO.setOrderId(orderId);
            List ordShipItemPOList = this.ordShipItemMapper.getList(ordShipItemPO);
            for (OrdShipItemPO shipItemPO : ordShipItemPOList) {
                InspectionInfoBO inspectionInfoBO = new InspectionInfoBO();
                inspectionInfoBO.setShipItemId(shipItemPO.getShipItemId());
                inspectionInfoBO.setOrdItemId(shipItemPO.getOrdItemId());
                inspectionInfoBO.setShipVoucherId(ordShip.getShipVoucherId());
                inspectionInfoBO.setUnitName(shipItemPO.getUnitName());
                inspectionInfoBO.setInspectionCount(shipItemPO.getArriveCount().subtract(shipItemPO.getReturnCount()));
                inspectionInfoList.add(inspectionInfoBO);
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u7ec4\u88c5\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u8ba2\u5355\u9a8c\u6536\u539f\u5b50\u670d\u52a1\u5165\u53c2BO\u5f02\u5e38\uff1a" + e.getMessage());
        }
        uocCoreInspectionBusiReqBO.setInspectionInfoList(inspectionInfoList);
        return uocCoreInspectionBusiReqBO;
    }

    private Map<String, Long> qryAfsReturnAmout(Long orderId) {
        List ordAfterServicePOS;
        HashMap<String, Long> refundTotalAmountMap = new HashMap<String, Long>(2);
        OrdAfterServicePO ordAfterServiceModel = new OrdAfterServicePO();
        ordAfterServiceModel.setOrderId(orderId);
        ordAfterServiceModel.setServState(UocConstant.AFS_ORDER_STATUS.SUCCESS);
        try {
            ordAfterServicePOS = this.ordAfterServiceMapper.getList(ordAfterServiceModel);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
        Long refundTotalSaleAmount = 0L;
        Long refundTotalPurchaseAmount = 0L;
        for (OrdAfterServicePO ordAfterServicePO : ordAfterServicePOS) {
            if (null != ordAfterServicePO.getRetTotalSaleFee()) {
                refundTotalSaleAmount = refundTotalSaleAmount + ordAfterServicePO.getRetTotalSaleFee();
            }
            if (null == ordAfterServicePO.getRetTotalPurchaseFee()) continue;
            refundTotalPurchaseAmount = refundTotalPurchaseAmount + ordAfterServicePO.getRetTotalPurchaseFee();
        }
        refundTotalAmountMap.put("refundTotalSaleAmount", refundTotalSaleAmount);
        refundTotalAmountMap.put("refundTotalPurchaseAmount", refundTotalPurchaseAmount);
        return refundTotalAmountMap;
    }

    private void runProcess(Long objId, Long orderId, String operId, Integer objType) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setSysCode("UOC");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(orderId);
        processRunReqBO.setOperId(operId);
        HashMap map = new HashMap(0);
        processRunReqBO.setVariables(map);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u901a\u8fc7\u5165\u53c2\uff1a" + processRunReqBO.toString() + "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
    }

    private void validateParam(UocPebSaleOrderConfirmReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new BusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010OrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperId() == null) {
            throw new BusinessException("8888", "\u7535\u5b50\u8d85\u5e02\u786e\u8ba4\u6536\u8d27\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010OperId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

