/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.pec.comb.es.impl.abnormal;

import com.tydic.order.pec.ability.es.order.bo.UocPebAbnormalAuditReqBO;
import com.tydic.order.pec.ability.es.order.bo.UocPebAbnormalAuditRspBO;
import com.tydic.order.pec.bo.es.abnormal.UocPebAbnormalBO;
import com.tydic.order.pec.busi.es.abnormal.UocPebAbnormalAuditBusiService;
import com.tydic.order.pec.comb.es.abnormal.UocPebAbnormalAuditCombService;
import com.tydic.order.pec.comb.es.order.UocPebOrdIdxSyncCombService;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.order.pec.comb.es.order.bo.UocPebOrdIdxSyncRspBO;
import com.tydic.order.uoc.bo.order.OrdSaleRspBO;
import com.tydic.order.uoc.constant.UocConstant;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocPebAbnormalAuditCombService")
public class UocPebAbnormalAuditCombServiceImpl
implements UocPebAbnormalAuditCombService {
    @Autowired
    private UocPebAbnormalAuditBusiService uocPebAbnormalAuditBusiService;
    @Autowired
    private UocPebOrdIdxSyncCombService uocPebOrdIdxSyncCombService;
    private Logger logger = LoggerFactory.getLogger(UocPebAbnormalAuditCombServiceImpl.class);

    public UocPebAbnormalAuditRspBO audit(UocPebAbnormalAuditReqBO reqBO) {
        UocPebAbnormalAuditRspBO rspBO = this.uocPebAbnormalAuditBusiService.audit(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            for (UocPebAbnormalBO abnormalBO : reqBO.getAbnormalList()) {
                this.uocPebOrdIdxSync(abnormalBO.getOrderId(), abnormalBO.getAbnormalVoucherId(), UocConstant.OBJ_TYPE.ABNORMAL);
            }
            if (CollectionUtils.isNotEmpty((Collection)rspBO.getSaleIds())) {
                for (OrdSaleRspBO saleRspBO : rspBO.getSaleIds()) {
                    this.uocPebOrdIdxSync(saleRspBO.getOrderId(), saleRspBO.getSaleVoucherId(), UocConstant.OBJ_TYPE.SALE);
                }
            }
        }
        return rspBO;
    }

    private void uocPebOrdIdxSync(Long orderId, Long objId, Integer type) {
        UocPebOrdIdxSyncReqBO reqBO = new UocPebOrdIdxSyncReqBO();
        reqBO.setOrderId(orderId);
        reqBO.setObjId(objId);
        reqBO.setObjType(type);
        try {
            UocPebOrdIdxSyncRspBO uocPebOrdIdxSyncRspBO = this.uocPebOrdIdxSyncCombService.dealOrdIdxSync(reqBO);
            if (!"0000".equals(uocPebOrdIdxSyncRspBO.getRespCode())) {
                this.logger.error("\u66f4\u65b0\u7d22\u5f15\u8868" + uocPebOrdIdxSyncRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7d22\u5f15\u8868" + e.getMessage());
        }
    }
}

