/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.osworkflow.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.osworkflow.ability.OsworkflowStartProcAbilityService;
import com.tydic.osworkflow.ability.bo.StartCheckSubProcessReqBO;
import com.tydic.osworkflow.ability.bo.StartCheckSubProcessRespBO;
import com.tydic.osworkflow.ability.bo.StartWithInstanceReqBO;
import com.tydic.osworkflow.ability.bo.StartWithInstanceRespBO;
import com.tydic.osworkflow.ability.bo.StartWithOutInstanceReqBO;
import com.tydic.osworkflow.ability.bo.StartWithOutInstanceRespBO;
import com.tydic.osworkflow.ability.bo.StepInfoWithOutInst;
import com.tydic.osworkflow.ability.bo.TaskInfo;
import com.tydic.osworkflow.ability.bo.TaskInfoWithInst;
import com.tydic.osworkflow.approve.util.JsonUtil;
import com.tydic.osworkflow.engine.element.ConditionExpression;
import com.tydic.osworkflow.engine.element.ProcDefAndParsingInfo;
import com.tydic.osworkflow.engine.element.Step;
import com.tydic.osworkflow.engine.element.SubWorkflow;
import com.tydic.osworkflow.engine.exception.OsworkflowParamVerifyException;
import com.tydic.osworkflow.engine.inside.OsworkflowMqProducerService;
import com.tydic.osworkflow.engine.inside.OsworkflowXmlParseService;
import com.tydic.osworkflow.engine.runtime.MqInfo;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.osworkflow.engine.utils.ExecutorProcessPool;
import com.tydic.osworkflow.engine.utils.OsworkflowMqUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"osworkflow-rpc-service4/4.0.0/com.tydic.osworkflow.ability.OsworkflowStartProcAbilityService"})
public class OsworkflowStartProcAbilityServiceImpl
implements OsworkflowStartProcAbilityService {
    private static final Logger log = LoggerFactory.getLogger(OsworkflowStartProcAbilityServiceImpl.class);
    @Value(value="${os.mqIntervalTime:1000}")
    private Long osMqIntervalTime;
    @Autowired
    private ProcessService osWorkflowProcessService;
    @Autowired
    private OsworkflowMqProducerService osworkflowMqProducerService;
    @Autowired
    private OsworkflowMqUtil osworkflowMqUtil;
    @Autowired
    private OsworkflowXmlParseService osworkflowXmlParseService;

    @PostMapping(value={"startWithOutInstance"})
    public StartWithOutInstanceRespBO startWithOutInstance(@RequestBody StartWithOutInstanceReqBO startWithOutInstanceReqBO) {
        StartWithOutInstanceRespBO respBO = new StartWithOutInstanceRespBO();
        try {
            StepWithOutInstance stepWithOutInstance = this.osWorkflowProcessService.newProcessStartBuilder().procDefId(startWithOutInstanceReqBO.getProcDefId()).procDefKey(startWithOutInstanceReqBO.getProcDefKey()).sysCode(startWithOutInstanceReqBO.getSysCode()).variables(startWithOutInstanceReqBO.getVariables()).partitionKey(startWithOutInstanceReqBO.getPartitonKey()).functionId(startWithOutInstanceReqBO.getFunctionId()).menuId(startWithOutInstanceReqBO.getMenuId()).orgId(startWithOutInstanceReqBO.getOrgId()).orgTreeId(startWithOutInstanceReqBO.getOrgTreeId()).startWithOutInstance();
            if (stepWithOutInstance != null) {
                respBO.setRespCode("0000");
                respBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8(\u65e0\u5b9e\u4f8b)\u6210\u529f");
                StepInfoWithOutInst stepInfoWithOutInst = new StepInfoWithOutInst();
                stepInfoWithOutInst = (StepInfoWithOutInst)JsonUtil.js((Object)stepWithOutInstance, StepInfoWithOutInst.class);
                respBO.setStepInfoWithOutInst(stepInfoWithOutInst);
            } else {
                respBO.setRespCode("1001");
                respBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8(\u65e0\u5b9e\u4f8b)\u5931\u8d25");
            }
            return respBO;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            respBO.setRespCode("8888");
            respBO.setRespDesc(e.getMessage());
            return respBO;
        }
    }

    @PostMapping(value={"startWithInstance"})
    public StartWithInstanceRespBO startWithInstance(@RequestBody StartWithInstanceReqBO startWithInstanceReqBO) {
        StartWithInstanceRespBO respBO = new StartWithInstanceRespBO();
        try {
            NextStepsResult nextStepsResult = this.osWorkflowProcessService.newProcessStartBuilder().procDefId(startWithInstanceReqBO.getProcDefId()).procDefKey(startWithInstanceReqBO.getProcDefKey()).sysCode(startWithInstanceReqBO.getSysCode()).variables(startWithInstanceReqBO.getVariables()).procInstName(startWithInstanceReqBO.getProcInstName()).businessId(startWithInstanceReqBO.getBusinessId()).partitionKey(startWithInstanceReqBO.getPartitonKey()).functionId(startWithInstanceReqBO.getFunctionId()).menuId(startWithInstanceReqBO.getMenuId()).orgId(startWithInstanceReqBO.getOrgId()).orgTreeId(startWithInstanceReqBO.getOrgTreeId()).startWithInstance();
            if (nextStepsResult != null) {
                respBO.setRespCode("0000");
                respBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8(\u6709\u5b9e\u4f8b)\u6210\u529f");
                TaskInfoWithInst taskInfoWithInst = (TaskInfoWithInst)JSON.parseObject((String)JSON.toJSONString((Object)nextStepsResult, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), TaskInfoWithInst.class);
                ArrayList<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();
                for (Task task : nextStepsResult.getTaskList()) {
                    TaskInfo taskInfo = (TaskInfo)JSON.parseObject((String)JSON.toJSONString((Object)task, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), TaskInfo.class);
                    taskInfoList.add(taskInfo);
                }
                taskInfoWithInst.setTaskInfoList(taskInfoList);
                respBO.setTaskInfoWithInst(taskInfoWithInst);
            } else {
                respBO.setRespCode("1002");
                respBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8(\u6709\u5b9e\u4f8b)\u5931\u8d25");
            }
            return respBO;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            respBO.setRespCode("8888");
            respBO.setRespDesc(e.getMessage());
            return respBO;
        }
    }

    @PostMapping(value={"startWithInstanceByMq"})
    public StartWithInstanceRespBO startWithInstanceByMq(@RequestBody StartWithInstanceReqBO startWithInstanceReqBO) {
        StartWithInstanceRespBO respBO = new StartWithInstanceRespBO();
        try {
            NextStepsResult nextStepsResult = this.osWorkflowProcessService.newProcessStartBuilder().procDefId(startWithInstanceReqBO.getProcDefId()).procDefKey(startWithInstanceReqBO.getProcDefKey()).sysCode(startWithInstanceReqBO.getSysCode()).variables(startWithInstanceReqBO.getVariables()).subVariables(startWithInstanceReqBO.getSubVariables()).procInstName(startWithInstanceReqBO.getProcInstName()).businessId(startWithInstanceReqBO.getBusinessId()).partitionKey(startWithInstanceReqBO.getPartitonKey()).functionId(startWithInstanceReqBO.getFunctionId()).menuId(startWithInstanceReqBO.getMenuId()).orgId(startWithInstanceReqBO.getOrgId()).orgTreeId(startWithInstanceReqBO.getOrgTreeId()).startWithInstanceByMq();
            if (nextStepsResult != null) {
                respBO.setRespCode("0000");
                respBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8(\u6709\u5b9e\u4f8b)\u6210\u529f");
                TaskInfoWithInst taskInfoWithInst = (TaskInfoWithInst)JSON.parseObject((String)JSON.toJSONString((Object)nextStepsResult, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), TaskInfoWithInst.class);
                if (nextStepsResult.getTaskList() != null) {
                    List taskInfoList = JsonUtil.jsl((List)nextStepsResult.getTaskList(), TaskInfo.class);
                    taskInfoWithInst.setTaskInfoList(taskInfoList);
                }
                respBO.setTaskInfoWithInst(taskInfoWithInst);
                Runnable run = () -> {
                    if (nextStepsResult.getMqList() != null) {
                        List mqList = this.osworkflowMqUtil.sortMq(nextStepsResult.getMqList());
                        for (MqInfo mqInfo : mqList) {
                            try {
                                Thread.sleep(this.osMqIntervalTime);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.osworkflowMqProducerService.sendMqMessage(mqInfo.getTag(), mqInfo.getContent());
                        }
                    }
                };
                ExecutorProcessPool.getInstance().executeByCustomThread(run);
            } else {
                respBO.setRespCode("1002");
                respBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8(\u6709\u5b9e\u4f8b)\u5931\u8d25");
            }
            return respBO;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            respBO.setRespCode("8888");
            respBO.setRespDesc(e.getMessage());
            return respBO;
        }
    }

    @PostMapping(value={"startCheckSubProcess"})
    public StartCheckSubProcessRespBO startCheckSubProcess(@RequestBody StartCheckSubProcessReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getProcDefKey())) {
            throw new OsworkflowParamVerifyException("\u542f\u52a8\u68c0\u67e5\u5b50\u6d41\u7a0b\u5931\u8d25\uff1a\u6d41\u7a0b\u5b9a\u4e49key[procDefKey]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getStepId())) {
            throw new OsworkflowParamVerifyException("\u542f\u52a8\u68c0\u67e5\u5b50\u6d41\u7a0b\u5931\u8d25\uff1a\u6b65\u9aa4ID[stepId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getVariables() == null) {
            reqBO.setVariables(new HashMap());
        }
        StartCheckSubProcessRespBO rspBO = new StartCheckSubProcessRespBO();
        ArrayList<String> prodefIdList = new ArrayList<String>();
        ProcDefAndParsingInfo procDefAndParsingInfo = this.osworkflowXmlParseService.getProcDefAndParsingInfoByProcDefKey(reqBO.getProcDefKey(), reqBO.getSysCode(), Boolean.valueOf(false), null);
        if (procDefAndParsingInfo == null) {
            throw new OsworkflowParamVerifyException("\u542f\u52a8\u68c0\u67e5\u5b50\u6d41\u7a0b\u5931\u8d25\uff1a\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        Step step = (Step)procDefAndParsingInfo.getWorkflow().getStepMap().get(reqBO.getStepId());
        if (step == null) {
            throw new OsworkflowParamVerifyException("\u542f\u52a8\u68c0\u67e5\u5b50\u6d41\u7a0b\u5931\u8d25\uff1a\u6b65\u9aa4\u4e0d\u5b58\u5728");
        }
        for (SubWorkflow subWorkflow : step.getNewSubWorkflows()) {
            ConditionExpression conditionExpression = new ConditionExpression();
            conditionExpression.setValue(subWorkflow.getSubWorkflowStartCondition());
            if (!this.osworkflowXmlParseService.conditionExpressionRules(conditionExpression, reqBO.getVariables(), procDefAndParsingInfo.getWorkflow().getBaseInfo()).booleanValue()) continue;
            prodefIdList.add(subWorkflow.getProcDefId());
        }
        rspBO.setProdefIdList(prodefIdList);
        return rspBO;
    }
}

