/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BillConstant {

    public class CebPayConstants {
        public static final String BILL_FLAG_PAY = "1";
        public static final String BILL_FLAG_REFUND = "3";
    }

    public class BillCheckConfigResult {
        public static final String SUCCESS = "1";
        public static final String ERROR = "0";
    }

    public class BillCheckConfigEffFlag {
        public static final String YES = "1";
        public static final String NO = "0";
    }

    public class PayBillDayFlag {
        public static final String COUNT = "-2";
        public static final String OK = "1";
        public static final String FEE = "2";
        public static final String LESS = "3";
        public static final String MORE = "4";
    }

    public class DiffDealFlag {
        public static final long TODO = -1L;
        public static final long INIT = 0L;
        public static final long AUTO = 1L;
        public static final long HAND = 2L;
        public static final long MISPOS = 3L;
    }

    public class BillComparePara {
        public static final String PAY_BILL_DAY = "pay_bill_day";
        public static final String PAY_BILL_DAY_DEFAULT = "ok";
        public static final String BUSI_BILL_SPLIT_SIZE = "busi_bill_split_size";
        public static final String BUSI_BILL_SPLIT_SIZE_DEFAULT = "100000";
        public static final String BILL_SHARDING_TOTAL = "bill_split_total";
        public static final String BILL_SHARDING_TOTAL_DEFAULT = "1";
    }

    public class ProcessType {
        public static final String REFUND = "1";
        public static final String SUCCESS = "2";
    }

    public class DefaultOrder {
        public static final long ID = 0L;
    }

    public class BusiCmpResult {
        public static final String DEFAULT = "0";
        public static final String REFUND = "1";
        public static final String REPLENISH = "2";
    }

    public class BusiCmpFlag {
        public static final String DEFAULT = "0";
        public static final String SUCCESS = "1";
        public static final String FAIL = "2";
    }

    public class BillFlag {
        public static final String NO = "0";
        public static final String YES = "1";
    }

    public class CompareResultFlag {
        public static final long FAIL = -1L;
        public static final long DOING = 0L;
        public static final long SUCCESS = 1L;
    }

    public class DiffType {
        public static final int COUNT = -2;
        public static final int ORDER = 1;
        public static final int FEE = 2;
        public static final int LESS = 3;
        public static final int MORE = 4;
    }

    public static enum PaymentIns {
        MIS_POS(0L),
        WX_PAY(1L),
        ALI_PAY(2L),
        CASH_PAY(3L),
        WO_PAY(5L),
        HCX_PAY(6L),
        RED_PAY(7L),
        WAP_PAY(10L),
        CHINA_UNION_PAY(17L),
        ICBC_PAY(19L),
        CEB_PAY(12L),
        CHINA_BANK_PAY(18L),
        CNNC_PAY(16L);

        private Long paymentInsId;

        private PaymentIns(Long paymentInsId) {
            this.paymentInsId = paymentInsId;
        }

        public static List<Long> listPaymentIns() {
            ArrayList<Long> paymentInsList = new ArrayList<Long>(PaymentIns.values().length);
            for (PaymentIns paymentIns : PaymentIns.values()) {
                paymentInsList.add(paymentIns.getPaymentInsId());
            }
            return paymentInsList;
        }

        public static PaymentIns newInstance(Long paymentInsId) {
            for (PaymentIns paymentIns : PaymentIns.values()) {
                if (!Objects.equals(paymentInsId, paymentIns.getPaymentInsId())) continue;
                return paymentIns;
            }
            return null;
        }

        public Long getPaymentInsId() {
            return this.paymentInsId;
        }
    }

    public class ExecuteState {
        public static final int SUCCESS = 1;
        public static final int DOING = 2;
        public static final int EXCEPTION = 3;
    }

    public class ExecuteType {
        public static final int PAY_BILL_DAY = 0;
        public static final int DOWNLOAD = 1;
        public static final int SAVE = 2;
        public static final int EXECUTE = 3;
        public static final int BALANCE = 4;
    }
}

