/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.ability.api.NativePayAbilityService;
import com.tydic.payment.pay.bo.ability.NativeAliDataBo;
import com.tydic.payment.pay.bo.ability.NativeWxDataBo;
import com.tydic.payment.pay.bo.ability.req.NativePayAbilityReqBo;
import com.tydic.payment.pay.bo.ability.rsp.NativePayAbilityRspBo;
import com.tydic.payment.pay.bo.busi.req.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.bo.busi.rsp.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.bo.busi.rsp.PayOrderRspBo;
import com.tydic.payment.pay.bo.comb.req.UniPayCombReqBO;
import com.tydic.payment.pay.bo.comb.rsp.UniPayCombRspBO;
import com.tydic.payment.pay.busi.api.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.api.PayOrderBusiService;
import com.tydic.payment.pay.comb.api.UniPayCombService;
import com.tydic.payment.pay.comb.impl.UniPayCombServiceImpl;
import com.tydic.payment.pay.common.util.MoneyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="nativePayAbilityService")
public class NativePayAbilityServiceImpl
implements NativePayAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(UniPayCombServiceImpl.class);
    @Autowired
    private UniPayCombService uniPayCombService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;

    public NativePayAbilityRspBo dealPay(NativePayAbilityReqBo reqBo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u4ea7\u54c1\uff1a\u539f\u751f\u652f\u4ed8\u83b7\u53d6\u53c2\u6570\u5165\u53c2\u4e3a\uff1a" + JSONObject.toJSONString((Object)reqBo));
        }
        NativePayAbilityRspBo rspBo = new NativePayAbilityRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("busiId \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("out_order_id \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("payMethod \u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (!"12".equals(reqBo.getPayMethod()) && !"22".equals(reqBo.getPayMethod())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8bf7\u4f20\u5165\u6709\u6548\u7684 payMethod");
            return rspBo;
        }
        OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
        orderQueryConstructionReqBo.setBusiId(Long.valueOf(Long.parseLong(reqBo.getBusiId())));
        orderQueryConstructionReqBo.setOutOrderId(reqBo.getOutOrderId());
        OrderQueryConstructionRspBo rsp = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
        if (!"0000".equals(rsp.getRspCode())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u672a\u67e5\u8be2\u5230\u9884\u521b\u5efa\u8ba2\u5355ID  - outOrderId =" + reqBo.getOutOrderId());
            return rspBo;
        }
        PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(rsp.getOrderId());
        if (!"01".equals(payOrderRspBo.getOrderType())) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u8ba2\u5355ID\uff1aoutOrderId =" + reqBo.getOutOrderId() + "\u975e\u652f\u4ed8\u8ba2\u5355");
            return rspBo;
        }
        if ("A10".equals(payOrderRspBo.getOrderStatus())) {
            rspBo.setRspName("\u7acb\u5373\u652f\u4ed8\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            rspBo.setPayResultCode("FAIL");
            rspBo.setMsg("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u652f\u4ed8");
            return rspBo;
        }
        UniPayCombReqBO uniPayCombReqBO = new UniPayCombReqBO();
        uniPayCombReqBO.setOrderId(String.valueOf(rsp.getOrderId()));
        uniPayCombReqBO.setPayMethod(reqBo.getPayMethod());
        uniPayCombReqBO.setRealFee(MoneyUtils.haoToFen((Long)payOrderRspBo.getTotalFee()).toString());
        UniPayCombRspBO uniPayCombRspBO = null;
        try {
            uniPayCombRspBO = this.uniPayCombService.dealUniPay(uniPayCombReqBO);
        }
        catch (Exception e) {
            LOG.error("\u7edf\u4e00\u652f\u4ed8\u5931\u8d25");
        }
        rspBo.setRspCode(uniPayCombRspBO.getRspCode());
        rspBo.setRspName(uniPayCombRspBO.getRspName());
        if (!"0000".equals(uniPayCombRspBO.getRspCode())) {
            rspBo.setMsg(uniPayCombRspBO.getRspName());
            rspBo.setPayResultCode("FAIL");
        } else {
            rspBo.setRedirectUrl((String)uniPayCombRspBO.getParams().get("redirectUrl"));
            rspBo.setPayResultCode("SUCCESS");
            if ("22".equals(reqBo.getPayMethod())) {
                NativeAliDataBo ali = new NativeAliDataBo();
                ali.setData((String)uniPayCombRspBO.getParams().get("body"));
                rspBo.setAliDataBo(ali);
            }
            if ("12".equals(reqBo.getPayMethod())) {
                NativeWxDataBo wx = new NativeWxDataBo();
                wx.setAppid((String)uniPayCombRspBO.getParams().get("appId"));
                wx.setNoncestr((String)uniPayCombRspBO.getParams().get("nonceStr"));
                wx.setPackage_((String)uniPayCombRspBO.getParams().get("package_"));
                wx.setPartnerid((String)uniPayCombRspBO.getParams().get("partnerId"));
                wx.setPrepay_id((String)uniPayCombRspBO.getParams().get("prepayId"));
                wx.setSign((String)uniPayCombRspBO.getParams().get("sign"));
                wx.setTimestamp((String)uniPayCombRspBO.getParams().get("redirectUrl"));
                rspBo.setWxDataBo(wx);
            }
        }
        return rspBo;
    }
}

