/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.ability.api.RefundEncryptService;
import com.tydic.payment.pay.bo.ability.req.RefundEncryptReqBo;
import com.tydic.payment.pay.bo.ability.rsp.RefundEncryptRspBo;
import com.tydic.payment.pay.bo.busi.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.bo.busi.req.DataEncryptionReqBo;
import com.tydic.payment.pay.bo.busi.req.DataValidationReqBO;
import com.tydic.payment.pay.bo.busi.req.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.bo.busi.rsp.DataEncryptionRspBo;
import com.tydic.payment.pay.bo.busi.rsp.DataValidationRspBO;
import com.tydic.payment.pay.bo.busi.rsp.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.bo.comb.req.RefundCombReqBO;
import com.tydic.payment.pay.bo.comb.rsp.RefundCombRspBO;
import com.tydic.payment.pay.busi.api.DataEncryptionService;
import com.tydic.payment.pay.busi.api.DataValidationService;
import com.tydic.payment.pay.busi.api.QueryInfoBusiSystemService;
import com.tydic.payment.pay.comb.api.RefundCombService;
import com.tydic.payment.pay.common.util.MapUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="refundEncryptService")
public class RefundEncryptServiceImpl
implements RefundEncryptService {
    private static final Logger LOGE = LoggerFactory.getLogger(RefundEncryptServiceImpl.class);
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private RefundCombService refundCombService;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;

    public RefundEncryptRspBo dealRefund(RefundEncryptReqBo refundEncryptReqBo) {
        if (refundEncryptReqBo == null) {
            if (LOGE.isDebugEnabled()) {
                LOGE.debug("\u64a4\u5355\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u9500\u8ba2\u5355\u5165\u53c2\u4e0d\u80fd\u7a7a");
        }
        String busiId = refundEncryptReqBo.getBusiId();
        String content = refundEncryptReqBo.getContent();
        RefundEncryptRspBo rspBo = new RefundEncryptRspBo();
        QueryInfoBusiSystemReqBo bo = new QueryInfoBusiSystemReqBo();
        bo.setBusiCode(busiId);
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(bo);
        if ("8888".equals(queryInfoBusiSystemRspBo.getRspCode())) {
            if (LOGE.isDebugEnabled()) {
                LOGE.debug("\u6e05\u7b97\u8ba2\u5355\u4e2d\u5fc3\u4e0b\u5355\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u7cfb\u7edf\u7f16\u7801\uff1a" + busiId);
            }
            rspBo.setRspCode("\u5931\u8d25");
            rspBo.setRspName("\u4e1a\u52a1\u3010busi_id=" + busiId + "\u3011\u4e0d\u5b58\u5728");
            return rspBo;
        }
        DataValidationReqBO req = new DataValidationReqBO();
        req.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
        req.setContent(content);
        DataValidationRspBO dataValidationRspBO = null;
        try {
            dataValidationRspBO = this.dataValidationService.validation(req);
        }
        catch (Exception e) {
            LOGE.error("\u8ba2\u5355\u52a0\u5bc6\u5f02\u5e38");
        }
        if (dataValidationRspBO.isSign()) {
            RefundCombReqBO refundCombReqBO = new RefundCombReqBO();
            try {
                refundCombReqBO = (RefundCombReqBO)MapUtils.mapToObject((Map)dataValidationRspBO.getContentMap(), RefundCombReqBO.class);
            }
            catch (Exception e) {
                LOGE.error("\u9000\u6b3e\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a map to RefundCombReqBO.class ");
            }
            refundCombReqBO.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
            refundCombReqBO.setBusiCode(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiCode());
            if (StringUtils.isEmpty((Object)refundCombReqBO.getRefundFlag())) {
                refundCombReqBO.setRefundFlag("0");
            }
            RefundCombRspBO refundCombRspBO = null;
            try {
                refundCombRspBO = this.refundCombService.dealRefund(refundCombReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!"0000".equals(refundCombRspBO.getRspCode())) {
                rspBo.setRspCode(refundCombRspBO.getRspCode());
                rspBo.setRspName(refundCombRspBO.getRspName());
                return rspBo;
            }
            JSONObject obj = (JSONObject)JSONObject.toJSON((Object)refundCombRspBO);
            obj.remove((Object)"rspCode");
            obj.remove((Object)"rspName");
            DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
            dataEncryptionReqBo.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId());
            dataEncryptionReqBo.setContent(obj.toString());
            DataEncryptionRspBo encryData = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
            if (!"0000".equals(encryData.getRspCode())) {
                rspBo.setRspCode("8888");
                rspBo.setRspName(encryData.getRspName());
                return rspBo;
            }
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            rspBo.setBusiId(busiId);
            rspBo.setContent(encryData.getEncrypData());
        } else {
            LOGE.info("\u8ba2\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8ba2\u5355\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c \u8bf7\u786e\u5b9a\u7b7e\u540d\u5bc6\u94a5\u662f\u5426\u6b63\u786e\uff01");
        }
        return rspBo;
    }
}

