/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.ability.api.WspPayOutAbilityService;
import com.tydic.payment.pay.bo.ability.req.WspPayOutAbilityReqBO;
import com.tydic.payment.pay.bo.ability.rsp.WspPayOutAbilityRspBO;
import com.tydic.payment.pay.bo.busi.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.bo.busi.req.DataEncryptionReqBo;
import com.tydic.payment.pay.bo.busi.req.DataValidationReqBO;
import com.tydic.payment.pay.bo.busi.req.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.bo.busi.rsp.DataEncryptionRspBo;
import com.tydic.payment.pay.bo.busi.rsp.DataValidationRspBO;
import com.tydic.payment.pay.bo.busi.rsp.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.bo.comb.req.WspPayComReqBO;
import com.tydic.payment.pay.bo.comb.rsp.WspPayComRspBO;
import com.tydic.payment.pay.busi.api.DataEncryptionService;
import com.tydic.payment.pay.busi.api.DataValidationService;
import com.tydic.payment.pay.busi.api.QueryInfoBusiSystemService;
import com.tydic.payment.pay.comb.api.WspPayCombService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pmcWspPayOutAbilityService")
public class WspPayOutAbilityServiceImpl
implements WspPayOutAbilityService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    @Autowired
    private WspPayCombService wspPayCombService;
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private DataValidationService dataValidationService;
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;

    public WspPayOutAbilityRspBO wspPayAbility(WspPayOutAbilityReqBO wspPayOutAbilityReqBO) {
        this.checkReqBO(wspPayOutAbilityReqBO);
        return this.encryptRspBO(this.wspPayCombService.wspPay(this.decryptReqBO(wspPayOutAbilityReqBO)));
    }

    private WspPayComReqBO decryptReqBO(WspPayOutAbilityReqBO wspPayOutAbilityReqBO) {
        DataValidationRspBO dataValidationRspBO;
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u89e3\u5bc6\u524d\uff1a{}", wspPayOutAbilityReqBO);
        DataValidationReqBO dataValidationReqBO = new DataValidationReqBO();
        QueryInfoBusiSystemReqBo bo = new QueryInfoBusiSystemReqBo();
        String busiId = wspPayOutAbilityReqBO.getBusiId();
        bo.setBusiCode(busiId);
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(bo);
        if (!"0000".equals(queryInfoBusiSystemRspBo.getRspCode()) || queryInfoBusiSystemRspBo.getInfoBusiBoList() == null || queryInfoBusiSystemRspBo.getInfoBusiBoList().isEmpty()) {
            this.logger.error("\u6e05\u7b97\u8ba2\u5355\u4e2d\u5fc3\u4e0b\u5355\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u7cfb\u7edf\u7f16\u7801\uff1a" + busiId);
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636ebusi_code\u67e5\u8be2busi_id\u4e3a\u7a7a");
        }
        String realBusiId = ((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiId();
        String busiCode = ((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiCode();
        this.logger.info("\u5c0f\u7a0b\u5e8f\u4e0b\u5355\u670d\u52a1\u67e5\u8be2\u771f\u5b9ebusi_id\u4e3a\uff1a" + realBusiId);
        dataValidationReqBO.setBusiId(realBusiId);
        dataValidationReqBO.setContent(wspPayOutAbilityReqBO.getContent());
        try {
            dataValidationRspBO = this.dataValidationService.validation(dataValidationReqBO);
        }
        catch (Exception e) {
            if (this.isDebug) {
                e.printStackTrace();
            }
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (null == dataValidationRspBO || !"0000".equals(dataValidationRspBO.getRspCode())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5f02\u5e38");
        }
        if (!dataValidationRspBO.isSign()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6570\u636e\u6821\u9a8c\u5931\u8d25");
        }
        WspPayComReqBO wspPayReqBO = (WspPayComReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dataValidationRspBO.getContentMap()), WspPayComReqBO.class);
        wspPayReqBO.setBusiId(realBusiId);
        wspPayReqBO.setBusiCode(busiCode);
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\u89e3\u5bc6\u540e\uff1a{}", wspPayReqBO);
        return wspPayReqBO;
    }

    private WspPayOutAbilityRspBO encryptRspBO(WspPayComRspBO wspPayRspBO) {
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u54cd\u5e94\u53c2\u6570\u52a0\u5bc6\u524d\uff1a{}", wspPayRspBO);
        WspPayOutAbilityRspBO wspPayOutAbilityRspBO = new WspPayOutAbilityRspBO();
        DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
        dataEncryptionReqBo.setBusiId(wspPayRspBO.getBusiId());
        dataEncryptionReqBo.setContent(JSONObject.toJSONString((Object)wspPayRspBO));
        DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
        if (null == dataEncryptionRspBo || !"0000".equals(dataEncryptionRspBo.getRspCode())) {
            wspPayOutAbilityRspBO.setRspCode("0000");
            wspPayOutAbilityRspBO.setRspName("\u54cd\u5e94\u53c2\u6570\u52a0\u5bc6\u5f02\u5e38");
            return wspPayOutAbilityRspBO;
        }
        QueryInfoBusiSystemReqBo bo = new QueryInfoBusiSystemReqBo();
        bo.setBusiId(wspPayRspBO.getBusiId());
        QueryInfoBusiSystemRspBo queryInfoBusiSystemRspBo = this.queryInfoBusiSystemService.queryInfoBusiSystem(bo);
        wspPayOutAbilityRspBO.setRspCode("0000");
        wspPayOutAbilityRspBO.setRspName("\u6210\u529f");
        wspPayOutAbilityRspBO.setContent(dataEncryptionRspBo.getEncrypData());
        wspPayOutAbilityRspBO.setBusiId(((QueryInfoBusiSystemBo)queryInfoBusiSystemRspBo.getInfoBusiBoList().get(0)).getBusiCode());
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u54cd\u5e94\u53c2\u6570\u52a0\u5bc6\u540e\uff1a{}", wspPayOutAbilityRspBO);
        return wspPayOutAbilityRspBO;
    }

    private void checkReqBO(WspPayOutAbilityReqBO reqBO) {
        this.debugLog("\u5c0f\u7a0b\u5e8f\u6216\u516c\u4f17\u53f7\u652f\u4ed8\u4e0b\u5355\u8bf7\u6c42\u53c2\u6570\uff1a{}", reqBO);
        if (null == reqBO) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getBusiId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743 BUSI_ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getContent())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743 CONTENT \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void debugLog(String str, Object o) {
        if (this.isDebug) {
            this.logger.debug(str, o);
        }
    }
}

