/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.service.impl;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.tydic.payment.pay.ali.model.RequestBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbsAlipayService {
    protected Log log = LogFactory.getLog(this.getClass());

    AbsAlipayService() {
    }

    protected void validateBuilder(RequestBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder should not be NULL!");
        }
        if (!builder.validate()) {
            throw new IllegalStateException("builder validate failed! " + builder.toString());
        }
    }

    protected AlipayResponse getResponse(AlipayClient client, AlipayRequest request) {
        try {
            AlipayResponse response = client.execute(request);
            if (response != null) {
                this.log.info((Object)response.getBody());
            }
            return response;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected AlipayResponse getAppResponse(AlipayClient client, AlipayRequest request) {
        try {
            AlipayResponse response = client.sdkExecute(request);
            if (response != null) {
                this.log.info((Object)response.getBody());
            }
            return response;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected AlipayResponse getH5Response(AlipayClient client, AlipayRequest request) {
        this.log.info((Object)request.getNotifyUrl());
        this.log.info((Object)request.getReturnUrl());
        this.log.info((Object)request.getBizModel());
        try {
            AlipayResponse response = client.pageExecute(request);
            if (response != null) {
                this.log.info((Object)response.getBody());
            }
            return response;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }
}

