/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ali.service.impl;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayTradePayRequest;
import com.alipay.api.response.AlipayTradePayResponse;
import com.tydic.payment.pay.ali.common.Configs;
import com.tydic.payment.pay.ali.common.HbListener;
import com.tydic.payment.pay.ali.common.TradeListener;
import com.tydic.payment.pay.ali.model.AlipayF2FPayResult;
import com.tydic.payment.pay.ali.model.AlipayTradePayRequestBuilder;
import com.tydic.payment.pay.ali.service.impl.AbsAlipayTradeService;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang.StringUtils;

public class AlipayWebPayServiceImpl
extends AbsAlipayTradeService {
    private TradeListener listener;

    public AlipayWebPayServiceImpl(ClientBuilder builder) {
        builder.setGatewayUrl("https://openapi.alipay.com/gateway.do");
        if (StringUtils.isEmpty((String)builder.getGatewayUrl())) {
            throw new NullPointerException("gatewayUrl should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAppid())) {
            throw new NullPointerException("appid should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getPrivateKey())) {
            throw new NullPointerException("privateKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getFormat())) {
            throw new NullPointerException("format should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getCharset())) {
            throw new NullPointerException("charset should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getAlipayPublicKey())) {
            throw new NullPointerException("alipayPublicKey should not be NULL!");
        }
        if (StringUtils.isEmpty((String)builder.getSignType())) {
            throw new NullPointerException("signType should not be NULL!");
        }
        if (builder.getListener() == null) {
            throw new NullPointerException("listener should not be NULL!");
        }
        this.listener = builder.getListener();
        this.client = new DefaultAlipayClient(builder.getGatewayUrl(), builder.getAppid(), builder.getPrivateKey(), builder.getFormat(), builder.getCharset(), builder.getAlipayPublicKey(), builder.getSignType());
    }

    private AlipayTradePayResponse getResponse(AlipayClient client, AlipayTradePayRequest request, final String outTradeNo, final long beforeCall) {
        try {
            AlipayTradePayResponse response = (AlipayTradePayResponse)client.execute((AlipayRequest)request);
            if (response != null) {
                this.log.info((Object)response.getBody());
            }
            return response;
        }
        catch (AlipayApiException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException || cause instanceof NoRouteToHostException) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        AlipayWebPayServiceImpl.this.listener.onConnectException(outTradeNo, beforeCall);
                    }
                });
            } else if (cause instanceof SocketException) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        AlipayWebPayServiceImpl.this.listener.onSendException(outTradeNo, beforeCall);
                    }
                });
            } else if (cause instanceof SocketTimeoutException) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        AlipayWebPayServiceImpl.this.listener.onReceiveException(outTradeNo, beforeCall);
                    }
                });
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public AlipayF2FPayResult tradePay(AlipayTradePayRequestBuilder builder) {
        return null;
    }

    public static class ClientBuilder {
        private String gatewayUrl;
        private String appid;
        private String privateKey;
        private String format;
        private String charset;
        private String alipayPublicKey;
        private String signType;
        private TradeListener listener;

        public AlipayWebPayServiceImpl build() {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getOpenApiDomain();
            }
            if (StringUtils.isEmpty((String)this.appid)) {
                this.appid = Configs.getAppid();
            }
            if (StringUtils.isEmpty((String)this.privateKey)) {
                this.privateKey = Configs.getPrivateKey();
            }
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.alipayPublicKey)) {
                this.alipayPublicKey = Configs.getAlipayPublicKey();
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                this.signType = Configs.getSignType();
            }
            if (this.listener == null) {
                this.listener = new HbListener();
            }
            return new AlipayWebPayServiceImpl(this);
        }

        public AlipayWebPayServiceImpl build(String appid, String privateKey, String alipayPublicKey) {
            if (StringUtils.isEmpty((String)this.gatewayUrl)) {
                this.gatewayUrl = Configs.getOpenApiDomain();
            }
            this.appid = appid;
            this.privateKey = privateKey;
            this.alipayPublicKey = alipayPublicKey;
            if (StringUtils.isEmpty((String)this.format)) {
                this.format = "json";
            }
            if (StringUtils.isEmpty((String)this.charset)) {
                this.charset = "utf-8";
            }
            if (StringUtils.isEmpty((String)this.signType)) {
                this.signType = Configs.getSignType();
            }
            if (this.listener == null) {
                this.listener = new HbListener();
            }
            return new AlipayWebPayServiceImpl(this);
        }

        public TradeListener getListener() {
            return this.listener;
        }

        public ClientBuilder setListener(TradeListener listener) {
            this.listener = listener;
            return this;
        }

        public ClientBuilder setAlipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public ClientBuilder setAppid(String appid) {
            this.appid = appid;
            return this;
        }

        public ClientBuilder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public ClientBuilder setFormat(String format) {
            this.format = format;
            return this;
        }

        public ClientBuilder setGatewayUrl(String gatewayUrl) {
            this.gatewayUrl = gatewayUrl;
            return this;
        }

        public ClientBuilder setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public ClientBuilder setSignType(String signType) {
            this.signType = signType;
            return this;
        }

        public String getAlipayPublicKey() {
            return this.alipayPublicKey;
        }

        public String getSignType() {
            return this.signType;
        }

        public String getAppid() {
            return this.appid;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getFormat() {
            return this.format;
        }

        public String getGatewayUrl() {
            return this.gatewayUrl;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }
}

