/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.common.util.MD5;
import com.tydic.payment.pay.common.util.SSLClient;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="abilityToPayPlatformService")
public class AbilityToPayPlatformServiceImpl
implements AbilityToPayPlatformService {
    private static final Logger log = LoggerFactory.getLogger(AbilityToPayPlatformServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    @Override
    public String abilityToPayPlatform(String url, Object body) throws Exception {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new Exception("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u7684\u5730\u5740url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (body == null) {
            throw new Exception("\u8bf7\u6c42\u5165\u53c2body\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (body.toString().length() > 100000) {
            throw new Exception("\u6570\u636e\u8d85\u957f\u4e86 \uff0c \u9700\u8981\u8fdb\u884c\u538b\u7f29");
        }
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS").format(new Date());
        String appId = this.payPropertiesVo.getAbilityAppId();
        String trans_id = new SimpleDateFormat("yyyyMMddhhmmssSSS").format(new Date());
        String app_secret = this.payPropertiesVo.getAbilityAppSecret();
        String readyEncryptStr = "APP_ID" + appId + "TIMESTAMP" + timeStamp + "TRANS_ID" + trans_id + app_secret;
        String token = MD5.MD5_32bit((String)readyEncryptStr).toLowerCase();
        JSONObject bss_head = new JSONObject();
        JSONObject bss_attached = new JSONObject();
        bss_head.put("APP_ID", (Object)appId);
        bss_head.put("TIMESTAMP", (Object)timeStamp);
        bss_head.put("TRANS_ID", (Object)trans_id);
        bss_head.put("TOKEN", (Object)token);
        bss_attached.put("MEDIA_INFO", (Object)"");
        JSONObject data = new JSONObject();
        data.put("UNI_BSS_HEAD", (Object)bss_head);
        data.put("UNI_BSS_BODY", body);
        data.put("UNI_BSS_ATTACHED", (Object)bss_attached);
        HttpRequest http = new HttpRequest();
        String result = http.sendPost(url, data);
        log.info("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + result);
        return result;
    }

    public static class HttpRequest {
        private boolean hasInit = false;
        private int socketTimeout = 10000;
        private int connectTimeout = 30000;
        private RequestConfig requestConfig;
        private CloseableHttpClient httpClient;

        public String sendPost(String url, Object xmlObj) throws Exception {
            log.info("\u80fd\u529b\u5e73\u53f0\u8bf7\u6c42\u62a5\u6587====" + xmlObj);
            String result = null;
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.addHeader("Accept-Encoding", "");
            httpPost.addHeader("Accept", "application/json");
            StringEntity postEntity = new StringEntity(xmlObj.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)postEntity);
            httpPost.setConfig(this.requestConfig);
            try {
                this.httpClient = new SSLClient();
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                log.info("\u80fd\u529b\u5e73\u53f0\u8fd4\u56de\uff1a" + result);
            }
            catch (ConnectionPoolTimeoutException e) {
                System.out.println("http get throw ConnectionPoolTimeoutException(wait time out)");
                throw new ResourceException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u5f02\u5e38\uff1a" + (Object)((Object)e));
            }
            catch (ConnectTimeoutException e) {
                System.out.println("http get throw ConnectTimeoutException");
                throw new ResourceException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u5f02\u5e38\uff1a" + (Object)((Object)e));
            }
            catch (SocketTimeoutException e) {
                System.out.println("http get throw SocketTimeoutException");
                throw new ResourceException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u5f02\u5e38\uff1a" + e);
            }
            catch (Exception e) {
                System.out.println("http get throw Exception");
                throw new ResourceException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u5f02\u5e38\uff1a" + e);
            }
            finally {
                httpPost.abort();
            }
            return result;
        }
    }
}

