/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BillCompareParaAtomService;
import com.tydic.payment.pay.dao.BillCompareParaMapper;
import com.tydic.payment.pay.dao.po.BillCompareParaPO;
import com.tydic.payment.pay.dao.po.BillCompareParaPageReqPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="billCompareParaAtomService")
public class BillCompareParaAtomServiceImpl
implements BillCompareParaAtomService {
    @Autowired
    BillCompareParaMapper billCompareParaMapper;

    @Override
    public BillCompareParaPO getByAttrCode(String attrCode) {
        if (StringUtils.isEmpty((String)attrCode)) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u67e5\u8be2P_BILL_COMPARE_PARA\u5165\u53c2attrCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillCompareParaPO billRspPo = this.billCompareParaMapper.getByAttrCode(attrCode);
        return billRspPo;
    }

    @Override
    public List<BillCompareParaPO> getByAttrCodeWithPage(Page<BillCompareParaPageReqPO> page, BillCompareParaPageReqPO reqPO) {
        List<BillCompareParaPO> billCompareParaPOList;
        if (reqPO == null) {
            reqPO = new BillCompareParaPageReqPO();
        }
        if (page == null) {
            page = new Page();
        }
        if (CollectionUtils.isEmpty(billCompareParaPOList = this.billCompareParaMapper.getByAttrCodeWithPage((Page<BillCompareParaPageReqPO>)page, reqPO))) {
            billCompareParaPOList = new ArrayList<BillCompareParaPO>();
        }
        return billCompareParaPOList;
    }

    @Override
    public int insert(BillCompareParaPO reqPO) {
        this.validateArgInsert(reqPO);
        int addPara = this.billCompareParaMapper.insert(reqPO);
        if (addPara < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_BILL_COMPARE_PARA\u8868mapper\u5931\u8d25");
        }
        return addPara;
    }

    private void validateArgInsert(BillCompareParaPO reqPO) {
        if (reqPO == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_BILL_COMPARE_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqPO.getAttrId() != null) {
            reqPO.setAttrId(null);
        }
        if (StringUtils.isEmpty((String)reqPO.getAttrCode())) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_BILL_COMPARE_PARA\u5165\u53c2\u5c5e\u6027attrCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqPO.getAttrValue())) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_BILL_COMPARE_PARA\u5165\u53c2\u5c5e\u6027attrValue\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int update(BillCompareParaPO reqPO) {
        this.validateArgUpdate(reqPO);
        int updatePara = this.billCompareParaMapper.update(reqPO);
        if (updatePara < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u4fee\u6539P_BILL_COMPARE_PARA\u8868mapper\u5931\u8d25");
        }
        return updatePara;
    }

    private void validateArgUpdate(BillCompareParaPO reqPO) {
        if (reqPO == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0P_BILL_COMPARE_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqPO.getAttrId() == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0P_BILL_COMPARE_PARA\u5165\u53c2\u5c5e\u6027attrId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int deleteByOne(Long attrId) {
        int delPara = this.billCompareParaMapper.deleteByOne(attrId);
        if (delPara < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u5220\u9664P_BILL_COMPARE_PARA\u8868mapper\u5931\u8d25");
        }
        return delPara;
    }

    @Override
    public int deleteByList(List<Long> attrIds) {
        int delPara = this.billCompareParaMapper.deleteByList(attrIds);
        if (delPara < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u5220\u9664P_BILL_COMPARE_PARA\u8868mapper\u5931\u8d25");
        }
        return delPara;
    }

    @Override
    public List<BillCompareParaPO> listAttrNameAndCode() {
        List<BillCompareParaPO> paraList = null;
        try {
            paraList = this.billCompareParaMapper.listAttrNameAndCode();
            if (CollectionUtils.isEmpty(paraList)) {
                paraList = new ArrayList<BillCompareParaPO>();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paraList;
    }
}

