/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.InfoStoreAtomService;
import com.tydic.payment.pay.dao.InfoStoreMapper;
import com.tydic.payment.pay.dao.po.InfoStorePageReqPO;
import com.tydic.payment.pay.dao.po.InfoStorePo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="infoStoreAtomService")
public class InfoStoreAtomServiceImpl
implements InfoStoreAtomService {
    @Autowired
    private InfoStoreMapper infoStoreMapper;

    @Override
    public Long createInfoStore(InfoStorePo po) {
        this.validateArg(po);
        int createStore = this.infoStoreMapper.createInfoStore(po);
        if (createStore < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_STORE\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getStoreId() == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_STORE\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getStoreId();
    }

    private void validateArg(InfoStorePo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getStoreName() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2po\u5bf9\u8c61\u7684\u5e97\u94fa\u540d\u79f0(store_name)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<InfoStorePo> queryInfoStoreByCondition(InfoStorePo po) {
        List<InfoStorePo> storeList;
        if (po == null) {
            po = new InfoStorePo();
        }
        if ((storeList = this.infoStoreMapper.queryInfoStoreByCondition(po)) == null || storeList.isEmpty()) {
            return new ArrayList<InfoStorePo>();
        }
        return storeList;
    }

    @Override
    public int updateInfoStore(InfoStorePo po) {
        this.validateArgUpdate(po);
        int updateStore = this.infoStoreMapper.updateInfoStore(po);
        if (updateStore < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u66f4\u65b0P_INFO_STORE\u65f6mapper update\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u66f4\u65b0\u5931\u8d25\uff01");
        }
        return updateStore;
    }

    private void validateArgUpdate(InfoStorePo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getStoreId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u7684\u95e8\u5e97ID(storeId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u7684\u5546\u6237ID(merchantId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int deleteInfoStore(InfoStorePo po) {
        this.validateArgDel(po);
        Long storeId = po.getStoreId();
        InfoStorePo storePo = new InfoStorePo();
        storePo.setStoreId(storeId);
        int deleteStore = this.infoStoreMapper.delteInfoStore(po);
        if (deleteStore < 1) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_STORE\u65f6mapper delete\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u5220\u9664\u5931\u8d25\uff01");
        }
        return deleteStore;
    }

    private void validateArgDel(InfoStorePo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getStoreId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u7684\u95e8\u5e97ID(storeId)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<InfoStorePo> queryStoreOfMerchant(InfoStorePo po, List<String> merchantIdSet) {
        List<InfoStorePo> storeList;
        if (po == null) {
            po = new InfoStorePo();
        }
        if (CollectionUtils.isEmpty(storeList = this.infoStoreMapper.queryStoreOfMerchantSet(po, merchantIdSet))) {
            return new ArrayList<InfoStorePo>();
        }
        return storeList;
    }

    @Override
    public Long createInfoStoreWithId(InfoStorePo po) {
        this.validateCreateArgWithId(po);
        int createStore = this.infoStoreMapper.createInfoStoreWithId(po);
        if (createStore < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_STORE\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getStoreId() == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_STORE\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getStoreId();
    }

    private void validateCreateArgWithId(InfoStorePo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getStoreId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u7684storeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getStoreName())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2po\u5bf9\u8c61\u7684\u5e97\u94fa\u540d\u79f0(store_name)\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<InfoStorePo> queryInfoStoreWithPage(Page<InfoStorePageReqPO> page, InfoStorePageReqPO po) {
        List<InfoStorePo> storeList;
        if (po == null) {
            po = new InfoStorePageReqPO();
        }
        if (CollectionUtils.isEmpty(storeList = this.infoStoreMapper.queryInfoStoreWithPage(page, po))) {
            return new ArrayList<InfoStorePo>();
        }
        return storeList;
    }

    @Override
    public List<InfoStorePo> queryStoreOfMerchantWithPage(Page<InfoStorePageReqPO> page, InfoStorePageReqPO po, List<String> merchantIdSet) {
        List<InfoStorePo> storeList;
        if (po == null) {
            po = new InfoStorePageReqPO();
        }
        if (CollectionUtils.isEmpty(storeList = this.infoStoreMapper.queryStoreOfMerchantWithPage(page, po, merchantIdSet))) {
            return new ArrayList<InfoStorePo>();
        }
        return storeList;
    }

    @Override
    public InfoStorePo queryInfoStoreByStoreId(Long storeId) {
        if (storeId == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_STORE\u5165\u53c2po\u5bf9\u8c61\u7684storeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InfoStorePo qryResult = this.infoStoreMapper.queryInfoStoreByStoreId(storeId);
        return qryResult;
    }
}

