/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantInfoPageReqPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="merchantInfoAtomService")
public class MerchantInfoAtomServiceImpl
implements MerchantInfoAtomService {
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;

    @Override
    public Long createMerChantInfo(MerChantInfoPo po) {
        this.validateArg(po);
        int createMerChantInfo = this.merChantInfoMapper.createMerChantInfo(po);
        if (createMerChantInfo < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_MERCHANT\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_MERCHANT\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getMerchantId();
    }

    @Override
    public List<MerChantInfoPo> queryMerChantInfoByCondition(MerChantInfoPo po) {
        List<MerChantInfoPo> querycreateMerChantInfoByCondition;
        if (po == null) {
            po = new MerChantInfoPo();
        }
        if ((querycreateMerChantInfoByCondition = this.merChantInfoMapper.queryMerChantInfoByCondition(po)) == null || querycreateMerChantInfoByCondition.isEmpty()) {
            return new ArrayList<MerChantInfoPo>();
        }
        return querycreateMerChantInfoByCondition;
    }

    @Override
    public int updateMerChantInfo(MerChantInfoPo po) {
        this.validateArgUpdate(po);
        int updateMerChantInfo = this.merChantInfoMapper.updateMerChantInfo(po);
        return updateMerChantInfo;
    }

    @Override
    public int deleteMerChantInfo(MerChantInfoPo po) {
        this.validateArgDel(po);
        int deleteMerChantInfo = this.merChantInfoMapper.deleteMerChantInfo(po);
        return deleteMerChantInfo;
    }

    private void validateArgDel(MerChantInfoPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_MERCHANT\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_MERCHANT\u5165\u53c2\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(MerChantInfoPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_MERCHANT\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_MERCHANT\u5165\u53c2\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArg(MerChantInfoPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_MERCHANT\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getMerchantId() != null) {
            po.setMerchantId(null);
        }
        if (po.getMerchantName() == null || po.getMerchantName().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_MERCHANT\u5165\u53c2\u5c5e\u6027MerchantName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getFlag() == null || po.getFlag().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_MERCHANT\u5165\u53c2\u5c5e\u6027Flag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!("1".equals(po.getFlag().trim()) || "0".equals(po.getFlag().trim()) || "2".equals(po.getFlag().trim()) || "3".equals(po.getFlag().trim()) || "4".equals(po.getFlag().trim()))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_MATCH", "\u63d2\u5165P_INFO_MERCHANT\u5165\u53c2\u5c5e\u6027Flag\u4e0d\u5728\u7cfb\u7edf\u5b9a\u4e49\u8303\u56f4\u4e4b\u5185");
        }
    }

    @Override
    public List<MerChantInfoPo> queryMerChantIdAndNameByCondition(MerChantInfoPo po) {
        List<MerChantInfoPo> querycreateMerChantInfoByCondition;
        if (po == null) {
            po = new MerChantInfoPo();
        }
        if ((querycreateMerChantInfoByCondition = this.merChantInfoMapper.queryMerChantIdAndNameByCondition(po)) == null || querycreateMerChantInfoByCondition.isEmpty()) {
            return new ArrayList<MerChantInfoPo>();
        }
        return querycreateMerChantInfoByCondition;
    }

    @Override
    public MerChantInfoPo queryMerchantInfoById(Long merchantId) {
        if (merchantId == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2P_INFO_MERCHANT\u5165\u53c2\u5c5e\u6027MerchantID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MerChantInfoPo qryMerchant = new MerChantInfoPo();
        qryMerchant.setMerchantId(merchantId);
        MerChantInfoPo querycreateMerChantInfoByCondition = this.merChantInfoMapper.queryMerChantInfoById(qryMerchant);
        return querycreateMerChantInfoByCondition;
    }

    @Override
    public List<MerChantInfoPo> queryMerChantInfoWithPage(Page<MerchantInfoPageReqPO> page, MerchantInfoPageReqPO reqPO) {
        if (reqPO == null) {
            reqPO = new MerchantInfoPageReqPO();
        }
        List<MerChantInfoPo> querycreateMerChantInfoByCondition = this.merChantInfoMapper.queryMerChantInfoByConditionWithPage(page, reqPO);
        return querycreateMerChantInfoByCondition;
    }

    @Override
    public List<MerChantInfoPo> queryMerchantInfoByFlagSetWithPage(Page<MerchantInfoPageReqPO> page, MerchantInfoPageReqPO reqPO, Set<String> flagSet) {
        if (reqPO == null) {
            reqPO = new MerchantInfoPageReqPO();
        }
        List<MerChantInfoPo> querycreateMerChantInfoByCondition = this.merChantInfoMapper.queryMerchantInfoByFlagSetWithPage(page, reqPO, flagSet);
        return querycreateMerChantInfoByCondition;
    }
}

