/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.dao.MerchantPayMethodRelMapper;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="merchantPayMethodRelAtomService")
public class MerchantPayMethodRelAtomServiceImpl
implements MerchantPayMethodRelAtomService {
    @Autowired
    private MerchantPayMethodRelMapper merchantPayMethodRelMapper;

    @Override
    public Long createMerchantPayMethodRel(MerchantPayMethodRelPo po) {
        this.validateArg(po);
        int createMerchantPayMethodRel = this.merchantPayMethodRelMapper.createMerchantPayMethodRel(po);
        if (createMerchantPayMethodRel < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_REL_MERCHANT_PAY_METHOD\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getId() == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_REL_MERCHANT_PAY_METHOD\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getId();
    }

    @Override
    public List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition(MerchantPayMethodRelPo po) {
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition;
        if (po == null) {
            po = new MerchantPayMethodRelPo();
        }
        if ((queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelMapper.queryMerchantPayMethodRelByCondition(po)) == null || queryMerchantPayMethodRelByCondition.isEmpty()) {
            return new ArrayList<MerchantPayMethodRelPo>();
        }
        return queryMerchantPayMethodRelByCondition;
    }

    @Override
    public int updateMerchantPayMethodRel(MerchantPayMethodRelPo po) {
        this.validateArgUpdate(po);
        int updateMerchantPayMethodRel = this.merchantPayMethodRelMapper.updateMerchantPayMethodRel(po);
        return updateMerchantPayMethodRel;
    }

    @Override
    public int deleteMerchantPayMethodRel(MerchantPayMethodRelPo po) {
        int deleteMerchantPayMethodRel = this.merchantPayMethodRelMapper.deleteMerchantPayMethodRel(po);
        this.validateArgDel(po);
        return deleteMerchantPayMethodRel;
    }

    @Override
    public int deleteMerchantPayMethodRelByPayMethod(MerchantPayMethodRelPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayMethod() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u7684\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int deleteMerchantPayMethodRelByPayMethod = this.merchantPayMethodRelMapper.deleteMerchantPayMethodRelByPayMethod(po);
        return deleteMerchantPayMethodRelByPayMethod;
    }

    private void validateArgDel(MerchantPayMethodRelPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2\u5c5e\u6027Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(MerchantPayMethodRelPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_REL_MERCHANT_PAY_METHOD\u5165\u53c2\u5c5e\u6027Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArg(MerchantPayMethodRelPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() != null) {
            po.setId(null);
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_MERCHANT_PAY_METHOD\u5165\u53c2\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayMethod() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_MERCHANT_PAY_METHOD\u5165\u53c2\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getPayParaId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_REL_MERCHANT_PAY_METHOD\u5165\u53c2\u5c5e\u6027PayParaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int deleteMerchantPayMethodRelByMerchantId(MerchantPayMethodRelPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u5546\u6237id\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u5546\u6237id\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2po\u5bf9\u8c61\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long merchantId = po.getMerchantId();
        po = new MerchantPayMethodRelPo();
        po.setMerchantId(merchantId);
        return this.merchantPayMethodRelMapper.deleteMerchantPayMethodRelByCondition(po);
    }

    @Override
    public int deleteMerchantPayMethodRelByCondition(MerchantPayMethodRelPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getMerchantId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_REL_MERCHANT_PAY_METHOD\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.merchantPayMethodRelMapper.deleteMerchantPayMethodRelByCondition(po);
    }
}

