/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderMapper;
import com.tydic.payment.pay.dao.po.PorderPageReqPO;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="payOrderAtomService")
public class PayOrderAtomServiceImpl
implements PayOrderAtomService {
    @Autowired
    private PorderMapper porderMapper;
    @Autowired
    private PayMethodMapper payMethodMapper;

    @Override
    public int update(PorderPo payOrder) {
        if (payOrder == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u66f4\u65b0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)payOrder.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.porderMapper.update(payOrder);
    }

    @Override
    public PorderPo queryPorderInfo(Long order_id) {
        if (StringUtils.isEmpty((Object)order_id) || order_id == 0L) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636eorder_id\u67e5\u8be2\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2order_id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.porderMapper.selectPorderByOrderId(order_id);
    }

    @Override
    public String createPorderInfo(PorderPo po) throws Exception {
        if (StringUtils.isEmpty((Object)po.getBusiId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2busiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getMerchantName())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2merchantName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getMerchantId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2merchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getOrderType())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2orderType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getOrderStatus())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2orderStatus\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)po.getOutOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2outOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        po.setCreateTime(this.payMethodMapper.getDBDate().getDate());
        this.porderMapper.insertPorder(po);
        return String.valueOf(po.getOrderId());
    }

    private synchronized String genOrderId() {
        String datetime = new SimpleDateFormat("yyyyMMddHHmmssSS").format(this.payMethodMapper.getDBDate().getDate());
        Random random = new Random();
        int ran = random.nextInt(10) + 10;
        return datetime + ran;
    }

    @Override
    public PorderPo queryPorderByOutOrderId(String outOrderId, Long orderId) {
        if (StringUtils.isEmpty((Object)outOrderId)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636eoutOrderId\u67e5\u8be2\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2outOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.porderMapper.selectPorderByOutOrderId(outOrderId, orderId);
    }

    @Override
    public List<PorderPo> queryPorderByCondition(Page<PorderPageReqPO> page, PorderPageReqPO po, Date dateEnd, Long payFeeLess, Long payFeeMore, Set<Long> orderIdList) {
        List<PorderPo> queryResult;
        if (po == null) {
            po = new PorderPageReqPO();
        }
        if ((queryResult = this.porderMapper.selectPorderByCondition(page, po, dateEnd, payFeeLess, payFeeMore, orderIdList)) == null || queryResult.isEmpty()) {
            return new ArrayList<PorderPo>();
        }
        return queryResult;
    }

    @Override
    public List<PorderPo> queryRefundListByCondition(PorderPo po) {
        List<PorderPo> pList;
        if (po == null) {
            po = new PorderPo();
        }
        if ((pList = this.porderMapper.selectPorderRefundByCondition(po)) == null || pList.isEmpty()) {
            return new ArrayList<PorderPo>();
        }
        return pList;
    }

    @Override
    public PorderPo queryByOrderId(Long orderId) {
        return this.porderMapper.selectByOrderId(orderId);
    }

    @Override
    public String queryPayMethodByOrderId(Long orderId) {
        String orderStatus2 = "A10";
        return this.porderMapper.selectPayMethodByOrderId(orderId, orderStatus2);
    }

    @Override
    public String queryRefundPayMethod(Long orderId) {
        String orderStatus2 = "B10";
        return this.porderMapper.selectRefundPayMethodByOrderId(orderId, orderStatus2);
    }

    @Override
    public PorderPo queryPorderByOutOrderIdAndBusiId(String outOrderId, Long busiId) {
        return this.porderMapper.selectPorderByOutOrderIdAndBusiId(outOrderId, busiId);
    }

    @Override
    public int updateExpTime(Long orderId) {
        return this.porderMapper.updateExpTime(orderId);
    }

    @Override
    public List<PorderPo> selectPorder(Map<String, Object> paramMap) {
        return this.porderMapper.selectPorder(paramMap);
    }

    @Override
    public List<PorderPo> queryPorderByMerSetAndOrderIdSetCondition(Page<PorderPageReqPO> page, PorderPageReqPO po, Date dateEnd, Long payFeeLess, Long payFeeMore, Set<Long> orderIdList, Set<Long> merchantIdSet) {
        List<PorderPo> queryResult;
        if (po == null) {
            po = new PorderPageReqPO();
        }
        if ((queryResult = this.porderMapper.selectPorderByMerSetAndOrderIdSetCondition(page, po, dateEnd, payFeeLess, payFeeMore, orderIdList, merchantIdSet)) == null || queryResult.isEmpty()) {
            return new ArrayList<PorderPo>();
        }
        return queryResult;
    }
}

