/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.dao.PayParaInfoMapper;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payParaInfoAtomService")
public class PayParaInfoAtomServiceImpl
implements PayParaInfoAtomService {
    private static final Logger logger = LoggerFactory.getLogger(PayParaInfoAtomServiceImpl.class);
    @Autowired
    private PayParaInfoMapper payParaInfoMapper;

    @Override
    public Long createPayParaInfo(PayParaInfoPo po) {
        this.validateCreateArt(po);
        po.setState("1");
        int createPayParaInfo = this.payParaInfoMapper.createPayParaInfo(po);
        if (createPayParaInfo < 1) {
            logger.error("\u63d2\u5165P_INFO_PAY_PARA\u65f6mapper\u8fd4\u56de\u6570\u5b57\u5c0f\u4e8e1");
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_PAY_PARA\uff0cinsert sql\u8bed\u53e5\u8fd4\u56de\u7684\u503c\u5c0f\u4e8e1\uff0c\u6ca1\u6709\u6210\u529f\u63d2\u5165\u6570\u636e\uff01");
        }
        if (po.getPayParaId() == null || po.getPayParaId() < 1L) {
            logger.error("\u63d2\u5165P_INFO_PAY_PARA\u65f6mapper\u6ca1\u6709\u53d6\u5230\u8fd4\u56de\u7684id\uff0c\u4f1a\u540e\u9762\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u6267\u884c\uff01");
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_PAY_PARA\u65f6mapper\u6ca1\u6709\u53d6\u5230\u8fd4\u56de\u7684id\uff0c\u4f1a\u540e\u9762\u4e1a\u52a1\u65e0\u6cd5\u6b63\u5e38\u6267\u884c\uff01");
        }
        return po.getPayParaId();
    }

    @Override
    public List<PayParaInfoPo> queryPayParaInfoByCondition(PayParaInfoPo po) {
        List<PayParaInfoPo> queryPayParaInfoByCondition;
        if (po == null) {
            po = new PayParaInfoPo();
        }
        if ((queryPayParaInfoByCondition = this.payParaInfoMapper.queryPayParaInfoByCondition(po)) == null || queryPayParaInfoByCondition.isEmpty()) {
            return new ArrayList<PayParaInfoPo>();
        }
        return queryPayParaInfoByCondition;
    }

    @Override
    public int updatePayParaInfo(PayParaInfoPo po) {
        this.varlidateUpdateArg(po);
        int updatePayParaInfo = this.payParaInfoMapper.updatePayParaInfo(po);
        return updatePayParaInfo;
    }

    @Override
    public int deletePayParaInfo(PayParaInfoPo po) {
        this.varlidateDelArg(po);
        int retInt = this.payParaInfoMapper.deletePayParaInfo(po);
        return retInt;
    }

    private void varlidateDelArg(PayParaInfoPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_PAY_PARA\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (po.getPayParaId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_PAY_PARA\u5165\u53c2\u5c5e\u6027PayParaId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void varlidateUpdateArg(PayParaInfoPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_PAY_PARA\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (po.getPayParaId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_PAY_PARA\u5165\u53c2\u5c5e\u6027PayParaId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void validateCreateArt(PayParaInfoPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAY_PARA\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (po.getPayParaId() != null) {
            po.setPayParaId(null);
        }
        if (po.getParaName() == null || po.getParaName().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAY_PARA\u5165\u53c2\u5c5e\u6027ParaName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (po.getPaymentInsId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_PAY_PARA\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

