/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.dao.PayRuleParaMapper;
import com.tydic.payment.pay.dao.po.PayRuleParaPageReqPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payRuleParaAtomService")
public class PayRuleParaAtomServiceImpl
implements PayRuleParaAtomService {
    @Autowired
    private PayRuleParaMapper payRuleParaMapper;

    @Override
    public Long createPayRulePara(PayRuleParaPo po) {
        this.validateArg(po);
        int createPayParaRule = this.payRuleParaMapper.createPayRulePara(po);
        if (createPayParaRule < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_RULE_PAY_PARA\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getId() == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_RULE_PAY_PARA\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getId();
    }

    @Override
    public List<PayRuleParaPo> queryPayRuleParaByCondition(PayRuleParaPo po) {
        if (po == null) {
            po = new PayRuleParaPo();
        }
        List<PayRuleParaPo> queryPayParaRuleByCondition = null;
        try {
            queryPayParaRuleByCondition = this.payRuleParaMapper.queryPayRuleParaByCondition(po);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (queryPayParaRuleByCondition == null || queryPayParaRuleByCondition.isEmpty()) {
            return new ArrayList<PayRuleParaPo>();
        }
        return queryPayParaRuleByCondition;
    }

    @Override
    public int updatePayRulePara(PayRuleParaPo po) {
        this.validateArgUpdate(po);
        int updatePayParaRule = this.payRuleParaMapper.updatePayRulePara(po);
        return updatePayParaRule;
    }

    @Override
    public int deletePayRulePara(PayRuleParaPo po) {
        this.validateArgDel(po);
        int deletePayParaRule = this.payRuleParaMapper.deletePayRulePara(po);
        return deletePayParaRule;
    }

    @Override
    public PayRuleParaPo queryPayRuleParaById(PayRuleParaPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayRuleParaPo payPo = new PayRuleParaPo();
        payPo.setId(po.getId());
        PayRuleParaPo qryResultPo = this.payRuleParaMapper.queryPayRuleParaById(payPo);
        return qryResultPo;
    }

    private void validateArg(PayRuleParaPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() != null) {
            po.setId(null);
        }
        if (po.getPaymentInsId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getParameterCode() == null || po.getParameterCode().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ParameterCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getParameterName() == null || po.getParameterName().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ParameterName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(PayRuleParaPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgDel(PayRuleParaPo po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_RULE_PAY_PARA\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getId() == null && po.getPaymentInsId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_RULE_PAY_PARA\u5165\u53c2\u5c5e\u6027Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<PayRuleParaPo> queryPayRuleParaWithPage(Page<PayRuleParaPageReqPo> page, PayRuleParaPageReqPo po) {
        if (po == null) {
            po = new PayRuleParaPageReqPo();
        }
        if (page.getPageNo() < 1) {
            page.setPageNo(1);
        }
        if (page.getPageSize() < 1) {
            page.setPageSize(10);
        }
        List<PayRuleParaPo> queryPayParaRuleByCondition = null;
        try {
            queryPayParaRuleByCondition = this.payRuleParaMapper.queryPayRuleParaWithPage(page, po);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (queryPayParaRuleByCondition == null || queryPayParaRuleByCondition.isEmpty()) {
            return new ArrayList<PayRuleParaPo>();
        }
        return queryPayParaRuleByCondition;
    }
}

