/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PaySettleBillFileAtomService;
import com.tydic.payment.pay.dao.PaySettleBillFileMapper;
import com.tydic.payment.pay.dao.po.PaySettleBillFilePO;
import com.tydic.payment.pay.dao.po.PaySettleBillFilePageReqPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="paySettleBillFileAtomService")
public class PaySettleBillFileAtomServiceImpl
implements PaySettleBillFileAtomService {
    @Autowired
    private PaySettleBillFileMapper paySettleBillFileMapper;

    @Override
    public Long createPaySettleBillFileInfo(PaySettleBillFilePO po) throws Exception {
        this.validateArg(po);
        int createBillFileInfo = this.paySettleBillFileMapper.createPaySettleBillFileInfo(po);
        if (createBillFileInfo < 1) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_PAY_SETTLE_BILL_FILE\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (Long.valueOf(po.getId()) == null) {
            throw new ResourceException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_PAY_SETTLE_BILL_FILE\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684\u6587\u4ef6id");
        }
        return po.getId();
    }

    private void validateArg(PaySettleBillFilePO po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getBusiId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u7684busiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)po.getFileName())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u7684fileName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<PaySettleBillFilePO> queryBillFileInfoByCondition(PaySettleBillFilePO po) throws Exception {
        List<PaySettleBillFilePO> fileList;
        if (po == null) {
            po = new PaySettleBillFilePO();
        }
        if (CollectionUtils.isEmpty(fileList = this.paySettleBillFileMapper.queryBillFileInfoByCondition(po))) {
            return new ArrayList<PaySettleBillFilePO>();
        }
        return fileList;
    }

    @Override
    public int updatePaySettleBillFileInfo(PaySettleBillFilePO po) throws Exception {
        this.validateArgUpdate(po);
        int updateBillFileInfo = this.paySettleBillFileMapper.updatePaySettleBillFileInfo(po);
        return updateBillFileInfo;
    }

    private void validateArgUpdate(PaySettleBillFilePO po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u4fee\u6539P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Long.valueOf(po.getId()) == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u4fee\u6539P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getBusiId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u4fee\u6539P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u7684busiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)po.getFileName())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u4fee\u6539P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u7684fileName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int deletePaySettleBillFileInfo(PaySettleBillFilePO po) throws Exception {
        this.validateArgDel(po);
        int deleteBillFileInfo = this.paySettleBillFileMapper.deletePaySettleBillFileInfo(po);
        return deleteBillFileInfo;
    }

    private void validateArgDel(PaySettleBillFilePO po) {
        if (po == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Long.valueOf(po.getId()) == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_PAY_SETTLE_BILL_FILE\u5165\u53c2po\u5bf9\u8c61\u7684id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<PaySettleBillFilePO> queryBillFileInfoByDay(Page<PaySettleBillFilePageReqPO> page, PaySettleBillFilePageReqPO po, Long beginDate, Long endDate) throws Exception {
        List<PaySettleBillFilePO> fileList;
        if (po == null) {
            po = new PaySettleBillFilePageReqPO();
        }
        if ((fileList = this.paySettleBillFileMapper.queryBillFileWithBetweenDay(page, po, beginDate, endDate)) == null || fileList.isEmpty()) {
            return new ArrayList<PaySettleBillFilePO>();
        }
        return fileList;
    }
}

