/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.SequenceAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.rsp.bo.PorderRefundTransAtomRspBo;
import com.tydic.payment.pay.bo.busi.req.RefundOrderListQryReqBO;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.PorderRefundTransMapper;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransStatisticResultPo;
import com.tydic.payment.pay.dao.po.Sequence;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="porderRefundTransAtomService")
public class PorderRefundTransAtomServiceImpl
implements PorderRefundTransAtomService {
    @Autowired
    private PorderRefundTransMapper porderRefundTransMapper;
    @Autowired
    private SequenceAtomService sequenceAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayMethodMapper payMethodMapper;
    @Autowired
    @Qualifier(value="payOrderSequence")
    private OrderSequence payOrderSequence;

    @Override
    public String createOrderRefundTrans(PorderRefundTransAtomReqBo req) throws Exception {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9000\u6b3e\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\u5165\u53c2\u53d1\u8d77\u652f\u4ed8\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String refundOrderId = this.createPayOrderIdNew();
        PorderRefundTransPo po = new PorderRefundTransPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        po.setRefundOrderId(refundOrderId);
        po.setCreateTime(this.payMethodMapper.getDBDate().getDate());
        int count = this.porderRefundTransMapper.insert(po);
        if (count < 1) {
            throw new ResourceException("RSP_CODE_ATOM_SERVICE_ERROR", "\u65b0\u589e\u652f\u4ed8\u8bf7\u6c42\u539f\u5b50\u670d\u52a1\uff0c\u65b0\u589e\u5931\u8d25\uff01");
        }
        return refundOrderId;
    }

    @Override
    public int updateOrderRefundTransByRefundOrderId(PorderRefundTransAtomReqBo req) throws Exception {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getRefundOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010RefundOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PorderRefundTransPo po = new PorderRefundTransPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        po.setUpdateTime(this.payMethodMapper.getDBDate().getDate());
        return this.porderRefundTransMapper.update(po);
    }

    private String createPayOrderIdNew() {
        Long sequence = 0L;
        if ("0".equals(this.payPropertiesVo.getSequenceChoose())) {
            try {
                sequence = this.payOrderSequence.nextId();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            sequence = this.sequenceAtomService.getSequence(new Sequence());
        }
        String payOrderId = this.payPropertiesVo.getProjectName() + sequence;
        return payOrderId;
    }

    @Override
    public PorderRefundTransAtomRspBo queryOrderRefundTransByRefundOrderId(PorderRefundTransAtomReqBo req) {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getRefundOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010refundOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PorderRefundTransPo po = new PorderRefundTransPo();
        BeanUtils.copyProperties((Object)req, (Object)po);
        PorderRefundTransPo PorderRefundTransPo2 = this.porderRefundTransMapper.getOrderRfundTransByRefundOrderId(po);
        if (PorderRefundTransPo2 != null) {
            PorderRefundTransAtomRspBo porderPayTransAtomRspBo = new PorderRefundTransAtomRspBo();
            BeanUtils.copyProperties((Object)PorderRefundTransPo2, (Object)porderPayTransAtomRspBo);
            return porderPayTransAtomRspBo;
        }
        return null;
    }

    @Override
    public List<PorderRefundTransAtomRspBo> queryOrderRefundTransByCondition(PorderRefundTransAtomReqBo req) throws Exception {
        PorderRefundTransPo po = new PorderRefundTransPo();
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)req, (Object)po);
        List<PorderRefundTransPo> poList = this.porderRefundTransMapper.getOrderRefundTransByCondition(po);
        ArrayList<PorderRefundTransAtomRspBo> rspList = new ArrayList<PorderRefundTransAtomRspBo>();
        if (poList != null && poList.size() > 0) {
            for (PorderRefundTransPo transPo : poList) {
                PorderRefundTransAtomRspBo bo = new PorderRefundTransAtomRspBo();
                BeanUtils.copyProperties((Object)transPo, (Object)bo);
                rspList.add(bo);
            }
        }
        return rspList;
    }

    @Override
    public List<PorderRefundTransPo> queryOrderRefundTrans(PorderRefundTransPo po) {
        List<PorderRefundTransPo> queryOrderPayTrans;
        if (po == null) {
            po = new PorderRefundTransPo();
        }
        if ((queryOrderPayTrans = this.porderRefundTransMapper.queryOrderRefundTrans(po)) == null || queryOrderPayTrans.isEmpty()) {
            return new ArrayList<PorderRefundTransPo>();
        }
        return queryOrderPayTrans;
    }

    @Override
    public List<PorderRefundTransPo> queryOrderRefundBetweenTime(Page<RefundOrderListQryReqBO> page, PorderRefundTransPo po, Date beginDate, Date endDate, Set<Long> orderIdSet) {
        List<PorderRefundTransPo> qList;
        if (po == null) {
            po = new PorderRefundTransPo();
        }
        if ((qList = this.porderRefundTransMapper.queryRefundBetweenTime(page, po, beginDate, endDate, orderIdSet)) == null || qList.isEmpty()) {
            return new ArrayList<PorderRefundTransPo>();
        }
        return qList;
    }

    @Override
    public List<Long> queryOrderRefundTransOfMerchantIdSetByCondition(PorderRefundTransPo req, Set<Long> merchantIdSet) {
        PorderRefundTransPo po = new PorderRefundTransPo();
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(merchantIdSet)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u5546\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)req, (Object)po);
        List<Long> poList = this.porderRefundTransMapper.queryOrderRefundTransOfMerchantIdSetByCondition(po, merchantIdSet);
        return poList;
    }

    @Override
    public PorderRefundTransPo queryLastRecordByOrderId(Long orderId) {
        PorderRefundTransPo po = this.porderRefundTransMapper.queryLastRecordByOrderId(orderId);
        return po;
    }

    @Override
    public List<PorderRefundTransStatisticResultPo> countIncomeOfMerchants(PorderRefundTransPo qryPorderRefundTranasPo, Set<Long> merchantIdSet) {
        if (CollectionUtils.isEmpty(merchantIdSet)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u539f\u5b50\u670d\u52a1\u67e5\u8be2\u5165\u53c2\u5546\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<PorderRefundTransStatisticResultPo> poList = this.porderRefundTransMapper.countIncomeOfMerchants(qryPorderRefundTranasPo, merchantIdSet);
        return poList;
    }
}

