/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ali.model.AlipayAppPayResult;
import com.tydic.payment.pay.ali.model.AlipayTradeAppPayRequestBuilder;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.bo.busi.req.AliAppPayReqBo;
import com.tydic.payment.pay.bo.busi.rsp.AliAppPayRspBo;
import com.tydic.payment.pay.busi.api.AliAppPayBusiService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="aliAppPayBusiService")
public class AliAppPayBusiServiceImpl
implements AliAppPayBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(AliAppPayBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    public AliAppPayRspBo dealPay(AliAppPayReqBo aliAppPayReqBo) {
        String body;
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u5fae\u4fe1APP\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)aliAppPayReqBo));
        }
        AliAppPayRspBo rsp = new AliAppPayRspBo();
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(aliAppPayReqBo.getOrderId()));
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
        orderPayTransAtomReq.setBusiId(orderInfo.getBusiId());
        orderPayTransAtomReq.setMerchantId(Long.parseLong(aliAppPayReqBo.getMerchantId()));
        orderPayTransAtomReq.setPayMethod(Long.parseLong("23"));
        orderPayTransAtomReq.setOrderStatus("A00");
        orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)aliAppPayReqBo.getTotalFee()));
        String outTradeNo = null;
        try {
            outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String notifyUrl = this.payPropertiesVo.getAliNotifyUrl();
        String totalAmount = MoneyUtils.fenToYuan((BigDecimal)aliAppPayReqBo.getTotalFee()).toString();
        String subject = body = orderInfo.getDetailName();
        String storeId = String.valueOf(orderInfo.getMerchantId());
        ExtendParams extendParams = null;
        String timeoutExpress = "2m";
        String passback_params = "";
        AlipayTradeAppPayRequestBuilder builder = new AlipayTradeAppPayRequestBuilder().setOutTradeNo(outTradeNo).setSubject(subject).setBody(body).setTotalAmount(totalAmount).setExtendParams(extendParams).setNotifyUrl(notifyUrl).setStoreId(storeId).setTimeoutExpress(timeoutExpress).setPassback_params(passback_params);
        AlipayTradeServiceImpl tradeService = new AlipayTradeServiceImpl.ClientBuilder().build(String.valueOf(aliAppPayReqBo.getParamMap().get("appid")), String.valueOf(aliAppPayReqBo.getParamMap().get("privateKey")), String.valueOf(aliAppPayReqBo.getParamMap().get("publicKey")), "APP");
        AlipayAppPayResult result = tradeService.appPay(builder);
        String rerutnUrl = this.payPropertiesVo.getAliReturnUrl();
        switch (result.getTradeStatus()) {
            case SUCCESS: {
                rsp.setRspCode("0000");
                rsp.setRspName("ali APP\u652f\u4ed8\u53c2\u6570\u83b7\u53d6\u6210\u529f");
                rsp.setPayStatus("SUCCESS");
                rsp.setBody(result.getResponse().getBody());
                rsp.setRedirectUrl(orderInfo.getRedirectUrl());
                rsp.setPayOrderId(outTradeNo);
                break;
            }
            case FAILED: {
                rsp.setRspCode("0000");
                rsp.setRspName("\u652f\u4ed8\u53c2\u6570\u83b7\u53d6\u5931\u8d25");
                rsp.setPayStatus("FAIL");
                break;
            }
            case UNKNOWN: {
                rsp.setRspCode("0000");
                rsp.setRspName("\u652f\u4ed8\u53c2\u6570\u83b7\u53d6\u5931\u8d25");
                rsp.setPayStatus("FAIL");
                break;
            }
            default: {
                rsp.setRspCode("0000");
                rsp.setRspName("\u652f\u4ed8\u53c2\u6570\u83b7\u53d6\u5931\u8d25");
                rsp.setPayStatus("FAIL");
            }
        }
        return rsp;
    }
}

