/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.ali.model.AlipayF2FPayResult;
import com.tydic.payment.pay.ali.model.AlipayTradePayRequestBuilder;
import com.tydic.payment.pay.ali.model.ExtendParams;
import com.tydic.payment.pay.ali.model.GoodsDetail;
import com.tydic.payment.pay.ali.service.impl.AlipayTradeWithHBServiceImpl;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.rsp.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.busi.req.AliScanPayReqBO;
import com.tydic.payment.pay.bo.busi.rsp.AliScanPayRspBO;
import com.tydic.payment.pay.busi.api.AliScanPayBusiService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pmcAliScanPayBusiService")
public class AliScanPayBusiServiceImpl
implements AliScanPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(AliScanPayBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    public AliScanPayRspBO dealAliScanPay(AliScanPayReqBO pmcAliScanPayReqBO) {
        if (pmcAliScanPayReqBO == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)pmcAliScanPayReqBO.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d orderId\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)pmcAliScanPayReqBO.getMerchantId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5165\u53c2\u4e0d merchantId\u80fd\u4e3a\u7a7a");
        }
        if (pmcAliScanPayReqBO.getParamMap().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pmcAliScanPayReqBO.getTotalFee() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u91d1\u989d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)pmcAliScanPayReqBO.getAuthCode())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6761\u5f62\u4e32\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AliScanPayRspBO pmcAliScanPayRspBO = new AliScanPayRspBO();
        try {
            PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(pmcAliScanPayReqBO.getOrderId()));
            if (pOrder == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            if ("A10".equals(pOrder.getOrderStatus())) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
            }
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setOrderId(pOrder.getOrderId());
            orderPayTransAtomReq.setBusiId(pOrder.getBusiId());
            orderPayTransAtomReq.setMerchantId(pOrder.getMerchantId());
            orderPayTransAtomReq.setOrderStatus(pOrder.getOrderStatus());
            orderPayTransAtomReq.setPayMethod(Long.parseLong("20"));
            orderPayTransAtomReq.setPayFee(MoneyUtils.fenToHaoToLong((BigDecimal)pmcAliScanPayReqBO.getTotalFee()));
            String outTradeNo = this.porderPayTransAtomService.createOrderPayTrans(orderPayTransAtomReq);
            ArrayList<GoodsDetail> goodsDetailList = new ArrayList<GoodsDetail>();
            String totalAmount = MoneyUtils.fenToYuan((BigDecimal)pmcAliScanPayReqBO.getTotalFee()).toString();
            String undiscountableAmount = "0.00";
            String sellerId = "";
            String body = pOrder.getDetailName();
            String operatorId = pOrder.getCreateOperId();
            String storeId = String.valueOf(pOrder.getMerchantId());
            ExtendParams extendParams = null;
            String timeoutExpress = "2m";
            AlipayTradeWithHBServiceImpl service = new AlipayTradeWithHBServiceImpl.ClientBuilder().build(String.valueOf(pmcAliScanPayReqBO.getParamMap().get("appid")), String.valueOf(pmcAliScanPayReqBO.getParamMap().get("privateKey")), String.valueOf(pmcAliScanPayReqBO.getParamMap().get("publicKey")));
            AlipayTradePayRequestBuilder builder = new AlipayTradePayRequestBuilder().setOutTradeNo(outTradeNo).setSubject(body).setAuthCode(pmcAliScanPayReqBO.getAuthCode()).setTotalAmount(totalAmount).setStoreId(storeId).setUndiscountableAmount(undiscountableAmount).setBody(body).setOperatorId(operatorId).setExtendParams(extendParams).setSellerId(sellerId).setGoodsDetailList(goodsDetailList).setTimeoutExpress(timeoutExpress);
            AlipayF2FPayResult result = service.tradePay(builder);
            log.info("\u652f\u4ed8\u5b9d\u6761\u5f62\u7801\u652f\u4ed8\u8fd4\u56de\uff1a " + result.getResponse().getMsg());
            PorderPayTransAtomRspBo porderPayTransAtomRspBo = new PorderPayTransAtomRspBo();
            PorderPayTransAtomReqBo porderPayTransAtomReqBo = new PorderPayTransAtomReqBo();
            porderPayTransAtomReqBo.setPayOrderId(outTradeNo);
            porderPayTransAtomReqBo.setOrderId(pOrder.getOrderId());
            porderPayTransAtomRspBo = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(porderPayTransAtomReqBo);
            if (porderPayTransAtomRspBo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u4e3a\u627e\u5230\u652f\u4ed8\u8ba2\u5355");
            }
            BeanUtils.copyProperties((Object)porderPayTransAtomReqBo, (Object)porderPayTransAtomRspBo);
            PorderPo payOrder = this.payOrderAtomService.queryPorderInfo(porderPayTransAtomRspBo.getOrderId());
            Date date = this.queryDBDateBusiService.getDBDate();
            if (payOrder != null) {
                String trade_time = "";
                if (result.getResponse().getGmtPayment() != null) {
                    trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(result.getResponse().getGmtPayment());
                } else {
                    Date dbDate = this.queryDBDateBusiService.getDBDate();
                    trade_time = new SimpleDateFormat("yyyyMMddHHmmss").format(dbDate);
                }
                String realFee = result.getResponse().getTotalAmount();
                switch (result.getTradeStatus()) {
                    case SUCCESS: {
                        payOrder.setPayNotifyCode("0");
                        payOrder.setOrderStatus("A10");
                        payOrder.setTradeTime(trade_time);
                        payOrder.setRealFee(MoneyUtils.yuanToHaoToLong((BigDecimal)new BigDecimal(realFee)));
                        payOrder.setOnlineFee(MoneyUtils.yuanToHaoToLong((BigDecimal)new BigDecimal(realFee)));
                        pmcAliScanPayRspBO.setRspName("\u652f\u4ed8\u5b9d\u652f\u4ed8\u6210\u529f");
                        pmcAliScanPayRspBO.setPayStatus("SUCCESS");
                        break;
                    }
                    case FAILED: {
                        payOrder.setPayNotifyCode("1");
                        payOrder.setPayNotifyMsg(result.getResponse().getSubMsg());
                        payOrder.setOrderStatus("A20");
                        payOrder.setTradeTime(trade_time);
                        pmcAliScanPayRspBO.setRspName(payOrder.getPayNotifyMsg());
                        pmcAliScanPayRspBO.setPayStatus("FAIL");
                        break;
                    }
                    case UNKNOWN: {
                        payOrder.setPayNotifyCode("1");
                        payOrder.setPayNotifyMsg(result.getResponse().getSubMsg());
                        payOrder.setOrderStatus("A20");
                        payOrder.setTradeTime(trade_time);
                        pmcAliScanPayRspBO.setRspName(payOrder.getPayNotifyMsg());
                        pmcAliScanPayRspBO.setPayStatus("FAIL");
                        break;
                    }
                    default: {
                        payOrder.setPayNotifyCode("1");
                        payOrder.setPayNotifyMsg("\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
                        payOrder.setOrderStatus("A20");
                        payOrder.setTradeTime(trade_time);
                        pmcAliScanPayRspBO.setRspName(payOrder.getPayNotifyMsg());
                        pmcAliScanPayRspBO.setPayStatus("FAIL");
                    }
                }
                payOrder.setPayNotifyTime(date);
                payOrder.setCustyNotifyCode("-");
                this.payOrderAtomService.update(payOrder);
                porderPayTransAtomReqBo.setOrderStatus(payOrder.getOrderStatus());
                porderPayTransAtomReqBo.setPayMsg(payOrder.getPayNotifyMsg());
                porderPayTransAtomReqBo.setPayNotifyTransId(result.getResponse().getTradeNo());
                porderPayTransAtomReqBo.setTradeTime(payOrder.getTradeTime());
                this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(porderPayTransAtomReqBo);
                pmcAliScanPayRspBO.setRspCode("0000");
            }
        }
        catch (Exception e) {
            log.equals("\u8c03\u7528\u652f\u4ed8\u5b9d\u4e0b\u5355\u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
            pmcAliScanPayRspBO.setRspCode("8888");
            pmcAliScanPayRspBO.setRspName("\u8c03\u7528\u652f\u4ed8\u5b9d\u4e0b\u5355\u5f02\u5e38" + e.getMessage());
        }
        return pmcAliScanPayRspBO;
    }
}

