/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.tydic.payment.pay.bo.busi.BusiPaymentMerchantQueryBusiReqBO;
import com.tydic.payment.pay.bo.busi.BusiPaymentMerchantQueryBusiRspBO;
import com.tydic.payment.pay.bo.busi.bo.BusiPaymentMerchantInfoBusiBO;
import com.tydic.payment.pay.busi.api.BusiPaymentMerchantQueryBusiService;
import com.tydic.payment.pay.dao.BusiPaymentMerchantRelMapper;
import com.tydic.payment.pay.dao.BusiSystemMerchantRelMapper;
import com.tydic.payment.pay.dao.po.BusiPaymentMerchantRelPO;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="busiPaymentMerchantQueryBusiService")
public class BusiPaymentMerchantQueryBusiServiceImpl
implements BusiPaymentMerchantQueryBusiService {
    private BusiPaymentMerchantRelMapper busiPaymentMerchantRelMapper;
    private BusiSystemMerchantRelMapper busiSystemMerchantRelMapper;

    @Autowired
    public BusiPaymentMerchantQueryBusiServiceImpl(BusiPaymentMerchantRelMapper busiPaymentMerchantRelMapper, BusiSystemMerchantRelMapper busiSystemMerchantRelMapper) {
        this.busiPaymentMerchantRelMapper = busiPaymentMerchantRelMapper;
        this.busiSystemMerchantRelMapper = busiSystemMerchantRelMapper;
    }

    public BusiPaymentMerchantQueryBusiRspBO query(BusiPaymentMerchantQueryBusiReqBO reqBO) {
        BusiPaymentMerchantQueryBusiRspBO rspBO = new BusiPaymentMerchantQueryBusiRspBO();
        ArrayList<BusiPaymentMerchantInfoBusiBO> merchantInfoList = new ArrayList<BusiPaymentMerchantInfoBusiBO>(16);
        if (reqBO.getBusiId() != null) {
            this.findByBusiId(merchantInfoList, reqBO.getBusiId());
        }
        if (reqBO.getMerchantId() != null) {
            this.findByMerchantId(merchantInfoList, reqBO);
        }
        if (reqBO.getPaymentMchId() != null) {
            this.findByPaymentMchId(merchantInfoList, reqBO.getPaymentMchId());
        }
        if (merchantInfoList.size() == 0) {
            rspBO.setRspCode("8888");
            rspBO.setRspName("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        rspBO.setRspCode("0000");
        rspBO.setRspName("\u6210\u529f");
        rspBO.setMerchantInfoList(merchantInfoList);
        return rspBO;
    }

    private void findByBusiId(Collection<BusiPaymentMerchantInfoBusiBO> merchantInfoList, Long busiId) {
        BusiSystemMerchantRelPo busiSystemMerchantRelPo = new BusiSystemMerchantRelPo();
        busiSystemMerchantRelPo.setBusiId(busiId);
        List<String> busiMchList = this.busiSystemMerchantRelMapper.queryMerchantIdRelBusiSystem(busiSystemMerchantRelPo);
        if (busiMchList == null || busiMchList.size() < 1) {
            return;
        }
        HashSet<BusiPaymentMerchantInfoBusiBO> mchSet = new HashSet<BusiPaymentMerchantInfoBusiBO>(busiMchList.size() * 4);
        for (String mch : busiMchList) {
            BusiPaymentMerchantRelPO reqPO = new BusiPaymentMerchantRelPO();
            reqPO.setMerchantId(Long.parseLong(mch));
            List<BusiPaymentMerchantRelPO> pos = this.busiPaymentMerchantRelMapper.query(reqPO);
            if (pos == null || pos.size() < 1) continue;
            for (BusiPaymentMerchantRelPO po : pos) {
                BusiPaymentMerchantInfoBusiBO bo = new BusiPaymentMerchantInfoBusiBO();
                bo.setMerchantId(po.getMerchantId());
                bo.setPaymentMchId(po.getPaymentMchId());
                bo.setPaymentInsId(po.getPaymentInsId());
                mchSet.add(bo);
            }
        }
        merchantInfoList.addAll(mchSet);
    }

    private void findByMerchantId(Collection<BusiPaymentMerchantInfoBusiBO> merchantInfoList, BusiPaymentMerchantQueryBusiReqBO reqBO) {
        BusiPaymentMerchantRelPO reqPO = new BusiPaymentMerchantRelPO();
        reqPO.setMerchantId(reqBO.getMerchantId());
        reqPO.setPaymentInsId(reqBO.getPaymentInsId());
        List<BusiPaymentMerchantRelPO> pos = this.busiPaymentMerchantRelMapper.query(reqPO);
        if (pos == null || pos.size() < 1) {
            return;
        }
        HashSet<BusiPaymentMerchantInfoBusiBO> mchSet = new HashSet<BusiPaymentMerchantInfoBusiBO>(pos.size());
        for (BusiPaymentMerchantRelPO po : pos) {
            BusiPaymentMerchantInfoBusiBO bo = new BusiPaymentMerchantInfoBusiBO();
            bo.setMerchantId(po.getMerchantId());
            bo.setPaymentInsId(po.getPaymentInsId());
            bo.setPaymentMchId(po.getPaymentMchId());
            mchSet.add(bo);
        }
        merchantInfoList.addAll(mchSet);
    }

    private void findByPaymentMchId(Collection<BusiPaymentMerchantInfoBusiBO> merchantInfoList, String paymentMchId) {
        BusiPaymentMerchantRelPO reqPO = new BusiPaymentMerchantRelPO();
        reqPO.setPaymentMchId(paymentMchId);
        List<BusiPaymentMerchantRelPO> pos = this.busiPaymentMerchantRelMapper.query(reqPO);
        if (pos == null || pos.size() < 1) {
            return;
        }
        HashSet<Long> mchSet = new HashSet<Long>(pos.size());
        for (BusiPaymentMerchantRelPO po : pos) {
            mchSet.add(po.getMerchantId());
        }
        for (Long mch : mchSet) {
            BusiPaymentMerchantInfoBusiBO bo = new BusiPaymentMerchantInfoBusiBO();
            bo.setMerchantId(mch);
            merchantInfoList.add(bo);
        }
    }
}

