/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.bo.busi.req.DataEncryptionReqBo;
import com.tydic.payment.pay.bo.busi.rsp.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.api.DataEncryptionService;
import com.tydic.payment.pay.busi.api.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.common.util.HttpUtil;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CallBackNoticeConsume
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(CallBackNoticeConsume.class);
    @Autowired
    private DataEncryptionService dataEncryptionService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;

    public void dealPayNoticeByAbility(String data) {
        log.info("\u652f\u4ed8\u4e2d\u5fc3\u6d88\u8d39\u8005\u542f\u52a8\uff0c\u5165\u53c2\u4e3a\uff1a" + data);
        JSONObject req = JSONObject.parseObject((String)data);
        String busiId = req.getString("busiId");
        String busiData = req.getString("busiData");
        req.remove((Object)"busiId");
        req.remove((Object)"notifyUrl");
        String orderId = req.getString("transactionsId");
        PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(orderId));
        try {
            DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
            dataEncryptionReqBo.setBusiId(String.valueOf(pOrder.getBusiId()));
            dataEncryptionReqBo.setContent(data);
            DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
            JSONObject reqData = new JSONObject();
            reqData.put("BUSI_ID", (Object)busiId);
            reqData.put("CONTENT", (Object)dataEncryptionRspBo.getEncrypData());
            JSONObject json = new JSONObject();
            json.put("CALL_BACK_NOTICE_REQ", (Object)reqData);
            log.info("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u7684\u76ee\u6807\u5730\u5740\u4e3a\uff1a" + this.payPropertiesVo.getAbilityPayNotifyUrl());
            log.info("\u8c03\u7528\u53c2\u6570\u4e3a\uff1a" + json);
            String resultData = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityPayNotifyUrl() + busiId + "/v1", json);
            JSONObject result = JSONObject.parseObject((String)resultData);
            String backMessage = result.getJSONObject("UNI_BSS_BODY").getJSONObject("CALL_BACK_NOTICE_RSP").getString("NOTIFY_RESULT");
            if ("SUCCESS".equalsIgnoreCase(backMessage)) {
                pOrder.setCustyNotifyCode("0");
                pOrder.setCustNotifyMsg("SUCCESS");
            } else {
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u56de\u8c03\u901a\u77e5\u5f02\u5e38\uff1a orderId = " + orderId + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg(e.getMessage());
        }
        pOrder.setCustNotifyTime(this.queryDBDateBusiService.getDBDate());
        this.payOrderAtomService.update(pOrder);
    }

    public void dealPayNoticeByHttp(String data) {
        JSONObject req = JSONObject.parseObject((String)data);
        String busiId = req.getString("busiId");
        String notifyUrl = req.getString("notifyUrl");
        req.remove((Object)"busiId");
        req.remove((Object)"notifyUrl");
        String orderId = req.getString("transactionsId");
        PorderPo pOrder = this.payOrderAtomService.queryPorderInfo(Long.parseLong(orderId));
        try {
            DataEncryptionReqBo dataEncryptionReqBo = new DataEncryptionReqBo();
            dataEncryptionReqBo.setBusiId(String.valueOf(pOrder.getBusiId()));
            dataEncryptionReqBo.setContent(data);
            DataEncryptionRspBo dataEncryptionRspBo = this.dataEncryptionService.dataEncryption(dataEncryptionReqBo);
            log.info("\u6d88\u606f\u53d1\u9001\u7684\u4e3b\u9898\u5185\u5bb9\u4e3a \uff1a" + dataEncryptionRspBo.getEncrypData() + "\u76ee\u6807\u5730\u5740\u4e3a\uff1a" + notifyUrl);
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("busiId", pOrder.getBusiCode());
            postParams.put("busiCode", pOrder.getBusiCode());
            postParams.put("content", dataEncryptionRspBo.getEncrypData());
            String resultData = HttpUtil.sendPost((String)notifyUrl, postParams);
            log.info("busiCode = " + busiId + "\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + resultData);
            JSONObject result = JSONObject.parseObject((String)resultData);
            if (result.containsKey((Object)"NOTIFY_RESULT") || result.containsKey((Object)"notifyResult")) {
                String status = "";
                if (result.containsKey((Object)"NOTIFY_RESULT")) {
                    status = result.getString("NOTIFY_RESULT");
                }
                if (result.containsKey((Object)"notifyResult")) {
                    status = result.getString("notifyResult");
                }
                if ("SUCCESS".equalsIgnoreCase(status)) {
                    pOrder.setCustyNotifyCode("0");
                    pOrder.setCustNotifyMsg("SUCCESS");
                } else {
                    pOrder.setCustyNotifyCode("1");
                    pOrder.setCustNotifyMsg("FAIL");
                }
            } else {
                pOrder.setCustyNotifyCode("1");
                pOrder.setCustNotifyMsg("FAIL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u56de\u8c03\u901a\u77e5\u5f02\u5e38\uff1a orderId = " + orderId + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            pOrder.setCustyNotifyCode("1");
            pOrder.setCustNotifyMsg(e.getMessage());
        }
        pOrder.setCustNotifyTime(this.queryDBDateBusiService.getDBDate());
        this.payOrderAtomService.update(pOrder);
    }

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        JSONObject data = JSONObject.parseObject((String)message.getContent());
        if (2 == Integer.parseInt(data.getString("callType"))) {
            data.remove((Object)"callType");
            this.dealPayNoticeByAbility(data.toJSONString());
        } else if (3 == Integer.parseInt(data.getString("callType"))) {
            data.remove((Object)"callType");
            this.dealPayNoticeByHttp(data.toJSONString());
        } else {
            log.info("\u672a\u914d\u7f6e\u7684\u56de\u8c03\u65b9\u5f0f");
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

