/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.req.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.atom.rsp.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.RefundMessageBo;
import com.tydic.payment.pay.bo.busi.req.CreateRefundOrderReqBo;
import com.tydic.payment.pay.bo.busi.rsp.CreateRefundOrderRspBo;
import com.tydic.payment.pay.busi.api.CreateRefundBusiService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.PorderDetallMapper;
import com.tydic.payment.pay.dao.po.PorderDetallPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="createRefundBusiService")
public class CreateRefundBusiServiceImpl
implements CreateRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(CreateRefundBusiServiceImpl.class);
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PorderDetallMapper porderDetallMapper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateRefundOrderRspBo createRefundOrder(CreateRefundOrderReqBo createRefundOrderReqBo) {
        String orderRefundId;
        HashMap<String, RefundMessageBo> refundMsg;
        PorderPo orderPo;
        BigDecimal retiredFee;
        String orderType;
        Long subBanking;
        Long busiId;
        CreateRefundOrderRspBo createRefundOrderRspBo;
        block26: {
            int i;
            RefundMessageBo refundMessageBo;
            List<PorderPayTransAtomRspBo> transAtomList;
            block24: {
                Long refundFee;
                block25: {
                    createRefundOrderRspBo = new CreateRefundOrderRspBo();
                    Long orderId = createRefundOrderReqBo.getSubBanking();
                    busiId = Long.parseLong(createRefundOrderReqBo.getBusiId());
                    String busiCode = createRefundOrderReqBo.getBusiCode();
                    String outOrderId = createRefundOrderReqBo.getOutOrderId();
                    String outRefundId = createRefundOrderReqBo.getOutRefundId();
                    subBanking = createRefundOrderReqBo.getSubBanking();
                    orderType = createRefundOrderReqBo.getOrderType();
                    Long totalFee = 0L;
                    refundFee = 0L;
                    try {
                        totalFee = MoneyUtils.fenToHao((BigDecimal)new BigDecimal(createRefundOrderReqBo.getRefundFee())).longValue();
                        refundFee = MoneyUtils.fenToHao((BigDecimal)new BigDecimal(createRefundOrderReqBo.getRefundFee())).longValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.info("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a" + e.getMessage());
                        createRefundOrderRspBo.setRspCode("8888");
                        createRefundOrderRspBo.setRspName("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a" + e.getMessage());
                        return createRefundOrderRspBo;
                    }
                    PorderPo orderInfo = this.payOrderAtomService.queryPorderByOutOrderId(outRefundId, subBanking);
                    if (orderInfo == null) {
                        log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
                        throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5916\u90e8\u8ba2\u5355\u53f7 \u3010" + outRefundId + "\u3011\u3010busiId =" + busiId + "\u3011 \u4e0d\u5b58\u5728");
                    }
                    retiredFee = null;
                    try {
                        retiredFee = MoneyUtils.haoToFen((Long)(orderInfo.getRefundFee() + refundFee));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
                    orderPayTransAtomReq.setOrderId(orderInfo.getOrderId());
                    orderPayTransAtomReq.setOrderStatus("A10");
                    transAtomList = null;
                    try {
                        transAtomList = this.porderPayTransAtomService.queryOrderPayTransByCondition(orderPayTransAtomReq);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.info("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5f02\u5e38\uff1aorderId =" + orderId);
                        createRefundOrderRspBo.setRspCode("8888");
                        createRefundOrderRspBo.setRspName("\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u5f02\u5e38\uff1aorderId =" + orderId);
                        return createRefundOrderRspBo;
                    }
                    if (transAtomList.size() == 0) {
                        log.info("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u8ba2\u5355\u6d41\u6c34");
                        createRefundOrderRspBo.setRspCode("8888");
                        createRefundOrderRspBo.setRspName("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u8ba2\u5355\u6d41\u6c34");
                        return createRefundOrderRspBo;
                    }
                    orderPo = new PorderPo();
                    refundMsg = new HashMap<String, RefundMessageBo>();
                    orderPo.setBusiId(busiId);
                    orderPo.setBusiCode(busiCode);
                    orderPo.setMerchantName(orderInfo.getMerchantName());
                    orderPo.setMerchantNameAbb(orderInfo.getMerchantNameAbb());
                    orderPo.setMerchantId(orderInfo.getMerchantId());
                    orderPo.setOrderType("02");
                    orderPo.setOrderStatus("B00");
                    orderPo.setOutOrderId(outOrderId);
                    orderPo.setOutRefundNo(outRefundId);
                    orderPo.setCreateOperId(createRefundOrderReqBo.getCreateOperId());
                    orderPo.setCreateOperIdName(createRefundOrderReqBo.getCreateOperIdName());
                    orderPo.setReqWay(createRefundOrderReqBo.getReqWay());
                    orderPo.setTotalFee(totalFee);
                    orderPo.setRealFee(refundFee);
                    orderPo.setChannelId(createRefundOrderReqBo.getChannelId());
                    orderPo.setChannelType(createRefundOrderReqBo.getChannelType());
                    orderPo.setProvinceId(orderInfo.getProvinceId());
                    orderPo.setCityId(orderInfo.getCityId());
                    orderPo.setDistrictId(orderInfo.getDistrictId());
                    orderPo.setSeparateAccountFlag(orderInfo.getSeparateAccountFlag());
                    orderPo.setRefundFee(refundFee);
                    try {
                        this.payOrderAtomService.createPorderInfo(orderPo);
                        if (!StringUtils.isEmpty((Object)createRefundOrderReqBo.getGoodsDetail())) {
                            this.createGoodsDetail(createRefundOrderReqBo.getGoodsDetail(), busiId, orderPo.getOrderId(), orderInfo.getMerchantId());
                        }
                    }
                    catch (Exception e) {
                        log.info("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                        e.printStackTrace();
                        throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                    orderRefundId = orderInfo.getOrderRefundId();
                    orderRefundId = StringUtils.isEmpty((Object)orderRefundId) ? String.valueOf(orderPo.getOrderId()) : orderRefundId + "," + orderPo.getOrderId();
                    refundMessageBo = null;
                    i = 0;
                    if (refundFee.compareTo(orderInfo.getTotalFee()) == 0) break block24;
                    if (!this.exit("71", transAtomList)) break block25;
                    BigDecimal hbLastFee = new BigDecimal("0");
                    int hb = this.searchFlag("71", transAtomList);
                    int other = 1 - hb;
                    try {
                        hbLastFee = MoneyUtils.haoToFen((Long)(transAtomList.get(hb).getPayFee() - transAtomList.get(hb).getRefundFee()));
                    }
                    catch (Exception e) {
                        log.info("\u91d1\u989d\u8f6c\u6362\u9519\u8bef" + e.getMessage());
                        e.printStackTrace();
                    }
                    if (hbLastFee.compareTo(new BigDecimal(createRefundOrderReqBo.getRefundFee())) >= 0) {
                        try {
                            refundMessageBo = this.createRefundTrans(orderPo.getOrderId(), busiId, orderPo.getMerchantId(), 0, createRefundOrderReqBo.getRefundFlag(), refundFee, transAtomList.get(hb));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                        }
                        refundMsg.put(String.valueOf(transAtomList.get(hb).getPayMethod()), refundMessageBo);
                        break block26;
                    } else {
                        try {
                            refundMessageBo = this.createRefundTrans(orderPo.getOrderId(), busiId, orderPo.getMerchantId(), 0, createRefundOrderReqBo.getRefundFlag(), MoneyUtils.fenToHaoToLong((BigDecimal)hbLastFee), transAtomList.get(hb));
                            refundMsg.put(String.valueOf(transAtomList.get(hb).getPayMethod()), refundMessageBo);
                            BigDecimal otherFee = new BigDecimal(createRefundOrderReqBo.getRefundFee()).subtract(hbLastFee);
                            refundMessageBo = this.createRefundTrans(orderPo.getOrderId(), busiId, orderPo.getMerchantId(), 1, createRefundOrderReqBo.getRefundFlag(), MoneyUtils.fenToHaoToLong((BigDecimal)otherFee), transAtomList.get(hb));
                            refundMsg.put(String.valueOf(transAtomList.get(hb).getPayMethod()), refundMessageBo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                        }
                    }
                }
                try {
                    refundMessageBo = this.createRefundTrans(orderPo.getOrderId(), busiId, orderPo.getMerchantId(), i, createRefundOrderReqBo.getRefundFlag(), refundFee, transAtomList.get(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                }
                refundMsg.put(String.valueOf(transAtomList.get(0).getPayMethod()), refundMessageBo);
                break block26;
            }
            for (PorderPayTransAtomRspBo porderPayTransAtomRspBo : transAtomList) {
                i = "71".equals(porderPayTransAtomRspBo.getPayMethod().toString()) ? 0 : 1;
                try {
                    refundMessageBo = this.createRefundTrans(orderPo.getOrderId(), busiId, orderPo.getMerchantId(), i, createRefundOrderReqBo.getRefundFlag(), porderPayTransAtomRspBo.getPayFee(), porderPayTransAtomRspBo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff1a" + e.getMessage());
                }
                refundMsg.put(String.valueOf(porderPayTransAtomRspBo.getPayMethod()), refundMessageBo);
            }
        }
        createRefundOrderRspBo.setBusiId(busiId);
        createRefundOrderRspBo.setOrderRefundId(orderRefundId);
        createRefundOrderRspBo.setOrderId(subBanking);
        createRefundOrderRspBo.setRefundId(orderPo.getOrderId());
        createRefundOrderRspBo.setRefundOrderId(refundMsg);
        createRefundOrderRspBo.setOrderType(orderType);
        createRefundOrderRspBo.setRetiredFee(retiredFee);
        createRefundOrderRspBo.setRefundDate(new SimpleDateFormat("yyyyMMdd").format(this.queryDBDateBusiService.getDBDate()));
        createRefundOrderRspBo.setRspCode("0000");
        createRefundOrderRspBo.setRspName("\u6210\u529f");
        return createRefundOrderRspBo;
    }

    public boolean exit(String key, List<PorderPayTransAtomRspBo> listBo) {
        for (PorderPayTransAtomRspBo bo : listBo) {
            if (!key.equals(bo.getPayMethod().toString())) continue;
            return true;
        }
        return false;
    }

    public int searchFlag(String key, List<PorderPayTransAtomRspBo> listBo) {
        int flag = 0;
        for (int i = 0; i < listBo.size(); ++i) {
            if (!key.equals(listBo.get(i).getPayMethod().toString())) continue;
            return i;
        }
        return flag;
    }

    public RefundMessageBo createRefundTrans(Long orderId, Long busiId, Long merchantId, int orderSort, Long refundFlag, Long refundFee, PorderPayTransAtomRspBo bo) throws ResourceException {
        RefundMessageBo refundMessageBo = new RefundMessageBo();
        String refundNo = "";
        PorderRefundTransAtomReqBo porderRefundTransAtomReqBo = new PorderRefundTransAtomReqBo();
        porderRefundTransAtomReqBo.setOrderId(orderId);
        porderRefundTransAtomReqBo.setPayOrderId(bo.getPayOrderId());
        porderRefundTransAtomReqBo.setRefundFlag(refundFlag);
        porderRefundTransAtomReqBo.setPayMethod(bo.getPayMethod());
        porderRefundTransAtomReqBo.setPayFee(refundFee);
        porderRefundTransAtomReqBo.setBusiId(busiId);
        porderRefundTransAtomReqBo.setMerchantId(merchantId);
        porderRefundTransAtomReqBo.setOrderStatus("B00");
        porderRefundTransAtomReqBo.setCreateTime(this.queryDBDateBusiService.getDBDate());
        porderRefundTransAtomReqBo.setOrderSort(orderSort);
        if ("3".equals(refundFlag.toString())) {
            porderRefundTransAtomReqBo.setTradeTime(bo.getTradeTime());
            porderRefundTransAtomReqBo.setOrderStatus("B10");
            porderRefundTransAtomReqBo.setPayNotifyTransId(porderRefundTransAtomReqBo.getPayNotifyTransId());
        }
        try {
            refundNo = this.porderRefundTransAtomService.createOrderRefundTrans(porderRefundTransAtomReqBo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5931\u8d25:" + e.getMessage());
            throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5931\u8d25");
        }
        if (!"30".equals(bo.getPayMethod())) {
            refundMessageBo.setPayNotifyTransId(bo.getPayNotifyTransId());
            refundMessageBo.setPayOrderId(bo.getPayOrderId());
            refundMessageBo.setTradeTime(bo.getTradeTime());
        }
        refundMessageBo.setRefundOrderId(refundNo);
        BigDecimal retiredFee = null;
        try {
            refundMessageBo.setRefundFee(MoneyUtils.haoToFen((Long)refundFee));
            retiredFee = MoneyUtils.haoToFen((Long)(bo.getRefundFee() + refundFee));
            refundMessageBo.setRetiredFee(retiredFee);
            refundMessageBo.setRefundFee(MoneyUtils.haoToFen((Long)refundFee));
        }
        catch (Exception e) {
            log.info("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
            e.printStackTrace();
            throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5931\u8d25\uff1a - \u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        return refundMessageBo;
    }

    private void createGoodsDetail(String goods_detail, Long busiId, Long orderId, Long merchantId) throws Exception {
        JSONArray goodDetailArr = null;
        ArrayList<PorderDetallPo> goodsDetaiList = new ArrayList<PorderDetallPo>();
        goodDetailArr = JSONObject.parseArray((String)goods_detail.toString());
        for (int i = 0; i < goodDetailArr.size(); ++i) {
            JSONObject goodsDetail = goodDetailArr.getJSONObject(i);
            log.info(goodsDetail.toJSONString());
            PorderDetallPo porderDetail = new PorderDetallPo();
            porderDetail.setBusiId((long)busiId);
            porderDetail.setOrderId((long)orderId);
            porderDetail.setMerchantId((long)merchantId);
            porderDetail.setGoodsName(goodsDetail.getString("goodsName"));
            porderDetail.setGoodsId(goodsDetail.getString("goodsId"));
            porderDetail.setGoodsNum(Integer.parseInt(goodsDetail.getString("goodsNum")));
            porderDetail.setBrandCode(goodsDetail.getString("brandCode"));
            porderDetail.setOfferType(goodsDetail.getString("offerType"));
            porderDetail.setOfferDivide(goodsDetail.getString("offerDivide"));
            porderDetail.setBelongPlatform(goodsDetail.getString("belongPlatform"));
            porderDetail.setOfferSupplier(goodsDetail.getString("offerSupplier"));
            porderDetail.setBelongStock(goodsDetail.getString("belongStock"));
            try {
                if (!StringUtils.isEmpty((Object)goodsDetail.getString("settPrice"))) {
                    porderDetail.setSettPrice(Long.parseLong(goodsDetail.getString("settPrice")));
                }
                if (!StringUtils.isEmpty((Object)goodsDetail.getString("offerTax"))) {
                    porderDetail.setOfferTax(Long.parseLong(goodsDetail.getString("offerTax")));
                }
            }
            catch (Exception e) {
                log.info("\u5546\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38:" + e.getMessage());
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u5931\u8d25\uff1a - \u5546\u54c1\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
            }
            porderDetail.setParentOfferId(goodsDetail.getString("parentOfferId"));
            if (goodsDetail.containsKey((Object)"goodsRefundPrice")) {
                porderDetail.setGoodsPrice(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(goodsDetail.getString("goodsRefundPrice"))));
            }
            if (goodsDetail.containsKey((Object)"goodsPrice")) {
                porderDetail.setGoodsPrice(MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(goodsDetail.getString("goodsPrice"))));
            }
            porderDetail.setGoodsFee(Long.parseLong(new BigDecimal(porderDetail.getGoodsPrice()).multiply(new BigDecimal(porderDetail.getGoodsNum())).toString()));
            goodsDetaiList.add(porderDetail);
        }
        this.porderDetallMapper.insertPorderDetall(goodsDetaiList);
    }

    public List<PorderDetallPo> queryPorderDetalls(Long orderId) {
        PorderDetallPo porderDetall = new PorderDetallPo();
        porderDetall.setOrderId(orderId);
        ArrayList<PorderDetallPo> porderDetalls = new ArrayList();
        try {
            porderDetalls = this.porderDetallMapper.getList(porderDetall);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return porderDetalls;
    }
}

