/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.bo.busi.req.DataEncryptionReqBo;
import com.tydic.payment.pay.bo.busi.rsp.DataEncryptionRspBo;
import com.tydic.payment.pay.busi.api.DataEncryptionService;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.rsa.util.EncodeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="dataEncryptionService")
public class DataEncryptionServiceImpl
implements DataEncryptionService {
    private static final Logger log = LoggerFactory.getLogger(DataEncryptionServiceImpl.class);
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    public DataEncryptionRspBo dataEncryption(DataEncryptionReqBo reqBo) {
        if (reqBo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u52a0\u5bc6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u6570\u636e\u52a0\u5bc6 BUSI_ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getContent())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u52a0\u5bc6\u4e3b\u4f53CONTENTS\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataEncryptionRspBo dataEncryptionRspBo = new DataEncryptionRspBo();
        try {
            BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
            busiSystemInfoPO.setBusiId(Long.parseLong(reqBo.getBusiId()));
            List<Object> po = new ArrayList();
            po = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
            if (po != null && po.size() <= 0) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9274\u6743\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            busiSystemInfoPO = (BusiSystemInfoPO)po.get(0);
            String rsaPrivateKey = busiSystemInfoPO.getRsaPrivateKey().trim();
            String signKey = busiSystemInfoPO.getSignKey().trim();
            log.info("\u652f\u4ed8\u4e2d\u5fc3\u8fd4\u56de \u4e1a\u52a1\u7cfb\u7edf\u52a0\u5bc6\u53c2\u6570\u9a7c\u5cf0\u660e\u6587\uff1a" + reqBo.getContent());
            String data = reqBo.getContent().trim();
            String encryption = EncodeUtil.privateEncode((String)data, (String)rsaPrivateKey, (String)signKey);
            log.info("\u652f\u4ed8\u4e2d\u5fc3\u8fd4\u56de \u4e1a\u52a1\u7cfb\u7edf\u52a0\u5bc6\u53c2\u6570\uff1a" + encryption);
            dataEncryptionRspBo.setEncrypData(encryption);
            dataEncryptionRspBo.setRspCode("0000");
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            dataEncryptionRspBo.setRspCode("8888");
            dataEncryptionRspBo.setRspName("\u6570\u636e\u52a0\u5bc6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return dataEncryptionRspBo;
    }

    public String transfrom(String data) {
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        JSONObject returnData = new JSONObject();
        Iterator iterator = jsonObject.keySet().iterator();
        String key = "";
        String transformKey = "";
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            transformKey = DataEncryptionServiceImpl.underscoreName(key);
            returnData.put(transformKey, jsonObject.get((Object)key));
        }
        return returnData.toJSONString();
    }

    public static String underscoreName(String camelCaseName) {
        StringBuilder result = new StringBuilder();
        int len = camelCaseName.length();
        if (camelCaseName != null && len > 0) {
            result.append(camelCaseName.substring(0, 1).toUpperCase());
            for (int i = 1; i < len; ++i) {
                char ch = camelCaseName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    result.append("_");
                    result.append(ch);
                    continue;
                }
                result.append(Character.toUpperCase(ch));
            }
        }
        return result.toString();
    }
}

