/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.rsp.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.bo.busi.req.AliPayQueryReqBo;
import com.tydic.payment.pay.bo.busi.req.ExternalQueryBusiReqBo;
import com.tydic.payment.pay.bo.busi.req.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.bo.busi.req.WXPayStateQueryBusiReqBO;
import com.tydic.payment.pay.bo.busi.rsp.AliPayQueryRspBo;
import com.tydic.payment.pay.bo.busi.rsp.ExternalQueryBusiRspBo;
import com.tydic.payment.pay.bo.busi.rsp.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.bo.busi.rsp.WXPayStateQueryBusiRspBO;
import com.tydic.payment.pay.busi.api.AliPayQueryService;
import com.tydic.payment.pay.busi.api.ExternalQueryBusiSerive;
import com.tydic.payment.pay.busi.api.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.api.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.api.WXPayStateQueryBusiService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="externalQueryBusiSerive")
public class ExternalQueryBusiSeriveImpl
implements ExternalQueryBusiSerive {
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private WXPayStateQueryBusiService wXPayStateQueryBusiService;
    @Autowired
    private AliPayQueryService aliPayQueryService;

    public ExternalQueryBusiRspBo dealQuery(ExternalQueryBusiReqBo externalQueryBusiReqBo) {
        ExternalQueryBusiRspBo externalQueryBusiRspBo = new ExternalQueryBusiRspBo();
        OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
        orderQueryConstructionReqBo.setBusiId(Long.valueOf(Long.parseLong(externalQueryBusiReqBo.getBusiId())));
        orderQueryConstructionReqBo.setOutOrderId(externalQueryBusiReqBo.getOriOrderId());
        OrderQueryConstructionRspBo constructionRspBo = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
        if (!"0000".equals(constructionRspBo.getRspCode())) {
            externalQueryBusiRspBo.setResultCode("FAIL");
            externalQueryBusiRspBo.setResultMsg("\u5916\u90e8\u8ba2\u5355\u53f7 \u3010" + externalQueryBusiReqBo.getOutOrderId() + "\u3011\u3010busiId= " + externalQueryBusiReqBo.getBusiId() + "\u3011\u8ba2\u5355\u4e0d\u5b58\u5728");
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u5931\u8d25");
            return externalQueryBusiRspBo;
        }
        Long orderId = constructionRspBo.getOrderId();
        PorderPo orderInfo = this.payOrderAtomService.queryByOrderId(orderId);
        PorderPayTransAtomRspBo transAtomRspBo = this.porderPayTransAtomService.queryLastRecordByOrderId(orderId);
        if (transAtomRspBo == null) {
            externalQueryBusiRspBo.setResultCode("PAYING");
            externalQueryBusiRspBo.setResultMsg("\u8ba2\u5355\u672a\u652f\u4ed8");
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u5931\u8d25");
            return externalQueryBusiRspBo;
        }
        String payOrderId = transAtomRspBo.getPayOrderId();
        if ("A20".equals(orderInfo.getOrderStatus())) {
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
            externalQueryBusiRspBo.setResultCode("FAIL");
            externalQueryBusiRspBo.setResultMsg(transAtomRspBo.getPayMsg());
            return externalQueryBusiRspBo;
        }
        if ("A10".equals(orderInfo.getOrderStatus())) {
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
            externalQueryBusiRspBo.setCreateOperId(orderInfo.getCreateOperId());
            externalQueryBusiRspBo.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
            externalQueryBusiRspBo.setOriOrderId(externalQueryBusiReqBo.getOriOrderId());
            externalQueryBusiRspBo.setOutOrderId(externalQueryBusiReqBo.getOutOrderId());
            externalQueryBusiRspBo.setRealFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getRealFee())));
            externalQueryBusiRspBo.setRemark(orderInfo.getOutRemark());
            externalQueryBusiRspBo.setReqWay(orderInfo.getReqWay());
            externalQueryBusiRspBo.setResultCode("SUCCESS");
            externalQueryBusiRspBo.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee())));
            externalQueryBusiRspBo.setTradeTime(orderInfo.getTradeTime());
            externalQueryBusiRspBo.setTransactionsId(String.valueOf(orderInfo.getOrderId()));
            externalQueryBusiRspBo.setCouponFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getDiscountFee() == null ? 0L : orderInfo.getDiscountFee()))));
            externalQueryBusiRspBo.setBanlenceFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getBalanceFee() == null ? 0L : orderInfo.getDiscountFee()))));
            externalQueryBusiRspBo.setPayMethod(String.valueOf(transAtomRspBo.getPayMethod()));
            return externalQueryBusiRspBo;
        }
        String payMethod = String.valueOf(transAtomRspBo.getPayMethod());
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
        paraReq.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        Map<String, Object> paramMap = this.getParamMap(paraInfo);
        if ("A00".equals(orderInfo.getOrderStatus())) {
            String payStatus = null;
            String msg = null;
            if ("10".equals(transAtomRspBo.getPayMethod() + "") || "11".equals(transAtomRspBo.getPayMethod() + "") || "13".equals(transAtomRspBo.getPayMethod() + "") || "12".equals(transAtomRspBo.getPayMethod() + "") || "14".equals(transAtomRspBo.getPayMethod() + "") || "15".equals(transAtomRspBo.getPayMethod() + "")) {
                WXPayStateQueryBusiReqBO wXPayOrderQueryReq = new WXPayStateQueryBusiReqBO();
                wXPayOrderQueryReq.setOrderId(String.valueOf(orderId));
                wXPayOrderQueryReq.setPayOrderId(payOrderId);
                wXPayOrderQueryReq.setParamMap(paramMap);
                WXPayStateQueryBusiRspBO wXPayStateQueryBusiRspBO = null;
                try {
                    wXPayStateQueryBusiRspBO = this.wXPayStateQueryBusiService.dealWXPayStateQuery(wXPayOrderQueryReq);
                }
                catch (Exception e) {
                    throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5fae\u4fe1\u67e5\u8be2\u5f02\u5e38");
                }
                payStatus = wXPayStateQueryBusiRspBO.getPayStatus();
                msg = wXPayStateQueryBusiRspBO.getMsg();
            }
            if ("20".equals(transAtomRspBo.getPayMethod() + "") || "21".equals(transAtomRspBo.getPayMethod() + "") || "23".equals(transAtomRspBo.getPayMethod() + "") || "22".equals(transAtomRspBo.getPayMethod() + "") || "24".equals(transAtomRspBo.getPayMethod() + "")) {
                AliPayQueryReqBo aliPayQueryReqBo = new AliPayQueryReqBo();
                aliPayQueryReqBo.setOrderId(orderId);
                aliPayQueryReqBo.setPayOrderId(payOrderId);
                aliPayQueryReqBo.setParamMap(paramMap);
                AliPayQueryRspBo aliPayQueryRspBo = this.aliPayQueryService.dealQuery(aliPayQueryReqBo);
                payStatus = aliPayQueryRspBo.getPayStatus();
                msg = aliPayQueryRspBo.getMsg();
            }
            if ("SUCCESS".equals(payStatus)) {
                orderInfo = this.payOrderAtomService.queryByOrderId(constructionRspBo.getOrderId());
                externalQueryBusiRspBo.setCreateOperId(orderInfo.getCreateOperId());
                externalQueryBusiRspBo.setMerchantId(String.valueOf(orderInfo.getMerchantId()));
                externalQueryBusiRspBo.setOriOrderId(externalQueryBusiReqBo.getOriOrderId());
                externalQueryBusiRspBo.setOutOrderId(externalQueryBusiReqBo.getOutOrderId());
                externalQueryBusiRspBo.setRealFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getRealFee())));
                externalQueryBusiRspBo.setRemark(orderInfo.getOutRemark());
                externalQueryBusiRspBo.setReqWay(orderInfo.getReqWay());
                externalQueryBusiRspBo.setResultCode("SUCCESS");
                externalQueryBusiRspBo.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)orderInfo.getTotalFee())));
                externalQueryBusiRspBo.setTradeTime(orderInfo.getTradeTime());
                externalQueryBusiRspBo.setTransactionsId(String.valueOf(orderInfo.getOrderId()));
                externalQueryBusiRspBo.setCouponFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getDiscountFee() == null ? 0L : orderInfo.getDiscountFee()))));
                externalQueryBusiRspBo.setBanlenceFee(String.valueOf(MoneyUtils.haoToFen((Long)(orderInfo.getBalanceFee() == null ? 0L : orderInfo.getDiscountFee()))));
                externalQueryBusiRspBo.setPayMethod(String.valueOf(transAtomRspBo.getPayMethod()));
            } else {
                if ("FAIL".equals(payStatus)) {
                    externalQueryBusiRspBo.setResultCode("FAIL");
                    externalQueryBusiRspBo.setResultMsg(msg);
                    return externalQueryBusiRspBo;
                }
                externalQueryBusiRspBo.setResultCode("PAYING");
                externalQueryBusiRspBo.setResultMsg("\u8ba2\u5355\u672a\u652f\u4ed8");
            }
            externalQueryBusiRspBo.setRspCode("0000");
            externalQueryBusiRspBo.setRspName("\u67e5\u8be2\u6210\u529f");
        }
        return externalQueryBusiRspBo;
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

