/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.bo.busi.req.PaymentMethodInquiryReqBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierPayMethodReqBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierReqBo;
import com.tydic.payment.pay.bo.busi.rsp.PaymentMethodInquiryRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierPayMethodRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierRspBo;
import com.tydic.payment.pay.busi.api.PaymentMethodInquiryService;
import com.tydic.payment.pay.busi.api.QueryCashierPayMethodService;
import com.tydic.payment.pay.busi.api.QueryCashierService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentMethodInquiryService")
public class PaymentMethodInquiryServiceImpl
implements PaymentMethodInquiryService {
    private static final Logger log = LoggerFactory.getLogger(PaymentMethodInquiryServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierPayMethodService queryCashierPayMethodService;
    @Autowired
    private QueryCashierService queryCashierService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public PaymentMethodInquiryRspBo paymentMethodInquiryService(PaymentMethodInquiryReqBo reqBo) {
        if (reqBo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u4fe1\u606f\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u4fe1\u606f ORDER_ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String order_id = "";
        try {
            Long.parseLong(reqBo.getOrderId());
            order_id = reqBo.getOrderId();
        }
        catch (Exception e) {
            log.info("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff1a  \u8bf4\u660e\u662f\u5bc6\u6587\u3002\u5219\u8fdb\u884c\u89e3\u5bc6\u64cd\u4f5c" + e.getMessage());
            log.error("\u5bc6\u6587\uff1aorderId = " + reqBo.getOrderId() + "\u67e5\u8be2\u6536\u94f6\u53f0\u4fe1\u606f");
            try {
                order_id = new String(OrderCiphertext.decode((String)reqBo.getOrderId()));
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        PaymentMethodInquiryRspBo paymentMethodInquiryRspBo = new PaymentMethodInquiryRspBo();
        try {
            log.info("\u660e\u6587\uff1a orderId = " + order_id);
            Long orderId = Long.parseLong(order_id);
            PorderPo porderPo = this.payOrderAtomService.queryPorderInfo(orderId);
            if (porderPo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
            }
            if ("A10".equals(porderPo.getOrderStatus())) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8");
            }
            Long merthan_id = porderPo.getMerchantId();
            Long busi_id = porderPo.getBusiId();
            String busiId = String.valueOf(busi_id);
            String merthanId = String.valueOf(merthan_id);
            QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
            queryCashierReqBo.setBusiId(busiId);
            queryCashierReqBo.setReqWay(porderPo.getReqWay());
            QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
            if (queryCashierRspBo == null || "8888".equals(queryCashierRspBo.getRspCode())) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u672a\u914d\u7f6e\u6536\u94f6\u53f0\u6a21\u677f");
            }
            QueryCashierPayMethodReqBo queryCashierPayMethodReqBo = new QueryCashierPayMethodReqBo();
            queryCashierPayMethodReqBo.setMerchantId(String.valueOf(merthanId));
            queryCashierPayMethodReqBo.setCashierTemplate(queryCashierRspBo.getCashierTemplate());
            queryCashierPayMethodReqBo.setChannelId(porderPo.getChannelId());
            QueryCashierPayMethodRspBo queryCashierPayMethodRspBo = this.queryCashierPayMethodService.queryCashierPayMethod(queryCashierPayMethodReqBo);
            if ("8888".equals(queryCashierPayMethodRspBo.getRspCode())) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237\u672a\u914d\u7f6e\u652f\u4ed8\u65b9\u5f0f");
            }
            paymentMethodInquiryRspBo.setPayMethod(queryCashierPayMethodRspBo.getCodePayMethodList());
            paymentMethodInquiryRspBo.setCreateTime(porderPo.getCreateTime());
            Date curDate = this.queryDBDateBusiService.getDBDate();
            Calendar rightNow = Calendar.getInstance();
            rightNow.setTime(porderPo.getExpTime());
            Long timeOut = rightNow.getTimeInMillis() - curDate.getTime();
            if (Long.compare(timeOut, 0L) <= 0) {
                paymentMethodInquiryRspBo.setPayTimeLeft("0");
            } else {
                paymentMethodInquiryRspBo.setPayTimeLeft(String.valueOf(timeOut));
            }
            paymentMethodInquiryRspBo.setDetailName(porderPo.getDetailName());
            paymentMethodInquiryRspBo.setMerchantName(porderPo.getMerchantName());
            paymentMethodInquiryRspBo.setMerchantNameAbb(porderPo.getMerchantNameAbb());
            paymentMethodInquiryRspBo.setOrderId(String.valueOf(porderPo.getOrderId()));
            paymentMethodInquiryRspBo.setRedirectUrl(porderPo.getRedirectUrl());
            paymentMethodInquiryRspBo.setTotalFee(String.valueOf(MoneyUtils.haoToFen((Long)porderPo.getTotalFee())));
            BigDecimal realFee = MoneyUtils.haoToFen((Long)(porderPo.getTotalFee() - porderPo.getDiscountFee()));
            paymentMethodInquiryRspBo.setOutOrderId(porderPo.getOutOrderId());
            paymentMethodInquiryRspBo.setRealFee(realFee.toString());
            paymentMethodInquiryRspBo.setRspCode("0000");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            log.info("\u8ba2\u5355\u6821\u9a8c\u5931\u8d25,\u8bf7\u786e\u8ba4\u8ba2\u5355\u53f7");
            paymentMethodInquiryRspBo.setRspCode("8888");
            paymentMethodInquiryRspBo.setRspName(e.getMessage());
        }
        return paymentMethodInquiryRspBo;
    }

    public boolean Validity(Date date) {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(date);
        rightNow.add(6, 1);
        Date olddate = rightNow.getTime();
        Date newDate = this.queryDBDateBusiService.getDBDate();
        return olddate.after(newDate);
    }
}

