/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.rsp.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.busi.req.PollingPayStateBusiReqBo;
import com.tydic.payment.pay.bo.busi.rsp.PollingPayStateBusiRspBo;
import com.tydic.payment.pay.busi.api.PollingPayStateBusiService;
import com.tydic.payment.pay.dao.po.PorderPo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pollingPayStateBusiService")
public class PollingPayStateBusiServiceImpl
implements PollingPayStateBusiService {
    private static final Logger log = LoggerFactory.getLogger(PollingPayStateBusiServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    public PollingPayStateBusiRspBo pollingPayState(PollingPayStateBusiReqBo req) throws Exception {
        log.info("\u8fdb\u5165\u8f6e\u8be2\u652f\u4ed8\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\uff1a" + req);
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8f6e\u8be2\u652f\u4ed8\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u8f6e\u8be2\u652f\u4ed8\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PollingPayStateBusiRspBo rsp = new PollingPayStateBusiRspBo();
        rsp.setPayOrderId(req.getPayOrderId());
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setPayOrderId(req.getPayOrderId());
        PorderPayTransAtomRspBo orderPayTrans = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq);
        if (orderPayTrans == null) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8f6e\u8be2\u652f\u4ed8\u5f02\u6b65\u901a\u77e5\u7ed3\u679c\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u3010payOrderId=" + req.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\uff01");
            return rsp;
        }
        PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderPayTrans.getOrderId());
        if (orderInfo == null) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u8f6e\u8be2\u652f\u4ed8\u72b6\u6001\u4e1a\u52a1\u670d\u52a1\u6839\u636e\u3010payOrderId=" + req.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            return rsp;
        }
        String pOrderStatus = orderInfo.getOrderStatus();
        String transOrderStatus = orderPayTrans.getOrderStatus();
        if ("A20".equals(pOrderStatus) || "A20".equals(transOrderStatus)) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u652f\u4ed8\u5931\u8d25\uff01");
            rsp.setPayStatus("FAIL");
        } else if ("A00".equals(pOrderStatus) || "A00".equals(transOrderStatus)) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getPayOrderId() + "\u3011\u8fd8\u672a\u652f\u4ed8");
            rsp.setPayStatus("PAYING");
        } else if ("A10".equals(pOrderStatus) && "A10".equals(transOrderStatus)) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u652f\u4ed8\u6210\u529f");
            rsp.setPayStatus("SUCCESS");
        }
        return rsp;
    }
}

