/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.busi.api.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.constant.PayConfigConstants;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryCashierInfoPayParaAttrService")
public class QueryCashierInfoPayParaAttrServiceImpl
implements QueryCashierInfoPayParaAttrService {
    private static final Logger log = LoggerFactory.getLogger(QueryCashierInfoPayParaAttrServiceImpl.class);
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PayParaInfoAtomService payParaInfoAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;

    public QueryCashierInfoPayParaAttrRspBo queryPayParaAttr(QueryCashierInfoPayParaAttrReqBo bo) {
        log.info("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u4fe1\u606f\u5165\u53c2\uff1a" + bo);
        this.validateArg(bo);
        String merchantId = bo.getMerchantId();
        MerChantInfoPo qryMerchantPo = new MerChantInfoPo();
        qryMerchantPo.setMerchantId(Long.valueOf(merchantId));
        QueryCashierInfoPayParaAttrRspBo retBo = new QueryCashierInfoPayParaAttrRspBo();
        List<MerChantInfoPo> queryMerChantInfoByCondition = this.merchantInfoAtomService.queryMerChantInfoByCondition(qryMerchantPo);
        if (queryMerChantInfoByCondition.isEmpty()) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u67e5\u8be2\u5546\u6237\u652f\u4ed8\u53c2\u6570\u9519\u8bef\uff1a\u5546\u6237  " + merchantId + " \u4e0d\u5b58\u5728");
            return retBo;
        }
        List<Object> queryAttrByMethodAndMerchantId = new ArrayList();
        Integer merchantType = queryMerChantInfoByCondition.get(0).getMerchantType();
        if (PayConfigConstants.MERCHANT_TYPE_SUB.equals(merchantType)) {
            Long mainMerchantId = queryMerChantInfoByCondition.get(0).getMainMerchantId();
            queryAttrByMethodAndMerchantId = this.queryAttrByMethodAndMerchantId(mainMerchantId, Long.valueOf(bo.getPayMethod()));
        }
        MerchantPayMethodRelPo mpmrPo = new MerchantPayMethodRelPo();
        mpmrPo.setPayMethod(Long.valueOf(bo.getPayMethod()));
        mpmrPo.setMerchantId(Long.valueOf(bo.getMerchantId()));
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(mpmrPo);
        if (queryMerchantPayMethodRelByCondition.isEmpty()) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u6b64\u5546\u6237(" + bo.getMerchantId() + ")\u672a\u914d\u7f6e\u8be5\u652f\u4ed8\u65b9\u5f0f");
            return retBo;
        }
        Long payParaId = queryMerchantPayMethodRelByCondition.get(0).getPayParaId();
        PayParaInfoPo po1 = new PayParaInfoPo();
        po1.setPayParaId(payParaId);
        List<PayParaInfoPo> queryPayParaInfoByCondition = this.payParaInfoAtomService.queryPayParaInfoByCondition(po1);
        if (queryPayParaInfoByCondition.isEmpty()) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u8be5\u652f\u4ed8\u914d\u7f6e(" + payParaId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        if (!"1".equals(queryPayParaInfoByCondition.get(0).getState().trim())) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u8be5\u652f\u4ed8\u914d\u7f6e(" + payParaId + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        PayParaInfoPo payParaInfoPo = queryPayParaInfoByCondition.get(0);
        PayParaInfoAttrPo po2 = new PayParaInfoAttrPo();
        po2.setPayParaId(payParaInfoPo.getPayParaId());
        List<PayParaInfoAttrPo> queryPayParaInfoAttrByCondition = this.payParaInfoAttrAtomService.queryPayParaInfoAttrByCondition(po2);
        if (queryPayParaInfoAttrByCondition.isEmpty()) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u672a\u67e5\u8be2\u5230\u5546\u6237(" + bo.getMerchantId() + ")\u8be6\u7ec6\u53c2\u6570\u914d\u7f6e");
            return retBo;
        }
        queryPayParaInfoAttrByCondition.addAll(queryAttrByMethodAndMerchantId);
        return this.sortDate(payParaInfoPo, queryPayParaInfoAttrByCondition);
    }

    private List<PayParaInfoAttrPo> queryAttrByMethodAndMerchantId(Long merchantId, Long payMethod) {
        MerchantPayMethodRelPo mpmrPo = new MerchantPayMethodRelPo();
        mpmrPo.setPayMethod(payMethod);
        mpmrPo.setMerchantId(merchantId);
        List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(mpmrPo);
        if (queryMerchantPayMethodRelByCondition.isEmpty()) {
            return new ArrayList<PayParaInfoAttrPo>();
        }
        Long payParaId = queryMerchantPayMethodRelByCondition.get(0).getPayParaId();
        PayParaInfoPo po1 = new PayParaInfoPo();
        po1.setPayParaId(payParaId);
        List<PayParaInfoPo> queryPayParaInfoByCondition = this.payParaInfoAtomService.queryPayParaInfoByCondition(po1);
        if (queryPayParaInfoByCondition.isEmpty()) {
            return new ArrayList<PayParaInfoAttrPo>();
        }
        if (!"1".equals(queryPayParaInfoByCondition.get(0).getState().trim())) {
            return new ArrayList<PayParaInfoAttrPo>();
        }
        PayParaInfoPo payParaInfoPo = queryPayParaInfoByCondition.get(0);
        PayParaInfoAttrPo po2 = new PayParaInfoAttrPo();
        po2.setPayParaId(payParaInfoPo.getPayParaId());
        List<PayParaInfoAttrPo> queryPayParaInfoAttrByCondition = this.payParaInfoAttrAtomService.queryPayParaInfoAttrByCondition(po2);
        if (queryPayParaInfoAttrByCondition.isEmpty()) {
            return new ArrayList<PayParaInfoAttrPo>();
        }
        return queryPayParaInfoAttrByCondition;
    }

    private QueryCashierInfoPayParaAttrRspBo sortDate(PayParaInfoPo payParaInfoPo, List<PayParaInfoAttrPo> list) {
        QueryCashierInfoPayParaAttrRspBo retBo = new QueryCashierInfoPayParaAttrRspBo();
        BeanUtils.copyProperties((Object)payParaInfoPo, (Object)retBo);
        retBo.setPayParaId(payParaInfoPo.getPayParaId() + "");
        retBo.setPaymentInsId(payParaInfoPo.getPaymentInsId() + "");
        ArrayList<PayParaInfoAttrBo> retList = new ArrayList<PayParaInfoAttrBo>();
        for (PayParaInfoAttrPo po : list) {
            PayParaInfoAttrBo bo = new PayParaInfoAttrBo();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            bo.setAttrId(po.getAttrId() + "");
            bo.setPayParaId(po.getPayParaId() + "");
            retList.add(bo);
        }
        retBo.setInfoPayParaAttrList(retList);
        retBo.setRspCode("0000");
        retBo.setRspName("\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u6210\u529f");
        return retBo;
    }

    private void validateArg(QueryCashierInfoPayParaAttrReqBo bo) {
        if (bo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getMerchantId() == null || bo.getMerchantId().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getPayMethod() == null || bo.getPayMethod().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

