/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.bo.busi.req.QueryCashierReqBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierRspBo;
import com.tydic.payment.pay.busi.api.QueryCashierService;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="queryCashierService")
public class QueryCashierServiceImpl
implements QueryCashierService {
    private static final Logger log = LoggerFactory.getLogger(QueryCashierServiceImpl.class);
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;

    public QueryCashierRspBo queryCashier(QueryCashierReqBo bo) {
        log.info("\u6536\u94f6\u53f0\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a" + bo.toString());
        this.validateArg(bo);
        QueryCashierRspBo retBo = new QueryCashierRspBo();
        RelBusiCashierPo qryRelPo = new RelBusiCashierPo();
        qryRelPo.setBusiId(Long.valueOf(bo.getBusiId()));
        qryRelPo.setReqWay(bo.getReqWay());
        List<RelBusiCashierPo> queryRelBusiCashier = this.relBusiCashierAtomService.queryRelBusiCashier(qryRelPo);
        if (queryRelBusiCashier.isEmpty()) {
            log.error("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5173\u7cfb");
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5173\u7cfb");
        }
        CashierTemplatePo qryCaPo = new CashierTemplatePo();
        qryCaPo.setCashierTemplate((long)queryRelBusiCashier.get(0).getCashierTemplate());
        List<CashierTemplatePo> queryCashierTemplateByCondition = this.cashierTemplateAtomService.queryCashierTemplateByCondition(qryCaPo);
        if (queryCashierTemplateByCondition.isEmpty()) {
            log.error("\u672a\u67e5\u8be2\u5230\u8be5\u6a21\u677f\u4fe1\u606f");
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u8be5\u6a21\u677f\u4fe1\u606f");
        }
        CashierTemplatePo cashierTemplatePo = queryCashierTemplateByCondition.get(0);
        BeanUtils.copyProperties((Object)cashierTemplatePo, (Object)retBo);
        retBo.setCashierTemplate(cashierTemplatePo.getCashierTemplate() + "");
        retBo.setRspCode("0000");
        retBo.setRspName("\u5546\u6237\u6536\u94f6\u53f0\u6a21\u677f\u67e5\u8be2\u6210\u529f");
        return retBo;
    }

    private void validateArg(QueryCashierReqBo bo) {
        if (bo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u6a21\u677f\u51fa\u9519\uff1a\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getBusiId() == null || bo.getBusiId().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u6a21\u677f\u51fa\u9519\uff1a\u5165\u53c2\u5c5e\u6027busiId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (bo.getReqWay() == null || bo.getReqWay().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u6536\u94f6\u53f0\u6a21\u677f\u51fa\u9519\uff1a\u5165\u53c2\u5c5e\u6027ReqWay\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

