/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.bo.busi.req.UpdateInfoBusiSystemReqAndTempBo;
import com.tydic.payment.pay.bo.busi.req.UpdateInfoBusiSystemReqBo;
import com.tydic.payment.pay.bo.busi.rsp.UpdateInfoBusiSystemRspBo;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.api.UpdateInfoBusiSystemService;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.rsa.util.RsaEncodeUtil;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="updateInfoBusiSystemService")
public class UpdateInfoBusiSystemServiceImpl
implements UpdateInfoBusiSystemService {
    private static final Logger log = LoggerFactory.getLogger(UpdateInfoBusiSystemServiceImpl.class);
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    public UpdateInfoBusiSystemRspBo updateInfoBusiSystem(UpdateInfoBusiSystemReqBo reqBo) {
        List<BusiSystemInfoPO> qryBusiSystemList;
        log.info("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u5165\u53c2\uff1a" + reqBo);
        this.validateArg(reqBo);
        UpdateInfoBusiSystemRspBo retBo = new UpdateInfoBusiSystemRspBo();
        String busiId = reqBo.getBusiId();
        BusiSystemInfoPO po = new BusiSystemInfoPO();
        if (reqBo.getBusiId() != null && !reqBo.getBusiId().trim().isEmpty()) {
            po.setBusiId(Long.valueOf(reqBo.getBusiId()));
        }
        if ((qryBusiSystemList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(po)).isEmpty()) {
            retBo.setRspCode("8888");
            retBo.setRspName("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u670d\u52a1\u5931\u8d25\uff1a\u5bf9\u5e94\u4e1a\u52a1\u7cfb\u7edfid\u4e0d\u5b58\u5728");
            return retBo;
        }
        BusiSystemInfoPO po2 = new BusiSystemInfoPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)po2);
        if (!StringUtils.isEmpty((Object)reqBo.getCallType())) {
            po2.setCallType(Integer.valueOf(reqBo.getCallType()));
        }
        po2.setBusiId(Long.valueOf(reqBo.getBusiId()));
        po2.setUpdateTime(this.queryDBDateBusiService.getDBDate());
        if (reqBo.getIsNeedUpdateRsa() != null && "1".equals(reqBo.getIsNeedUpdateRsa().trim())) {
            Map<String, String> map = this.genKey();
            po2.setRsaPrivateKey(map.get("private"));
            po2.setRsaPublicKey(map.get("public"));
            po2.setSignKey(map.get("signKey"));
        }
        this.busiSystemInfoAtomService.updateBusiSystemInfo(po2);
        RelBusiCashierPo qryRelBusiPo = new RelBusiCashierPo();
        qryRelBusiPo.setBusiId(Long.valueOf(busiId));
        this.relBusiCashierAtomService.deleteRelBusiCashierByBusiId(qryRelBusiPo);
        List reqAndTempList = reqBo.getReqAndTempList();
        for (UpdateInfoBusiSystemReqAndTempBo uBo : reqAndTempList) {
            CashierTemplatePo qryTmpPo = new CashierTemplatePo();
            qryTmpPo.setCashierTemplate(Long.valueOf(uBo.getCashierTemplate()));
            List<CashierTemplatePo> queryCashierTemplateByCondition = this.cashierTemplateAtomService.queryCashierTemplateByCondition(qryTmpPo);
            if (queryCashierTemplateByCondition.isEmpty()) {
                retBo.setRspCode("8888");
                retBo.setRspName("\u6a21\u677f" + uBo.getCashierTemplate() + "\u4e0d\u5b58\u5728");
                return retBo;
            }
            RelBusiCashierPo createPo = new RelBusiCashierPo();
            BeanUtils.copyProperties((Object)uBo, (Object)createPo);
            createPo.setCashierTemplate(Long.valueOf(uBo.getCashierTemplate()));
            createPo.setBusiId(Long.valueOf(busiId));
            this.relBusiCashierAtomService.createRelBusiCashier(createPo);
        }
        BusiSystemInfoPO po3 = new BusiSystemInfoPO();
        po3.setBusiId(Long.valueOf(busiId));
        List<BusiSystemInfoPO> queryBusiSystemInfoByCondition = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(po3);
        BeanUtils.copyProperties((Object)queryBusiSystemInfoByCondition.get(0), (Object)retBo);
        retBo.setBusiId(queryBusiSystemInfoByCondition.get(0).getBusiId() + "");
        retBo.setRspCode("0000");
        retBo.setRspName("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u6210\u529f\uff01");
        return retBo;
    }

    private Map<String, String> genKey() {
        Map<String, String> map = new HashMap();
        try {
            map = RsaEncodeUtil.generateRSAKeys();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f-\u751f\u6210\u79c1\u94a5\uff0c\u516c\u94a5\u548c\u7b7e\u540d\u4e32\u5f02\u5e38\uff1a" + e);
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f-\u751f\u6210\u79c1\u94a5\uff0c\u516c\u94a5\u548c\u7b7e\u540d\u4e32\u5f02\u5e38");
        }
        map.put("signKey", RsaEncodeUtil.getRandomStringByLength((int)32));
        return map;
    }

    private void validateArg(UpdateInfoBusiSystemReqBo reqBo) {
        if (reqBo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027BusiId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiName())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027BusiName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getState())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027State\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!("1".equals(reqBo.getState().trim()) || "-1".equals(reqBo.getState().trim()) || "0".equals(reqBo.getState().trim()))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027State\u5fc5\u987b\u4e3a1\uff0c-1\u6216\u80050");
        }
        if (StringUtils.isEmpty((Object)reqBo.getReqAndTempListStr())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempListStr\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List parseArray = JSON.parseArray((String)reqBo.getReqAndTempListStr(), UpdateInfoBusiSystemReqAndTempBo.class);
        reqBo.setReqAndTempList(parseArray);
        List reqAndTempList = reqBo.getReqAndTempList();
        if (CollectionUtils.isEmpty((Collection)reqAndTempList)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UpdateInfoBusiSystemReqAndTempBo tmpBo : reqAndTempList) {
            if (tmpBo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)tmpBo.getReqWay())) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027ReqWay\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)tmpBo.getCashierTemplate())) continue;
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027ReqAndTempList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027CashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

