/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayInfoFileMappingAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.atom.RelBusiCashierAtomService;
import com.tydic.payment.pay.bo.busi.BusiPaymentMerchantDeleteBusiReqBO;
import com.tydic.payment.pay.bo.busi.BusiPaymentMerchantDeleteBusiRspBO;
import com.tydic.payment.pay.bo.busi.QueryRulePayParaReqBo;
import com.tydic.payment.pay.bo.busi.QueryRulePayParaRspBo;
import com.tydic.payment.pay.bo.busi.UpdateInfoMechartPayMethodBo;
import com.tydic.payment.pay.bo.busi.UpdateInfoMechartPayParaAttrBo;
import com.tydic.payment.pay.bo.busi.UpdateInfoMechartPaymentInsBo;
import com.tydic.payment.pay.bo.busi.UpdateInfoMechartReqBo;
import com.tydic.payment.pay.bo.busi.UpdateInfoMechartRspBo;
import com.tydic.payment.pay.bo.busi.UpdateMechartBusiSysBo;
import com.tydic.payment.pay.bo.busi.ValidatePaymentInsReqBo;
import com.tydic.payment.pay.bo.busi.ValidatePaymentInsRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryRulePayParaListRspBo;
import com.tydic.payment.pay.busi.api.BusiPaymentMerchantCreateBusiService;
import com.tydic.payment.pay.busi.api.BusiPaymentMerchantDeleteBusiService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.api.QueryRulePayParaService;
import com.tydic.payment.pay.busi.api.UpdateInfoMechartService;
import com.tydic.payment.pay.busi.api.ValidatePaymentInsBusiService;
import com.tydic.payment.pay.dao.BusiCashierRelMapper;
import com.tydic.payment.pay.dao.po.BusiCashierRelPo;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayInfoFileMappingPO;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import com.tydic.payment.pay.dao.po.RelBusiCashierPo;
import com.tydic.payment.pay.util.RelBusiMerchantPayMerchantUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateInfoMechartService")
public class UpdateInfoMechartServiceImpl
implements UpdateInfoMechartService {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateInfoMechartServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private PayParaInfoAtomService payParaInfoAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private ValidatePaymentInsBusiService validatePaymentInsBusiService;
    @Autowired
    private RelBusiCashierAtomService relBusiCashierAtomService;
    @Autowired
    private BusiCashierRelMapper busiCashierRelMapper;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayInfoFileMappingAtomService payInfoFileMappingAtomService;
    @Autowired
    private QueryRulePayParaService queryRulePayParaService;
    @Autowired
    private BusiPaymentMerchantDeleteBusiService busiPaymentMerchantDeleteBusiService;
    @Autowired
    private BusiPaymentMerchantCreateBusiService busiPaymentMerchantCreateBusiService;

    public UpdateInfoMechartRspBo updateMechant(UpdateInfoMechartReqBo bo) {
        LOG.info("\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)bo));
        this.validateArg(bo);
        UpdateInfoMechartRspBo retBo = new UpdateInfoMechartRspBo();
        Date dbDate = this.queryDBDateBusiService.getDBDate();
        try {
            String merchantId = bo.getMerchantId();
            MerChantInfoPo qryMPo = new MerChantInfoPo();
            qryMPo.setMerchantId(Long.valueOf(merchantId));
            List<MerChantInfoPo> queryMerChantInfoByCondition = this.merchantInfoAtomService.queryMerChantInfoByCondition(qryMPo);
            if (queryMerChantInfoByCondition.isEmpty()) {
                LoggerProUtils.error(LOG, "\u66f4\u65b0\u5546\u6237\u5931\u8d25\uff0c\u5546\u6237\uff1a " + merchantId + " \u4e0d\u5b58\u5728");
                retBo.setRspCode("0000");
                retBo.setRspName("\u66f4\u65b0\u5546\u6237\u5931\u8d25\uff0c\u5546\u6237\uff1a " + merchantId + " \u4e0d\u5b58\u5728");
                return retBo;
            }
            MerChantInfoPo updateMPo = new MerChantInfoPo();
            BeanUtils.copyProperties((Object)bo, (Object)updateMPo);
            updateMPo.setMerchantId(Long.valueOf(merchantId));
            updateMPo.setUpdateTime(dbDate);
            this.merchantInfoAtomService.updateMerChantInfo(updateMPo);
            BusiSystemMerchantRelPo delPo = new BusiSystemMerchantRelPo();
            delPo.setMerchantId(Long.valueOf(merchantId));
            this.busiSystemMerchantRelAtomService.deleteBusiSystemMerchantRelByMerchant(delPo);
            BusiPaymentMerchantDeleteBusiReqBO deleteRelBo = new BusiPaymentMerchantDeleteBusiReqBO();
            deleteRelBo.setMerchantId(Long.valueOf(merchantId));
            BusiPaymentMerchantDeleteBusiRspBO delete = this.busiPaymentMerchantDeleteBusiService.delete(deleteRelBo);
            if (!"0000".equals(delete.getRspCode())) {
                throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5220\u9664\u4e1a\u52a1\u5546\u6237-\u652f\u4ed8\u5546\u6237");
            }
            List infoBusiList = bo.getInfoBusiList();
            for (UpdateMechartBusiSysBo busiBo : infoBusiList) {
                String busiId = busiBo.getBusiId();
                BusiSystemInfoPO busiPo = new BusiSystemInfoPO();
                busiPo.setBusiId(Long.valueOf(busiId));
                List<BusiSystemInfoPO> queryBusiSystemInfoByCondition = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiPo);
                if (queryBusiSystemInfoByCondition.isEmpty()) {
                    throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e1a\u52a1\u7cfb\u7edf " + busiId + " \u4e0d\u5b58\u5728");
                }
                List list = busiBo.getReqWayList();
                if (list != null && !list.isEmpty()) {
                    BusiCashierRelPo busiCPo = new BusiCashierRelPo();
                    busiCPo.setBusiId(Long.valueOf(busiId));
                    List<BusiCashierRelPo> queryBusiCashierRelByCondition = this.busiCashierRelMapper.queryBusiCashierRelByCondition(busiCPo);
                    HashSet busiReqSet = new HashSet();
                    for (BusiCashierRelPo bpo : queryBusiCashierRelByCondition) {
                        busiReqSet.add(bpo.getReqWay());
                    }
                    for (String reqStr : list) {
                        if (!busiReqSet.contains(reqStr)) {
                            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e1a\u52a1\u7cfb\u7edf" + busiId + "\u65e0\u6b64\u63a5\u5165\u65b9\u5f0f\uff1a" + reqStr);
                        }
                        BusiSystemMerchantRelPo busiMerRelPo = new BusiSystemMerchantRelPo();
                        busiMerRelPo.setBusiId(Long.valueOf(busiId));
                        busiMerRelPo.setMerchantId(Long.valueOf(merchantId));
                        busiMerRelPo.setUpdateTime(dbDate);
                        busiMerRelPo.setReqWay(reqStr);
                        this.busiSystemMerchantRelAtomService.createBusiSystemMerchantRel(busiMerRelPo);
                    }
                    continue;
                }
                RelBusiCashierPo qryBCRelPo = new RelBusiCashierPo();
                qryBCRelPo.setBusiId(Long.valueOf(busiId));
                List<RelBusiCashierPo> queryRelBusiCashier = this.relBusiCashierAtomService.queryRelBusiCashier(qryBCRelPo);
                if (queryRelBusiCashier.isEmpty()) {
                    throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e1a\u52a1\u7cfb\u7edf" + busiId + "\u6ca1\u6709\u4e00\u4e2a\u63a5\u5165\u65b9\u5f0f");
                }
                for (RelBusiCashierPo bpo : queryRelBusiCashier) {
                    BusiSystemMerchantRelPo busiMerRelPo = new BusiSystemMerchantRelPo();
                    busiMerRelPo.setBusiId(Long.valueOf(busiId));
                    busiMerRelPo.setMerchantId(Long.valueOf(merchantId));
                    busiMerRelPo.setReqWay(bpo.getReqWay());
                    busiMerRelPo.setUpdateTime(dbDate);
                    this.busiSystemMerchantRelAtomService.createBusiSystemMerchantRel(busiMerRelPo);
                }
            }
            MerchantPayMethodRelPo qryMPRelPo = new MerchantPayMethodRelPo();
            qryMPRelPo.setMerchantId(Long.valueOf(merchantId));
            List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryMPRelPo);
            MerchantPayMethodRelPo delMerPo = new MerchantPayMethodRelPo();
            delMerPo.setMerchantId(Long.valueOf(merchantId));
            int deleteMerchantPayMethodRelByMerchantId = this.merchantPayMethodRelAtomService.deleteMerchantPayMethodRelByMerchantId(delMerPo);
            LOG.info("\u5220\u9664\u65e7\u7684\u5546\u6237-\u652f\u4ed8\u5173\u7cfb\u6570\u636e\u6210\u529f\uff1a" + deleteMerchantPayMethodRelByMerchantId + "\u6761");
            for (MerchantPayMethodRelPo merchantPayMethodRelPo : queryMerchantPayMethodRelByCondition) {
                Long paymentInsId = merchantPayMethodRelPo.getPaymentInsId();
                QueryRulePayParaReqBo paraReqBo = new QueryRulePayParaReqBo();
                paraReqBo.setPaymentInsId(String.valueOf(paymentInsId));
                QueryRulePayParaRspBo ruleparaRspBo = this.queryRulePayParaService.queryRulePayPara(paraReqBo);
                List ruleparaList = ruleparaRspBo.getParaList();
                HashMap rulePayParaMap = new HashMap();
                for (QueryRulePayParaListRspBo temp : ruleparaList) {
                    String mapId = temp.getParameterCode();
                    rulePayParaMap.put(mapId, temp);
                }
                PayParaInfoAttrPo parareqpo = new PayParaInfoAttrPo();
                parareqpo.setPayParaId(merchantPayMethodRelPo.getPayParaId());
                List<PayParaInfoAttrPo> paraAttrList = this.payParaInfoAttrAtomService.queryPayParaInfoAttrByCondition(parareqpo);
                for (PayParaInfoAttrPo temp : paraAttrList) {
                    QueryRulePayParaListRspBo rsParaListRspBo = (QueryRulePayParaListRspBo)rulePayParaMap.get(temp.getAttrCode());
                    if (!rsParaListRspBo.getStoreType().equals("2")) continue;
                    PayInfoFileMappingPO filePo = new PayInfoFileMappingPO();
                    filePo.setFileId(temp.getAttrValue());
                    LOG.info("\u5220\u9664\u6587\u4ef6\u6620\u5c04\u5173\u7cfb\u670d\u52a1\u7684\u5165\u53c2\uff1a" + JSON.toJSONString((Object)filePo));
                    int delFlag = this.payInfoFileMappingAtomService.deleteFile(filePo);
                    if (delFlag == 1) {
                        LOG.info("\u5220\u9664\u6587\u4ef6\u6620\u5c04\u5173\u7cfb\u6210\u529f");
                        continue;
                    }
                    LOG.info("\u5220\u9664\u6587\u4ef6\u6620\u5c04\u5173\u7cfb\u5931\u8d25");
                }
                Long payParaId = merchantPayMethodRelPo.getPayParaId();
                PayParaInfoAttrPo delAttrPo = new PayParaInfoAttrPo();
                delAttrPo.setPayParaId(payParaId);
                this.payParaInfoAttrAtomService.deletePayParaInfoAttrByParaId(delAttrPo);
                PayParaInfoPo delParaPo = new PayParaInfoPo();
                delParaPo.setPayParaId(payParaId);
                this.payParaInfoAtomService.deletePayParaInfo(delParaPo);
            }
            List infoPaymentInsList2 = bo.getInfoPaymentInsList();
            for (UpdateInfoMechartPaymentInsBo pbo : infoPaymentInsList2) {
                Object tmpo22;
                String paymentInsId = pbo.getPaymentInsId();
                ValidatePaymentInsReqBo validateBo = new ValidatePaymentInsReqBo();
                validateBo.setPaymentInsId(Long.valueOf(paymentInsId));
                ArrayList<Long> payMethodList = new ArrayList<Long>();
                for (Object tmpo22 : pbo.getPayMethodList()) {
                    payMethodList.add(Long.valueOf(tmpo22.getPayMethod()));
                }
                validateBo.setPayMethodList(payMethodList);
                ArrayList<String> payParaList = new ArrayList<String>();
                validateBo.setPayParaList(payParaList);
                tmpo22 = pbo.getRulePayParaList().iterator();
                while (tmpo22.hasNext()) {
                    UpdateInfoMechartPayParaAttrBo tmbo = (UpdateInfoMechartPayParaAttrBo)tmpo22.next();
                    payParaList.add(tmbo.getAttrCode());
                }
                ValidatePaymentInsRspBo validatePaymentIns = this.validatePaymentInsBusiService.validatePaymentIns(validateBo);
                if ("0000".equals(validatePaymentIns.getRspCode())) continue;
                throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", validatePaymentIns.getRspName());
            }
            List list = bo.getInfoPaymentInsList();
            this.writeAttrAndMethod(list, Long.valueOf(merchantId), dbDate);
            retBo.setMerchantId(merchantId);
            retBo.setRspCode("0000");
            retBo.setRspName("\u66f4\u65b0\u5546\u6237\u6210\u529f");
            LOG.info("\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)retBo));
            return retBo;
        }
        catch (Exception e) {
            e.printStackTrace();
            retBo.setRspCode("8888");
            retBo.setRspCode("\u66f4\u65b0\u5546\u6237\u5f02\u5e38");
            return retBo;
        }
    }

    private void writeAttrAndMethod(List<UpdateInfoMechartPaymentInsBo> infoPaymentInsList, Long merchantId, Date dbDate) {
        for (UpdateInfoMechartPaymentInsBo bo : infoPaymentInsList) {
            List rulePayParaList = bo.getRulePayParaList();
            List payMethodList = bo.getPayMethodList();
            String paymentInsId = bo.getPaymentInsId();
            PayParaInfoPo payParaPo = new PayParaInfoPo();
            payParaPo.setPaymentInsId(Long.valueOf(paymentInsId));
            payParaPo.setParaName("\u5546\u6237(" + merchantId + ")\u7684\u652f\u4ed8\u53c2\u6570(" + paymentInsId + ")");
            payParaPo.setState("1");
            payParaPo.setUpdateTime(dbDate);
            Long createPayParaInfo = this.payParaInfoAtomService.createPayParaInfo(payParaPo);
            QueryRulePayParaReqBo paraReqBo = new QueryRulePayParaReqBo();
            paraReqBo.setPaymentInsId(paymentInsId);
            QueryRulePayParaRspBo paraRspBo = this.queryRulePayParaService.queryRulePayPara(paraReqBo);
            List paraList = paraRspBo.getParaList();
            HashMap<String, QueryRulePayParaListRspBo> rulePayParaMap = new HashMap<String, QueryRulePayParaListRspBo>();
            for (QueryRulePayParaListRspBo temp : paraList) {
                String mapId = temp.getParameterCode();
                rulePayParaMap.put(mapId, temp);
            }
            for (UpdateInfoMechartPayParaAttrBo attrBo : rulePayParaList) {
                PayParaInfoAttrPo attrPo = new PayParaInfoAttrPo();
                BeanUtils.copyProperties((Object)attrBo, (Object)attrPo);
                attrPo.setPayParaId(createPayParaInfo);
                attrPo.setUpdateTime(dbDate);
                this.payParaInfoAttrAtomService.createPayParaInfoAttr(attrPo);
                boolean relMerchantAndPayMerchant = RelBusiMerchantPayMerchantUtils.createRelMerchantAndPayMerchant(merchantId, Long.valueOf(paymentInsId), attrPo, this.busiPaymentMerchantCreateBusiService);
                if (!relMerchantAndPayMerchant) {
                    throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u652f\u4ed8\u670d\u52a1 -> \u5f02\u5e38\uff1a\u63d2\u5165\u4e1a\u52a1\u5546\u6237-\u652f\u4ed8\u5546\u6237\u5931\u8d25\uff01");
                }
                QueryRulePayParaListRspBo rBo = (QueryRulePayParaListRspBo)rulePayParaMap.get(attrBo.getAttrCode());
                if (rBo == null) {
                    LOG.info("\u6ca1\u6709\u5728rulePayParaMap\u4e2d\u627e\u5230\u5bf9\u8c61");
                }
                if (rBo.getParameterCode().trim() == null) {
                    LOG.info("rulePayParaMap\u4e2d\u7684\u5bf9\u8c61\u7684parameter_name\u6ca1\u6709\u88ab\u5b58\u50a8");
                }
                if (!rBo.getStoreType().equals("2")) continue;
                PayInfoFileMappingPO fileMappingPo = new PayInfoFileMappingPO();
                fileMappingPo.setFileId(attrBo.getAttrValue());
                fileMappingPo.setFileName(attrBo.getAttrValue());
                int AddFileMappingFlag = this.payInfoFileMappingAtomService.addFile(fileMappingPo);
                if (AddFileMappingFlag == 1) {
                    LOG.info("\u63d2\u5165\u6587\u4ef6\u6620\u5c04\u5173\u7cfb\u6210\u529f");
                    continue;
                }
                LOG.info("\u63d2\u5165\u6587\u4ef6\u6620\u5c04\u5173\u7cfb\u5931\u8d25");
            }
            for (UpdateInfoMechartPayMethodBo meBo : payMethodList) {
                MerchantPayMethodRelPo mPo = new MerchantPayMethodRelPo();
                mPo.setPaymentInsId(Long.valueOf(paymentInsId));
                mPo.setMerchantId(merchantId);
                mPo.setPayMethod(Long.valueOf(meBo.getPayMethod()));
                mPo.setPayParaId(createPayParaInfo);
                mPo.setUpdateTime(dbDate);
                this.merchantPayMethodRelAtomService.createMerchantPayMethodRel(mPo);
            }
        }
    }

    private void validateArg(UpdateInfoMechartReqBo bo) {
        if (bo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getMerchantId() == null || bo.getMerchantId().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027MerchantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getMerchantName() == null || bo.getMerchantName().trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027MerchantName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String flag = bo.getFlag();
        if (flag == null || flag.trim().isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027Flag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(flag.trim()) && !"0".equals(flag.trim())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027Flag\u5c5e\u6027\u53ea\u80fd\u4e3a1(\u6709\u6548)\u6216\u80050(\u65e0\u6548)");
        }
        List infoBusiList = bo.getInfoBusiList();
        if (infoBusiList == null || infoBusiList.isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027infoBusiList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UpdateMechartBusiSysBo busiBo : infoBusiList) {
            if (busiBo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027infoBusiList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (busiBo.getBusiId() == null || busiBo.getBusiId().trim().isEmpty()) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027infoBusiList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027BusiId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List reqWayList = busiBo.getReqWayList();
            if (reqWayList != null) continue;
            busiBo.setReqWayList(new ArrayList());
        }
        List infoPaymentInsList = bo.getInfoPaymentInsList();
        if (infoPaymentInsList == null || infoPaymentInsList.isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UpdateInfoMechartPaymentInsBo paymentBo : infoPaymentInsList) {
            if (paymentBo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (paymentBo.getPaymentInsId() == null || paymentBo.getPaymentInsId().trim().isEmpty()) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList rulePayParaList = paymentBo.getRulePayParaList();
            if (rulePayParaList == null) {
                rulePayParaList = new ArrayList();
                paymentBo.setRulePayParaList(rulePayParaList);
            }
            for (UpdateInfoMechartPayParaAttrBo attrBo : rulePayParaList) {
                if (attrBo == null) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027RulePayParaList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (attrBo.getAttrCode() == null || attrBo.getAttrCode().trim().isEmpty()) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027RulePayParaList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027AttrCode\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (attrBo.getAttrValue() != null && !attrBo.getAttrValue().trim().isEmpty()) continue;
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027RulePayParaList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027AttrValue\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List payMethodList = paymentBo.getPayMethodList();
            if (payMethodList == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027PayMethodList\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (UpdateInfoMechartPayMethodBo methodBo : payMethodList) {
                if (methodBo == null) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027PayMethodList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (methodBo.getPayMethod() != null && !methodBo.getPayMethod().trim().isEmpty()) continue;
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u5546\u6237\u4fe1\u606f\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u5c5e\u6027InfoPaymentInsList\u7684\u5bf9\u8c61\u7684\u5c5e\u6027PayMethodList\u4e2d\u7684\u5bf9\u8c61\u7684\u5c5e\u6027PayMethod\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

