/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayParaRuleAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.bo.busi.ValidatePaymentInsReqBo;
import com.tydic.payment.pay.bo.busi.ValidatePaymentInsRspBo;
import com.tydic.payment.pay.busi.api.ValidatePaymentInsBusiService;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PayParaRulePo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="validatePaymentInsBusiService")
public class ValidatePaymentInsBusiServiceImpl
implements ValidatePaymentInsBusiService {
    private Logger log = LoggerFactory.getLogger(ValidatePaymentInsBusiServiceImpl.class);
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private PayParaRuleAtomService payParaRuleAtomService;

    public ValidatePaymentInsRspBo validatePaymentIns(ValidatePaymentInsReqBo bo) {
        this.log.info("\u6821\u9a8c\u652f\u4ed8\u673a\u6784\u7684\u652f\u4ed8\u53c2\u6570\u548c\u652f\u4ed8\u65b9\u5f0f\u662f\u5426\u7b26\u5408\u540e\u53f0\u914d\u7f6e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)bo));
        this.validateArg(bo);
        ValidatePaymentInsRspBo retBo = new ValidatePaymentInsRspBo();
        Long paymentInsId = bo.getPaymentInsId();
        PaymentInsPo qryPaymentInsPo = new PaymentInsPo();
        qryPaymentInsPo.setPaymentInsId(paymentInsId);
        List<PaymentInsPo> queryPaymentInf = this.paymentInsAtomService.queryPaymentInf(qryPaymentInsPo);
        if (queryPaymentInf.isEmpty()) {
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be5\u652f\u4ed8\u673a\u6784\u4e0d\u5b58\u5728");
        }
        PaymentInsPo paymentInsPo = queryPaymentInf.get(0);
        PayMethodPo qryPaymethodPo = new PayMethodPo();
        qryPaymethodPo.setPaymentInsId(paymentInsId);
        List<PayMethodPo> queryPayMethod = this.payMethodAtomService.queryPayMethod(qryPaymethodPo);
        HashSet<Long> qryPaymentSet = new HashSet<Long>();
        for (PayMethodPo po : queryPayMethod) {
            qryPaymentSet.add(po.getPayMethod());
        }
        List getPaymethodList = bo.getPayMethodList();
        if (getPaymethodList.isEmpty()) {
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u65b9\u5f0f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet inputPaymentSet = new HashSet();
        inputPaymentSet.addAll(getPaymethodList);
        for (Long l : inputPaymentSet) {
            if (qryPaymentSet.contains(l)) continue;
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u673a\u6784(" + paymentInsPo.getPaymentInsName() + ":" + paymentInsPo.getPaymentInsId() + ")\u65e0\u652f\u4ed8\u65b9\u5f0f\uff1a" + l);
        }
        PayParaRulePo qryPayParaPo = new PayParaRulePo();
        qryPayParaPo.setPaymentInsId(paymentInsId);
        List<PayParaRulePo> queryPayParaRuleByCondition = this.payParaRuleAtomService.queryPayParaRuleByCondition(qryPayParaPo);
        HashSet<String> qryAttrSet = new HashSet<String>();
        if (!queryPayParaRuleByCondition.isEmpty()) {
            for (PayParaRulePo ppo : queryPayParaRuleByCondition) {
                qryAttrSet.add(ppo.getParameterCode());
            }
        }
        List getPayparalist = bo.getPayParaList();
        HashSet getPayParaSet = new HashSet();
        getPayParaSet.addAll(getPayparalist);
        for (String s : getPayParaSet) {
            if (qryAttrSet.contains(s)) continue;
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u673a\u6784(" + paymentInsPo.getPaymentInsName() + ":" + paymentInsPo.getPaymentInsId() + ")\u65e0\u652f\u4ed8\u53c2\u6570:" + s);
        }
        for (String s : qryAttrSet) {
            if (!("1".equals(bo.getSubFlag()) ? !getPayParaSet.contains(s) && ("sub_mch_id".equals(s) || "sub_appid".equals(s)) : !getPayParaSet.contains(s))) continue;
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u673a\u6784(" + paymentInsPo.getPaymentInsName() + ":" + paymentInsPo.getPaymentInsId() + ")\u4e2d\u5982\u4e0b\u53c2\u6570\u4e3a\u5fc5\u4f20\uff1a" + s);
        }
        retBo.setRspName("\u652f\u4ed8\u673a\u6784\u53c2\u6570\u548c\u652f\u4ed8\u65b9\u5f0f\u6821\u9a8c\u6210\u529f");
        retBo.setRspCode("0000");
        this.log.info("\u6821\u9a8c\u652f\u4ed8\u673a\u6784\u7684\u652f\u4ed8\u53c2\u6570\u548c\u652f\u4ed8\u65b9\u5f0f\u662f\u5426\u7b26\u5408\u540e\u53f0\u914d\u7f6e\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private void validateArg(ValidatePaymentInsReqBo bo) {
        if (bo == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9a8c\u8bc1\u652f\u4ed8\u673a\u6784\u65b9\u6cd5\u548c\u53c2\u6570\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bo.getPaymentInsId() == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9a8c\u8bc1\u652f\u4ed8\u673a\u6784\u65b9\u6cd5\u548c\u53c2\u6570\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027PaymentInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList payMethodList = bo.getPayMethodList();
        if (payMethodList == null) {
            payMethodList = new ArrayList();
            bo.setPayMethodList(payMethodList);
        }
        for (Long l : payMethodList) {
            if (l != null) continue;
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9a8c\u8bc1\u652f\u4ed8\u673a\u6784\u65b9\u6cd5\u548c\u53c2\u6570\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027PayMethodList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList payParaList = bo.getPayParaList();
        if (payParaList == null) {
            payParaList = new ArrayList();
            bo.setPayParaList(payParaList);
        }
        for (String s : payParaList) {
            if (s != null && !s.trim().isEmpty()) continue;
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u9a8c\u8bc1\u652f\u4ed8\u673a\u6784\u65b9\u6cd5\u548c\u53c2\u6570\u670d\u52a1\u5165\u53c2bo\u5bf9\u8c61\u7684\u5c5e\u6027PayParaList\u4e2d\u7684\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

