/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.bo.busi.req.WXAppPayBusiReqBO;
import com.tydic.payment.pay.bo.busi.req.WXUnifiedOrderReqBO;
import com.tydic.payment.pay.bo.busi.rsp.WXAppPayBusiRspBO;
import com.tydic.payment.pay.bo.busi.rsp.WXUnifiedOrderRspBO;
import com.tydic.payment.pay.busi.api.WXAppPayBusiService;
import com.tydic.payment.pay.busi.api.WXUnifiedOrderService;
import com.tydic.payment.pay.wx.util.RandomStringGenerator;
import com.tydic.payment.pay.wx.util.Signature;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXAppPayBusiService")
public class WXAppPayBusiServiceImpl
implements WXAppPayBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXAppPayBusiServiceImpl.class);
    @Autowired
    private WXUnifiedOrderService wXUnifiedOrderService;

    public WXAppPayBusiRspBO dealWXAppPay(WXAppPayBusiReqBO req) {
        log.info("\u8fdb\u5165\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\uff1a" + req);
        WXAppPayBusiRspBO rsp = new WXAppPayBusiRspBO();
        try {
            this.checkInputParas(req);
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName(e.getMessage());
            return rsp;
        }
        String appid = (String)req.getParamMap().get("native_appid");
        String mchid = (String)req.getParamMap().get("mchid");
        String key = (String)req.getParamMap().get("signkey");
        String subMchId = (String)req.getParamMap().get("subMchId");
        String trade_type = "APP";
        WXUnifiedOrderReqBO unifiedOrderReq = new WXUnifiedOrderReqBO();
        unifiedOrderReq.setAppId(appid);
        unifiedOrderReq.setMchId(mchid);
        unifiedOrderReq.setSubMchId(subMchId);
        unifiedOrderReq.setKey(key);
        unifiedOrderReq.setTradeType(trade_type);
        unifiedOrderReq.setTotalFee(req.getTotalFee());
        unifiedOrderReq.setOrderId(req.getOrderId());
        unifiedOrderReq.setMerchantId(req.getMerchantId());
        unifiedOrderReq.setPayMethod("14");
        WXUnifiedOrderRspBO unifiedOrderRsp = new WXUnifiedOrderRspBO();
        try {
            unifiedOrderRsp = this.wXUnifiedOrderService.dealUnifiedOrder(unifiedOrderReq);
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return rsp;
        }
        if (!"0000".equals(unifiedOrderRsp.getRspCode())) {
            rsp.setRspCode(unifiedOrderRsp.getRspCode());
            rsp.setRspName(unifiedOrderRsp.getRspName());
            return rsp;
        }
        String prepay_id = unifiedOrderRsp.getPrepayId();
        if (StringUtils.isEmpty((Object)prepay_id)) {
            rsp.setRspCode("0000");
            rsp.setPayStatus("FAIL");
            rsp.setRspName("\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u6ca1\u6709\u53d6\u5230\u5fae\u4fe1\u8fd4\u56de\u7684prepay_id\u503c");
            return rsp;
        }
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String pacKage = "Sign=WXPay";
        String nonceStr = RandomStringGenerator.getRandomStringByLength((int)32);
        HashMap<String, String> signMsg = new HashMap<String, String>();
        signMsg.put("appId", appid);
        signMsg.put("partnerId", mchid);
        signMsg.put("prepayId", prepay_id);
        signMsg.put("timeStamp", timeStamp);
        signMsg.put("nonceStr", nonceStr);
        signMsg.put("pacKage", pacKage);
        String sign = "";
        try {
            sign = Signature.getSign(signMsg, (String)key);
        }
        catch (Exception e) {
            rsp.setRspCode("0000");
            rsp.setPayStatus("FAIL");
            rsp.setRspName("\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u4e8c\u6b21\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage());
            return rsp;
        }
        rsp.setAppId(appid);
        rsp.setPartnerId(mchid);
        rsp.setPrepayId(prepay_id);
        rsp.setTimeStamp(timeStamp);
        rsp.setNonceStr(nonceStr);
        rsp.setPacKage(pacKage);
        rsp.setSign(sign);
        rsp.setPayOrderId(unifiedOrderRsp.getPayOrderId());
        rsp.setRedirectUrl(unifiedOrderRsp.getRedirectUrl());
        rsp.setRspCode("0000");
        rsp.setRspName("\u6210\u529f");
        rsp.setPayStatus("SUCCESS");
        return rsp;
    }

    private void checkInputParas(WXAppPayBusiReqBO req) {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMerchantId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getParamMap())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("appid"))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u5e94\u7528id\u3010appid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("mchid"))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u5546\u6237\u53f7\u3010mchid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("signkey"))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1APP\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u7b7e\u540d\u5bc6\u94a5\u3010sign_key\u3011\uff01");
        }
    }
}

