/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.rsp.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.busi.req.CallBackNoticeReqBo;
import com.tydic.payment.pay.bo.busi.req.WXPayStateQueryBusiReqBO;
import com.tydic.payment.pay.bo.busi.rsp.CallBackNoticeRspBo;
import com.tydic.payment.pay.bo.busi.rsp.WXPayStateQueryBusiRspBO;
import com.tydic.payment.pay.busi.api.CallBackNoticeService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.api.WXOrderQueryBusiService;
import com.tydic.payment.pay.busi.api.WXPayStateQueryBusiService;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.wx.req.bo.WXApiOrderQueryReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiOrderQueryRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXPayStateQueryBusiService")
public class WXPayStateQueryBusiServiceImpl
implements WXPayStateQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXPayStateQueryBusiServiceImpl.class);
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXOrderQueryBusiService wXOrderQueryBusiService;

    public WXPayStateQueryBusiRspBO dealWXPayStateQuery(WXPayStateQueryBusiReqBO req) throws Exception {
        PorderPayTransAtomRspBo orderPayTransAtomRsp;
        log.info("\u8fdb\u5165\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1" + req);
        WXPayStateQueryBusiRspBO rsp = new WXPayStateQueryBusiRspBO();
        rsp.setPayOrderId(req.getPayOrderId());
        this.checkInputParas(req);
        PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
        orderPayTransAtomReq.setOrderId(Long.valueOf(req.getOrderId()));
        orderPayTransAtomReq.setPayOrderId(req.getPayOrderId());
        if (!StringUtils.isEmpty((Object)req.getMerchantId())) {
            orderPayTransAtomReq.setMerchantId(Long.valueOf(req.getMerchantId()));
        }
        if ((orderPayTransAtomRsp = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq)) == null) {
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u3010payOrderId=" + req.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6d41\u6c34\u662f\u5426\u6b63\u786e\uff01");
        }
        WXApiOrderQueryRspBO wXApiOrderQueryRsp = this.payStateQuery(req, rsp, String.valueOf(orderPayTransAtomRsp.getPayMethod()));
        this.updateOrder(req, wXApiOrderQueryRsp, rsp, orderPayTransAtomReq);
        return rsp;
    }

    private WXApiOrderQueryRspBO payStateQuery(WXPayStateQueryBusiReqBO req, WXPayStateQueryBusiRspBO rsp, String payMethod) throws Exception {
        String appid = null;
        appid = "15".equals(payMethod) ? (String)req.getParamMap().get("applets_appid") : ("12".equals(payMethod) ? (String)req.getParamMap().get("native_appid") : (String)req.getParamMap().get("appid"));
        String mchid = (String)req.getParamMap().get("mchid");
        String key = (String)req.getParamMap().get("signkey");
        String sub_mch_id = (String)req.getParamMap().get("subMchId");
        WXApiOrderQueryReqBO wXApiOrderQueryReq = new WXApiOrderQueryReqBO().setAppid(appid).setMch_id(mchid).setSub_mch_id(sub_mch_id).setOut_trade_no(req.getPayOrderId()).setNonce_str("").setKey(key);
        WXApiOrderQueryRspBO wXApiOrderQueryRsp = this.wXOrderQueryBusiService.orderQuery(wXApiOrderQueryReq);
        if (!"SUCCESS".equals(wXApiOrderQueryRsp.getReturn_code())) {
            rsp.setRspCode("0000");
            rsp.setRspName(wXApiOrderQueryRsp.getReturn_msg());
            rsp.setPayStatus("FAIL");
        }
        if (!"SUCCESS".equals(wXApiOrderQueryRsp.getResult_code())) {
            rsp.setRspCode("0000");
            rsp.setRspName(wXApiOrderQueryRsp.getErr_code_des());
            rsp.setPayStatus("FAIL");
        }
        if ("SUCCESS".equals(wXApiOrderQueryRsp.getTrade_state())) {
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            rsp.setPayStatus("SUCCESS");
        } else if ("USERPAYING".equals(wXApiOrderQueryRsp.getTrade_state())) {
            rsp.setRspCode("0000");
            rsp.setRspName(wXApiOrderQueryRsp.getTrade_state_desc());
            rsp.setPayStatus("PAYING");
            rsp.setMsg(wXApiOrderQueryRsp.getTrade_state_desc());
        } else {
            rsp.setRspCode("0000");
            rsp.setMsg(wXApiOrderQueryRsp.getTrade_state_desc());
            rsp.setRspName(wXApiOrderQueryRsp.getTrade_state_desc());
            rsp.setPayStatus("FAIL");
        }
        return wXApiOrderQueryRsp;
    }

    private void updateOrder(WXPayStateQueryBusiReqBO req, WXApiOrderQueryRspBO wXApiOrderQueryRspBO, WXPayStateQueryBusiRspBO rsp, PorderPayTransAtomReqBo orderPayTransAtomReq) throws Exception {
        String totalFee = wXApiOrderQueryRspBO.getTotal_fee();
        totalFee = StringUtils.isEmpty((Object)totalFee) ? "" : new BigDecimal(totalFee).multiply(new BigDecimal("100")).toString();
        PorderPo updateOrderPo = new PorderPo();
        if (!StringUtils.isEmpty((Object)totalFee)) {
            updateOrderPo.setRealFee(Long.parseLong(totalFee));
            updateOrderPo.setOnlineFee(Long.parseLong(totalFee));
        }
        updateOrderPo.setOrderId(orderPayTransAtomReq.getOrderId());
        String tradeTime = wXApiOrderQueryRspBO.getTime_end();
        if (StringUtils.isEmpty((Object)tradeTime)) {
            tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate());
        }
        updateOrderPo.setTradeTime(tradeTime);
        orderPayTransAtomReq.setTradeTime(tradeTime);
        if ("SUCCESS".equals(rsp.getPayStatus())) {
            orderPayTransAtomReq.setOrderStatus("A10");
            orderPayTransAtomReq.setPayNotifyTransId(wXApiOrderQueryRspBO.getTransaction_id());
            updateOrderPo.setOrderStatus("A10");
        } else if ("FAIL".equals(rsp.getPayStatus())) {
            orderPayTransAtomReq.setOrderStatus("A20");
            updateOrderPo.setOrderStatus("A20");
        }
        if (!"PAYING".equals(rsp.getPayStatus())) {
            this.payOrderAtomService.update(updateOrderPo);
            this.porderPayTransAtomService.updateOrderPayTransByPayOrderId(orderPayTransAtomReq);
            CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
            callBackNoticeReqBo.setOrderId(orderPayTransAtomReq.getOrderId());
            CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
            if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                log.info(orderPayTransAtomReq.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
            }
        }
    }

    private void checkInputParas(WXPayStateQueryBusiReqBO req) {
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getParamMap())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u3010paramMap\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("appid"))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u5e94\u7528id\u3010appid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("mchid"))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u6ca1\u6709\u5546\u6237\u53f7\u3010mchid\u3011\uff01");
        }
        if (StringUtils.isEmpty(req.getParamMap().get("signkey"))) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u53c2\u6570MAP\u4e2d\u6ca1\u6709\u7b7e\u540d\u5bc6\u94a5\u3010signkey\u3011\uff01");
        }
    }
}

