/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderRefundTransAtomReqBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.bo.busi.req.WXRefundBusiReqBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.bo.busi.rsp.WXRefundBusiRspBo;
import com.tydic.payment.pay.busi.api.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.api.WXPayApiBusiService;
import com.tydic.payment.pay.busi.api.WXRefundBusiService;
import com.tydic.payment.pay.common.util.ParseAbilityResponse;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.wx.req.bo.WXApiRefundReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiRefundRspBO;
import com.tydic.payment.pay.wx.util.Signature;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="wXRefundBusiService")
public class WXRefundBusiServiceImpl
implements WXRefundBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXRefundBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;
    @Resource
    FileClient fileClient;
    private static final String PAY_CENTER_BASE_PATH = "payCenter/";

    public WXRefundBusiRspBo dealWxRefund(WXRefundBusiReqBo req) throws Exception {
        log.info("\u8fdb\u5165\u5fae\u4fe1\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1:" + req);
        WXRefundBusiRspBo rsp = new WXRefundBusiRspBo();
        this.checkInputParas(req);
        HashMap<String, Object> paramMap = new HashMap();
        try {
            paramMap = this.getParamMap(String.valueOf(req.getMerchantId()), req.getPayMethod());
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName(e.getMessage());
            rsp.setMsg(e.getMessage());
            return rsp;
        }
        try {
            WXApiRefundReqBO refundReqData = this.createRefundReq(paramMap, req);
            if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.refundByAbility(refundReqData);
            } else if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
                String cert_path = (String)paramMap.get("certname");
                File downLoadFile = this.fileClient.downloadToFile(PAY_CENTER_BASE_PATH + cert_path);
                cert_path = downLoadFile.getAbsolutePath();
                String cert_password = (String)paramMap.get("certpassword");
                rsp = this.refundByWxApi(refundReqData, cert_path, cert_password);
            }
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            rsp.setMsg("\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e);
        }
        String tradeTime = new SimpleDateFormat("yyyyMMddHHmmss").format(this.queryDBDateBusiService.getDBDate());
        this.updateOrder(req, tradeTime, rsp);
        rsp.setTradeTime(tradeTime);
        rsp.setRefundId(String.valueOf(req.getRefundId()));
        rsp.setPayMethod(req.getPayMethod());
        return rsp;
    }

    private WXApiRefundReqBO createRefundReq(Map<String, Object> paramMap, WXRefundBusiReqBo req) throws Exception {
        String appid = null;
        appid = "15".equals(req.getPayMethod()) ? (String)paramMap.get("applets_appid") : ("12".equals(req.getPayMethod()) ? (String)paramMap.get("native_appid") : (String)paramMap.get("appid"));
        String mchid = (String)paramMap.get("mchid");
        String key = (String)paramMap.get("signkey");
        String sub_mch_id = (String)paramMap.get("subMchId");
        int totalFee = req.getTotalFee().intValue();
        int refundFee = req.getRefundFee().intValue();
        WXApiRefundReqBO refundReqData = new WXApiRefundReqBO().setAppid(appid).setMch_id(mchid).setTransaction_id(req.getTransactionId()).setOut_trade_no(req.getOutTradeNo()).setOut_refund_no(req.getOutRefundNo()).setTotal_fee(totalFee).setRefund_fee(refundFee).setSub_mch_id(sub_mch_id).setNonce_str("").setKey(key);
        return refundReqData;
    }

    private void updateOrder(WXRefundBusiReqBo req, String tradeTime, WXRefundBusiRspBo rsp) throws Exception {
        PorderPo orderNew = new PorderPo();
        orderNew.setOrderId(req.getRefundId());
        orderNew.setTradeTime(tradeTime);
        PorderRefundTransAtomReqBo porderRefundTransAtomReqBo = new PorderRefundTransAtomReqBo();
        porderRefundTransAtomReqBo.setRefundOrderId(req.getOutRefundNo());
        porderRefundTransAtomReqBo.setOrderId(req.getRefundId());
        porderRefundTransAtomReqBo.setTradeTime(tradeTime);
        porderRefundTransAtomReqBo.setPayMsg(rsp.getMsg());
        if ("0000".equals(rsp.getRspCode()) && "SUCCESS".equals(rsp.getRefundStatus())) {
            orderNew.setOrderStatus("B10");
            porderRefundTransAtomReqBo.setOrderStatus("B10");
            porderRefundTransAtomReqBo.setPayNotifyTransId(rsp.getRefundId());
        } else {
            orderNew.setOrderStatus("B20");
            porderRefundTransAtomReqBo.setOrderStatus("B20");
        }
        this.payOrderAtomService.update(orderNew);
        int count = this.porderRefundTransAtomService.updateOrderRefundTransByRefundOrderId(porderRefundTransAtomReqBo);
        if (count == 0) {
            log.info("\u66f4\u65b0\u9000\u6b3e\u6570\u636e\u5931\u8d25");
        }
    }

    private void checkInputParas(WXRefundBusiReqBo req) {
        if (StringUtils.isEmpty((Object)req)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOutTradeNo()) && StringUtils.isEmpty((Object)req.getTransactionId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5fae\u4fe1\u8ba2\u5355\u53f7\u3010transactionId\u3011\u548c\u5546\u6237\u8ba2\u5355\u53f7\u3010outTradeNo\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u4e24\u8005\u5fc5\u9009\u5176\u4e00\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOutRefundNo())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5546\u6237\u9000\u6b3e\u5355\u53f7\u3010outRefundNo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u603b\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getRefundFee())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5fae\u4fe1\u9000\u6b3e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\u3010refundFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private WXRefundBusiRspBo refundByWxApi(WXApiRefundReqBO refundReqData, String certPath, String certPassword) throws Exception {
        WXApiRefundRspBO refundResData = this.wXPayApiBusiService.refund(refundReqData, certPath, certPassword);
        WXRefundBusiRspBo rsp = new WXRefundBusiRspBo();
        if (!"SUCCESS".equals(refundResData.getReturn_code())) {
            String return_msg = refundResData.getReturn_msg();
            rsp.setRspCode("0000");
            rsp.setRefundStatus("FAIL");
            rsp.setRspName(return_msg);
            rsp.setMsg(refundResData.getErr_code_des());
            return rsp;
        }
        if (!"SUCCESS".equals(refundResData.getResult_code()) || !StringUtils.isEmpty((Object)refundResData.getErr_code())) {
            String err_code_des = refundResData.getErr_code_des();
            rsp.setRspCode("8888");
            rsp.setRefundStatus("FAIL");
            rsp.setRspName(err_code_des);
            rsp.setMsg(err_code_des);
            return rsp;
        }
        rsp.setRspCode("0000");
        rsp.setRspName("\u6210\u529f");
        rsp.setRefundId(refundResData.getRefund_id());
        rsp.setRefundStatus("SUCCESS");
        return rsp;
    }

    private WXRefundBusiRspBo refundByAbility(WXApiRefundReqBO refundReqData) throws Exception {
        WXRefundBusiRspBo rsp = new WXRefundBusiRspBo();
        JSONObject body = new JSONObject();
        JSONObject bodyInfo = new JSONObject();
        bodyInfo.put("APP_ID", (Object)refundReqData.getAppid());
        bodyInfo.put("MCH_ID", (Object)refundReqData.getMch_id());
        bodyInfo.put("SUB_MCH_ID", (Object)refundReqData.getSub_mch_id());
        bodyInfo.put("NONCE_STR", (Object)refundReqData.getNonce_str());
        bodyInfo.put("SIGN", (Object)refundReqData.getSign());
        bodyInfo.put("TRANSACTION_ID", (Object)refundReqData.getTransaction_id());
        bodyInfo.put("OUT_TRADE_NO", (Object)refundReqData.getOut_trade_no());
        bodyInfo.put("OUT_REFUND_NO", (Object)refundReqData.getOut_refund_no());
        bodyInfo.put("TOTAL_FEE", (Object)String.valueOf(refundReqData.getTotal_fee()));
        bodyInfo.put("REFUND_FEE", (Object)String.valueOf(refundReqData.getRefund_fee()));
        body.put("REFUND_REQ", (Object)bodyInfo);
        String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityWxRefundUrl().replace("MCH_ID", refundReqData.getMch_id()), body);
        ParseInfo parseInfo = ParseAbilityResponse.getRspBodyInfo((String)resultStr, (String)"REFUND_RSP");
        if (!"0000".equals(parseInfo.getRsp_code())) {
            rsp.setRspCode(parseInfo.getRsp_code());
            rsp.setRspName(parseInfo.getRsp_msg());
            return rsp;
        }
        if ("0000".equals(rsp.getRspCode()) && !Signature.checkIsSignValidFromAbilityResponse((JSONObject)parseInfo.getJsonInfo(), (String)refundReqData.getKey())) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u6821\u9a8c\u67e5\u8be2\u8ba2\u5355api\u8fd4\u56de\u7b7e\u540d\u5931\u8d25");
            rsp.setMsg("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25");
            return rsp;
        }
        rsp.setRspCode(parseInfo.getRsp_code());
        rsp.setRspName(parseInfo.getRsp_msg());
        rsp.setRefundId(parseInfo.getJsonInfo().getString("REFUND_ID"));
        rsp.setRefundStatus("SUCCESS");
        return rsp;
    }

    private Map<String, Object> getParamMap(String merchantId, String payMethod) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(merchantId);
        paraReq.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u6b3e\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchantId + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

