/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.AbilityToPayPlatformService;
import com.tydic.payment.pay.bo.busi.req.WXReverseOrderBusiReqBO;
import com.tydic.payment.pay.bo.busi.rsp.WXReverseOrderBusiRspBO;
import com.tydic.payment.pay.busi.api.WXPayApiBusiService;
import com.tydic.payment.pay.busi.api.WXReverseOrderBusiService;
import com.tydic.payment.pay.common.util.ParseAbilityResponse;
import com.tydic.payment.pay.common.util.ParseInfo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.wx.req.bo.WXApiReverseReqBO;
import com.tydic.payment.pay.wx.rsp.bo.WXApiReverseRspBO;
import com.tydic.payment.pay.wx.util.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="wXReverseOrderBusiService")
public class WXReverseOrderBusiServiceImpl
implements WXReverseOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(WXReverseOrderBusiServiceImpl.class);
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private AbilityToPayPlatformService abilityToPayPlatformService;
    @Autowired
    private WXPayApiBusiService wXPayApiBusiService;

    public WXReverseOrderBusiRspBO dealReverseOrder(WXReverseOrderBusiReqBO req) throws Exception {
        log.info("\u8fdb\u5165\u5fae\u4fe1\u64a4\u9500\u8ba2\u5355\u4e1a\u52a1\u670d\u52a1\uff1a" + req);
        WXReverseOrderBusiRspBO rsp = new WXReverseOrderBusiRspBO();
        try {
            this.checkInputParas(req);
            WXApiReverseReqBO reverseReqData = new WXApiReverseReqBO().setAppid(req.getAppId()).setMch_id(req.getMchId()).setTransaction_id(req.getTransactionId()).setOut_trade_no(req.getOutTradeNo()).setSub_mch_id(req.getSubMchId()).setNonce_str("").setKey(req.getKey());
            if ("1".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.reverseOrderByAbility(reverseReqData);
            } else if ("0".equals(this.payPropertiesVo.getAbilitySwitch())) {
                rsp = this.reverseOrderByWxApi(reverseReqData, req.getCertPath(), req.getCertPassword());
            }
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u64a4\u5355\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void checkInputParas(WXReverseOrderBusiReqBO req) {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getAppId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u3010appId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getMchId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u3010mchId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getKey())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u3010key\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTransactionId()) && StringUtils.isEmpty((Object)req.getOutTradeNo())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u3010outTradeNo\u3001transactionId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private WXReverseOrderBusiRspBO reverseOrderByWxApi(WXApiReverseReqBO reverseReqData, String certPath, String certPassword) throws Exception {
        if (StringUtils.isEmpty((Object)certPath)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u3010certPath\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)certPassword)) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u64a4\u5355\u670d\u52a1\u3010certPassword\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WXReverseOrderBusiRspBO rsp = new WXReverseOrderBusiRspBO();
        WXApiReverseRspBO reverseResData = this.wXPayApiBusiService.reverse(reverseReqData, certPath, certPassword);
        if (!"SUCCESS".equals(reverseResData.getReturn_code())) {
            rsp.setRspCode("8888");
            rsp.setRspName(reverseResData.getReturn_msg());
            return rsp;
        }
        if (!"SUCCESS".equals(reverseResData.getResult_code()) || !StringUtils.isEmpty((Object)reverseResData.getErr_code())) {
            rsp.setRspCode("8888");
            rsp.setRspName(reverseResData.getErr_code_des());
            return rsp;
        }
        rsp.setRspCode("0000");
        rsp.setRspName("\u64a4\u5355\u6210\u529f");
        return rsp;
    }

    private WXReverseOrderBusiRspBO reverseOrderByAbility(WXApiReverseReqBO reverseReqData) throws Exception {
        WXReverseOrderBusiRspBO rsp = new WXReverseOrderBusiRspBO();
        JSONObject body = new JSONObject();
        JSONObject bodyInfo = new JSONObject();
        bodyInfo.put("APP_ID", (Object)reverseReqData.getAppid());
        bodyInfo.put("MCH_ID", (Object)reverseReqData.getMch_id());
        bodyInfo.put("SUB_MCH_ID", (Object)reverseReqData.getSub_mch_id());
        bodyInfo.put("NONCE_STR", (Object)reverseReqData.getNonce_str());
        bodyInfo.put("SIGN", (Object)reverseReqData.getSign());
        bodyInfo.put("OUT_TRADE_NO", (Object)reverseReqData.getOut_trade_no());
        bodyInfo.put("TRANSACTION_ID", (Object)reverseReqData.getTransaction_id());
        body.put("REVERSE_REQ", (Object)bodyInfo);
        String resultStr = this.abilityToPayPlatformService.abilityToPayPlatform(this.payPropertiesVo.getAbilityWxReverseUrl().replace("MCH_ID", reverseReqData.getMch_id()), body);
        ParseInfo parseInfo = ParseAbilityResponse.getRspBodyInfo((String)resultStr, (String)"REVERSE_RSP");
        if (!"0000".equals(parseInfo.getRsp_code())) {
            rsp.setRspCode(parseInfo.getRsp_code());
            rsp.setRspName(parseInfo.getRsp_msg());
            return rsp;
        }
        if (!Signature.checkIsSignValidFromAbilityResponse((JSONObject)parseInfo.getJsonInfo(), (String)reverseReqData.getKey())) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u64a4\u5355\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            return rsp;
        }
        rsp.setRspCode("0000");
        rsp.setRspName("\u64a4\u5355\u6210\u529f");
        return rsp;
    }
}

