/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.bo.busi.req.CreateFkMqReqBo;
import com.tydic.payment.pay.bo.busi.req.CreatePayOrderReqBo;
import com.tydic.payment.pay.bo.busi.req.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierReqBo;
import com.tydic.payment.pay.bo.busi.rsp.CreateFkMqRspBo;
import com.tydic.payment.pay.bo.busi.rsp.CreatePayOrderRspBo;
import com.tydic.payment.pay.bo.busi.rsp.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.bo.busi.rsp.PayOrderRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierRspBo;
import com.tydic.payment.pay.bo.comb.req.CombCashierPayUrlReqBo;
import com.tydic.payment.pay.bo.comb.rsp.CombCashierPayUrlRspBo;
import com.tydic.payment.pay.busi.api.CreateFkMqBusiService;
import com.tydic.payment.pay.busi.api.CreatePayOrderService;
import com.tydic.payment.pay.busi.api.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.api.PayOrderBusiService;
import com.tydic.payment.pay.busi.api.QueryCashierService;
import com.tydic.payment.pay.comb.api.CashierPayUrlCombService;
import com.tydic.payment.pay.common.util.MapUtils;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.common.util.OrderCiphertext;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="cashierPayUrlCombService")
public class CashierPayUrlCombServiceImpl
implements CashierPayUrlCombService {
    private static final Logger log = LoggerFactory.getLogger(CashierPayUrlCombServiceImpl.class);
    @Autowired
    private CreatePayOrderService createPayOrderService;
    @Autowired
    private QueryCashierService queryCashierService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private CreateFkMqBusiService createFkMqBusiService;
    @Autowired
    private PayOrderBusiService payOrderBusiService;

    public CombCashierPayUrlRspBo pmcCashierPayUrlComb(CombCashierPayUrlReqBo combCashierPayUrlReqBo) {
        log.info("\u4e0b\u5355\u8fd4\u56deurl\u63a5\u53e3comb\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)combCashierPayUrlReqBo));
        CombCashierPayUrlRspBo combCashierPayUrlRspBo = new CombCashierPayUrlRspBo();
        if (combCashierPayUrlReqBo == null) {
            log.info("\u4e0b\u5355\u5f02\u5e38\uff0c \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            combCashierPayUrlRspBo.setRspCode("8888");
            combCashierPayUrlRspBo.setRspName("\u4e0b\u5355\u5f02\u5e38");
            return combCashierPayUrlRspBo;
        }
        try {
            OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
            orderQueryConstructionReqBo.setBusiId(Long.valueOf(Long.parseLong(combCashierPayUrlReqBo.getBusiId())));
            orderQueryConstructionReqBo.setOutOrderId(combCashierPayUrlReqBo.getOutOrderId());
            OrderQueryConstructionRspBo rsp = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
            if ("0000".equals(rsp.getRspCode())) {
                PayOrderRspBo payOrderRspBo = this.payOrderBusiService.selectOrderByOrderId(rsp.getOrderId());
                if ("8888".equals(payOrderRspBo.getRspCode())) {
                    // empty if block
                }
                if ("A10".equals(payOrderRspBo.getOrderStatus())) {
                    String errorMsg = "\u5916\u90e8\u8ba2\u5355\u53f7 \u3010" + combCashierPayUrlReqBo.getOutOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355";
                    combCashierPayUrlRspBo.setRspCode("8888");
                    combCashierPayUrlRspBo.setRspName("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38 " + errorMsg);
                    return combCashierPayUrlRspBo;
                }
                if (!this.similarity(combCashierPayUrlReqBo, payOrderRspBo)) {
                    String errorMsg = "\u5916\u90e8\u8ba2\u5355\u53f7 \u3010" + combCashierPayUrlReqBo.getOutOrderId() + "\u3011\u5df2\u7ecf\u4e0b\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355";
                    combCashierPayUrlRspBo.setRspCode("8888");
                    combCashierPayUrlRspBo.setRspName("\u521b\u5efa\u8ba2\u5355\u5f02\u5e38 " + errorMsg);
                    return combCashierPayUrlRspBo;
                }
                QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
                queryCashierReqBo.setBusiId(String.valueOf(payOrderRspBo.getBusiId()));
                queryCashierReqBo.setReqWay(payOrderRspBo.getReqWay());
                QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
                if (queryCashierRspBo == null) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u5546\u6237\u6a21\u677f");
                }
                if (!"0000".equals(queryCashierRspBo.getRspCode())) {
                    log.info(queryCashierRspBo.getRspName());
                    combCashierPayUrlRspBo.setRspCode(queryCashierRspBo.getRspCode());
                    combCashierPayUrlRspBo.setRspName(queryCashierRspBo.getRspName());
                    return combCashierPayUrlRspBo;
                }
                PayOrderRspBo rspBo = this.payOrderBusiService.dealDelay(payOrderRspBo.getOrderId());
                if (!"0000".equals(rspBo.getRspCode())) {
                    log.info("\u5ef6\u957f\u8ba2\u5355\u65f6\u95f4\u5931\u8d25\uff01");
                    combCashierPayUrlRspBo.setRspCode("8888");
                    combCashierPayUrlRspBo.setRspName("\u5ef6\u957f\u8ba2\u5355\u65f6\u95f4\u5931\u8d25");
                    return combCashierPayUrlRspBo;
                }
                combCashierPayUrlRspBo.setOutOrderId(payOrderRspBo.getOutOrderId());
                combCashierPayUrlRspBo.setMerchantId(String.valueOf(payOrderRspBo.getMerchantId()));
                combCashierPayUrlRspBo.setRemark(payOrderRspBo.getOutRemark());
                String cashierTemplateUrl = queryCashierRspBo.getCashierTemplateUrl() + "?orderId=" + OrderCiphertext.encode((byte[])String.valueOf(payOrderRspBo.getOrderId()).getBytes());
                combCashierPayUrlRspBo.setUrl(cashierTemplateUrl);
                combCashierPayUrlRspBo.setRspCode("0000");
                combCashierPayUrlRspBo.setRspName("\u4e0b\u5355\u6210\u529f");
                return combCashierPayUrlRspBo;
            }
            Map params = MapUtils.objectToMap((Object)combCashierPayUrlReqBo);
            String ip = combCashierPayUrlReqBo.getIp();
            CreatePayOrderReqBo createPorderReqBo = new CreatePayOrderReqBo();
            createPorderReqBo.setBusiId(combCashierPayUrlReqBo.getBusiId());
            createPorderReqBo.setBusiCode(combCashierPayUrlReqBo.getBusiCode());
            createPorderReqBo.setIp(ip == null ? "127.0.0.1" : ip);
            createPorderReqBo.setContentMap(params);
            CreatePayOrderRspBo createPorderRspBo = this.createPayOrderService.createPorder(createPorderReqBo);
            if (createPorderRspBo == null) {
                throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u8ba2\u5355\u5f02\u5e38");
            }
            if (!"0000".equals(createPorderRspBo.getRspCode())) {
                log.info(createPorderRspBo.getRspName());
                combCashierPayUrlRspBo.setRspCode(createPorderRspBo.getRspCode());
                combCashierPayUrlRspBo.setRspName(createPorderRspBo.getRspName());
                return combCashierPayUrlRspBo;
            }
            Long merchantId = createPorderRspBo.getMerchantId();
            QueryCashierReqBo queryCashierReqBo = new QueryCashierReqBo();
            queryCashierReqBo.setBusiId(createPorderRspBo.getBusiId());
            queryCashierReqBo.setReqWay(createPorderRspBo.getReqWay());
            QueryCashierRspBo queryCashierRspBo = this.queryCashierService.queryCashier(queryCashierReqBo);
            if (queryCashierRspBo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u672a\u67e5\u8be2\u5230\u5546\u6237\u6a21\u677f");
            }
            if (!"0000".equals(queryCashierRspBo.getRspCode())) {
                log.info(queryCashierRspBo.getRspName());
                combCashierPayUrlRspBo.setRspCode(queryCashierRspBo.getRspCode());
                combCashierPayUrlRspBo.setRspName(queryCashierRspBo.getRspName());
                return combCashierPayUrlRspBo;
            }
            combCashierPayUrlRspBo.setOutOrderId(createPorderRspBo.getOutOrderId());
            combCashierPayUrlRspBo.setMerchantId(String.valueOf(createPorderRspBo.getMerchantId()));
            combCashierPayUrlRspBo.setRemark(createPorderRspBo.getOutRemark());
            String cashierTemplateUrl = queryCashierRspBo.getCashierTemplateUrl() + "?orderId=" + OrderCiphertext.encode((byte[])String.valueOf(createPorderRspBo.getOrderId()).getBytes());
            combCashierPayUrlRspBo.setUrl(cashierTemplateUrl);
            combCashierPayUrlRspBo.setRspCode("0000");
            combCashierPayUrlRspBo.setRspName("\u4e0b\u5355\u6210\u529f");
            CreateFkMqReqBo createFkMqReqBo = new CreateFkMqReqBo();
            createFkMqReqBo.setBusiId(Long.valueOf(Long.parseLong(createPorderRspBo.getBusiId())));
            createFkMqReqBo.setOrderId(Long.valueOf(Long.parseLong(createPorderRspBo.getOrderId())));
            createFkMqReqBo.setOutOrderId(createPorderRspBo.getOutOrderId());
            CreateFkMqRspBo createFkMqRspBo = this.createFkMqBusiService.createFk(createFkMqReqBo);
            if ("0000".equals(createFkMqRspBo.getRspCode())) {
                log.info("\u5206\u5e93\u5efa\u5173\u8054 \u8fdb\u5165MQ\u961f\u5217");
            }
            return combCashierPayUrlRspBo;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            log.info("\u80fd\u529b\u63d0\u4f9b\u6355\u83b7\u5230\u5f02\u5e38" + e.getMessage());
            combCashierPayUrlRspBo.setRspCode("8888");
            combCashierPayUrlRspBo.setRspName("\u4e0b\u5355\u5f02\u5e38");
            return combCashierPayUrlRspBo;
        }
    }

    public boolean similarity(CombCashierPayUrlReqBo req, PayOrderRspBo payOrderRspBo) {
        if (!req.getBusiId().equals(String.valueOf(payOrderRspBo.getBusiId()))) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)req.getChannelId()) && !req.getChannelId().equals(payOrderRspBo.getChannelId())) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)req.getCity()) && !req.getCity().equals(payOrderRspBo.getCityId())) {
            return false;
        }
        if (!req.getCreateOperId().equals(payOrderRspBo.getCreateOperId())) {
            return false;
        }
        if (!req.getDetailName().equals(payOrderRspBo.getDetailName())) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)req.getDistrict()) && !req.getDistrict().equals(payOrderRspBo.getDistrictId())) {
            return false;
        }
        if (!StringUtils.isEmpty((Object)req.getProvince()) && !req.getProvince().equals(payOrderRspBo.getProvinceId())) {
            return false;
        }
        if (!req.getNotifyUrl().equals(payOrderRspBo.getNotifyUrl())) {
            return false;
        }
        try {
            if (MoneyUtils.haoToFen((Long)payOrderRspBo.getTotalFee()).compareTo(new BigDecimal(req.getTotalFee())) != 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!req.getRedirectUrl().equals(payOrderRspBo.getRedirectUrl())) {
            return false;
        }
        return req.getReqWay().equals(payOrderRspBo.getReqWay());
    }
}

