/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.req.bo.PorderPayTransAtomReqBo;
import com.tydic.payment.pay.atom.rsp.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.bo.busi.req.AliPayCloseBusiServiceReqBO;
import com.tydic.payment.pay.bo.busi.req.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.bo.busi.req.WXCloseOrderBusiReqBO;
import com.tydic.payment.pay.bo.busi.rsp.AliPayCloseBusiServiceRspBO;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.bo.busi.rsp.WXCloseOrderBusiRspBO;
import com.tydic.payment.pay.bo.comb.req.CloseOrderCombReqBO;
import com.tydic.payment.pay.bo.comb.rsp.CloseOrderCombRspBO;
import com.tydic.payment.pay.busi.api.AliPayCloseBusiService;
import com.tydic.payment.pay.busi.api.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.api.WXCloseOrderBusiService;
import com.tydic.payment.pay.comb.api.CloseOrderCombService;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="closeOrderCombService")
public class CloseOrderCombServiceImpl
implements CloseOrderCombService {
    private static final Logger logger = LoggerFactory.getLogger(CloseOrderCombServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    private WXCloseOrderBusiService wXCloseOrderBusiService;
    @Autowired
    private AliPayCloseBusiService aliPayCloseBusiService;

    public CloseOrderCombRspBO dealCloseOrder(CloseOrderCombReqBO req) {
        logger.info("\u8fdb\u5165\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\uff1a" + req);
        CloseOrderCombRspBO rsp = new CloseOrderCombRspBO();
        this.checkInputParas(req);
        try {
            PorderPayTransAtomReqBo orderPayTransAtomReq = new PorderPayTransAtomReqBo();
            orderPayTransAtomReq.setPayOrderId(req.getPayOrderId());
            PorderPayTransAtomRspBo orderPayTransAtomRsp = this.porderPayTransAtomService.queryOrderPayTransByPayOrderId(orderPayTransAtomReq);
            if (orderPayTransAtomRsp == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u3010payOrderId=" + req.getPayOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u8bf7\u6c42\u4fe1\u606f\uff01");
                return rsp;
            }
            String orderId = String.valueOf(orderPayTransAtomRsp.getOrderId());
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(orderPayTransAtomRsp.getOrderId());
            if (orderInfo == null) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u3010orderId=" + orderId + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
                return rsp;
            }
            String merchant_id = String.valueOf(orderInfo.getMerchantId());
            String payMethod = String.valueOf(orderPayTransAtomRsp.getPayMethod());
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(merchant_id);
            paraReq.setPayMethod(payMethod);
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            }
            if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
            }
            Map<String, Object> paramMap = this.getParamMap(paraInfo);
            if ("11".equals(payMethod) || "12".equals(payMethod) || "13".equals(payMethod)) {
                WXCloseOrderBusiReqBO wXCloseOrderReq = new WXCloseOrderBusiReqBO();
                wXCloseOrderReq.setPayOrderId(req.getPayOrderId());
                wXCloseOrderReq.setOrderId(orderId);
                wXCloseOrderReq.setParamMap(paramMap);
                WXCloseOrderBusiRspBO wXCloseOrderRsp = this.wXCloseOrderBusiService.dealWXCloseOrder(wXCloseOrderReq);
                BeanUtils.copyProperties((Object)wXCloseOrderRsp, (Object)rsp);
            } else if ("21".equals(payMethod) || "22".equals(payMethod) || "23".equals(payMethod) || "24".equals(payMethod)) {
                AliPayCloseBusiServiceReqBO aliPayCloseBusiServiceReq = new AliPayCloseBusiServiceReqBO();
                aliPayCloseBusiServiceReq.setPayOrderId(req.getPayOrderId());
                aliPayCloseBusiServiceReq.setParamMap(paramMap);
                AliPayCloseBusiServiceRspBO aliPayCloseBusiServiceRsp = this.aliPayCloseBusiService.dealAliPayClose(aliPayCloseBusiServiceReq);
                BeanUtils.copyProperties((Object)aliPayCloseBusiServiceRsp, (Object)rsp);
            }
        }
        catch (Exception e) {
            rsp.setRspCode("8888");
            rsp.setRspName("\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
            return rsp;
        }
        return rsp;
    }

    private void checkInputParas(CloseOrderCombReqBO req) {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5173\u95ed\u8ba2\u5355\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u3010payOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

