/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.bo.busi.req.CreatePayOrderReqBo;
import com.tydic.payment.pay.bo.busi.req.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.bo.busi.rsp.CreatePayOrderRspBo;
import com.tydic.payment.pay.bo.busi.rsp.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.bo.comb.req.PrepareOrderCombServiceReqBo;
import com.tydic.payment.pay.bo.comb.rsp.PrepareOrderCombServiceRspBo;
import com.tydic.payment.pay.busi.api.CreateFkMqBusiService;
import com.tydic.payment.pay.busi.api.CreatePayOrderService;
import com.tydic.payment.pay.busi.api.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.comb.api.PrepareOrderCombService;
import com.tydic.payment.pay.common.util.MapUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="prepareOrderCombService")
public class PrepareOrderCombServiceImpl
implements PrepareOrderCombService {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareOrderCombServiceImpl.class);
    private static final String SERVICE_NAME = "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1";
    @Autowired
    private CreatePayOrderService createPayOrderService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private CreateFkMqBusiService createFkMqBusiService;

    public PrepareOrderCombServiceRspBo dealOrder(PrepareOrderCombServiceReqBo reqBo) {
        LoggerProUtils.debug(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        PrepareOrderCombServiceRspBo retBo = new PrepareOrderCombServiceRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getOrderType())) {
            reqBo.setOrderType("01");
        }
        String outOrderId = reqBo.getOutOrderId();
        Long busiId = Long.parseLong(reqBo.getBusiId());
        OrderQueryConstructionReqBo orderQueryConstructionReqBo = new OrderQueryConstructionReqBo();
        orderQueryConstructionReqBo.setBusiId(busiId);
        orderQueryConstructionReqBo.setOutOrderId(outOrderId);
        OrderQueryConstructionRspBo rsp = this.orderQueryConstructionBusiService.queryConstruction(orderQueryConstructionReqBo);
        if ("0000".equals(rsp.getRspCode())) {
            LoggerProUtils.error(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1\uff1a\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355\uff01(" + outOrderId + ")");
            retBo.setRspName("\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1\uff1a\u91cd\u590d\u7684\u5916\u90e8\u8ba2\u5355\uff01(" + outOrderId + ")");
            retBo.setRspCode("8888");
            return retBo;
        }
        Map params = null;
        try {
            params = MapUtils.objectToMap((Object)reqBo);
        }
        catch (IllegalAccessException e) {
            LoggerProUtils.error(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5f02\u5e38:" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        String ip = reqBo.getIp();
        CreatePayOrderReqBo createPorderReqBo = new CreatePayOrderReqBo();
        createPorderReqBo.setBusiId(reqBo.getBusiId());
        createPorderReqBo.setBusiCode(reqBo.getBusiCode());
        createPorderReqBo.setIp(ip == null ? "127.0.0.1" : ip);
        createPorderReqBo.setContentMap(params);
        params.put("reqWay", "1");
        CreatePayOrderRspBo createPorderRspBo = this.createPayOrderService.createPorder(createPorderReqBo);
        if (createPorderRspBo == null) {
            LoggerProUtils.error(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5f02\u5e38: \u8c03\u7528\u4e0b\u5355\u670d\u52a1(createPayOrderService.createPorder)\u8fd4\u56de\u5bf9\u8c61\u4e3anull");
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5f02\u5e38: \u8c03\u7528\u4e0b\u5355\u670d\u52a1(createPayOrderService.createPorder)\u8fd4\u56de\u5bf9\u8c61\u4e3anull");
        }
        if (!"0000".equals(createPorderRspBo.getRspCode())) {
            LoggerProUtils.error(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5f02\u5e38: " + createPorderRspBo.getRspName());
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5f02\u5e38: " + createPorderRspBo.getRspName());
        }
        OrderQueryConstructionReqBo insertBo = new OrderQueryConstructionReqBo();
        insertBo.setBusiId(busiId);
        insertBo.setOrderId(Long.valueOf(Long.parseLong(createPorderRspBo.getOrderId())));
        insertBo.setOutOrderId(outOrderId);
        OrderQueryConstructionRspBo orderQueryConstructionRspBo = this.orderQueryConstructionBusiService.insertConstruction(insertBo);
        if ("0000".equals(orderQueryConstructionRspBo.getRspCode())) {
            LoggerProUtils.debug(LOG, "\u9884\u8ba2\u5355\u4e0b\u5355comb\u670d\u52a1 -> \u5206\u5e93\u5efa\u5173\u8054\u6210\u529f");
            retBo.setRspCode("0000");
            retBo.setRspName("\u4e0b\u5355\u6210\u529f");
            retBo.setMerchantId(reqBo.getMerchantId());
            retBo.setOutOrderId(reqBo.getOutOrderId());
            retBo.setRemark(reqBo.getRemark());
        } else {
            retBo.setRspCode("8888");
            retBo.setRspName("\u4e0b\u5355\u5931\u8d25\uff0c\u5206\u5e93\u952e\u5173\u8054\u5931\u8d25");
        }
        return retBo;
    }
}

