/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.comb.impl;

import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.bo.busi.req.AliAppPayReqBo;
import com.tydic.payment.pay.bo.busi.req.AliH5PayBusiReqBO;
import com.tydic.payment.pay.bo.busi.req.AliQrCodePayReqBO;
import com.tydic.payment.pay.bo.busi.req.AliScanPayReqBO;
import com.tydic.payment.pay.bo.busi.req.AliWebPayReqBo;
import com.tydic.payment.pay.bo.busi.req.CallBackNoticeReqBo;
import com.tydic.payment.pay.bo.busi.req.CashPayBusiReqBo;
import com.tydic.payment.pay.bo.busi.req.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.bo.busi.req.WXAppPayBusiReqBO;
import com.tydic.payment.pay.bo.busi.req.WXH5PayBusiReqBO;
import com.tydic.payment.pay.bo.busi.req.WXMicroPayBusiReqBO;
import com.tydic.payment.pay.bo.busi.req.WXQrCodePayBusiReqBO;
import com.tydic.payment.pay.bo.busi.rsp.AliAppPayRspBo;
import com.tydic.payment.pay.bo.busi.rsp.AliH5PayBusiRspBO;
import com.tydic.payment.pay.bo.busi.rsp.AliScanPayRspBO;
import com.tydic.payment.pay.bo.busi.rsp.AliWebPayRspBo;
import com.tydic.payment.pay.bo.busi.rsp.AlipayQrCodeRspBo;
import com.tydic.payment.pay.bo.busi.rsp.CallBackNoticeRspBo;
import com.tydic.payment.pay.bo.busi.rsp.CashPayBusiRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.bo.busi.rsp.WXAppPayBusiRspBO;
import com.tydic.payment.pay.bo.busi.rsp.WXH5PayBusiRspBO;
import com.tydic.payment.pay.bo.busi.rsp.WXMicroPayBusiRspBO;
import com.tydic.payment.pay.bo.busi.rsp.WXQrCodePayBusiRspBO;
import com.tydic.payment.pay.bo.comb.req.UniPayCombReqBO;
import com.tydic.payment.pay.bo.comb.rsp.UniPayCombRspBO;
import com.tydic.payment.pay.busi.api.AliAppPayBusiService;
import com.tydic.payment.pay.busi.api.AliH5PayBusiService;
import com.tydic.payment.pay.busi.api.AliQrCodePayBusiService;
import com.tydic.payment.pay.busi.api.AliScanPayBusiService;
import com.tydic.payment.pay.busi.api.AliWebPayBusiService;
import com.tydic.payment.pay.busi.api.CallBackNoticeService;
import com.tydic.payment.pay.busi.api.CashPayBusiService;
import com.tydic.payment.pay.busi.api.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.api.WXAppPayBusiService;
import com.tydic.payment.pay.busi.api.WXH5PayBusiService;
import com.tydic.payment.pay.busi.api.WXMicroPayBusiService;
import com.tydic.payment.pay.busi.api.WXQrCodePayBusiService;
import com.tydic.payment.pay.comb.api.UniPayCombService;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uniPayCombService")
public class UniPayCombServiceImpl
implements UniPayCombService {
    private static final Logger log = LoggerFactory.getLogger(UniPayCombServiceImpl.class);
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private WXQrCodePayBusiService wXQrCodePayBusiService;
    @Autowired
    private WXMicroPayBusiService wXMicroPayBusiService;
    @Autowired
    private CashPayBusiService cashPayBusiService;
    @Autowired
    private AliQrCodePayBusiService aliQrCodePayBusiService;
    @Autowired
    private AliScanPayBusiService aliScanPayBusiService;
    @Autowired
    private AliWebPayBusiService aliWebPayBusiService;
    @Autowired
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private WXH5PayBusiService wXH5PayBusiService;
    @Autowired
    private AliH5PayBusiService aliH5PayBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private WXAppPayBusiService wXAppPayBusiService;
    @Autowired
    private AliAppPayBusiService aliAppPayBusiService;

    public UniPayCombRspBO dealUniPay(UniPayCombReqBO req) throws Exception {
        log.info("\u7edf\u4e00\u7ec4\u5408\u652f\u4ed8\u5165\u53c2\u4e3a\uff1a" + req);
        UniPayCombRspBO rsp = new UniPayCombRspBO();
        this.checkInputParas(req);
        try {
            HashMap<String, String> params;
            PorderPo orderInfo = this.payOrderAtomService.queryPorderInfo(Long.valueOf(req.getOrderId()));
            if (orderInfo == null) {
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
            }
            if ("A10".equals(orderInfo.getOrderStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u8fc7");
                return rsp;
            }
            if ("B10".equals(orderInfo.getOrderStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u9000\u6b3e\uff0c\u8bf7\u4e0d\u8981\u518d\u652f\u4ed8\uff01");
                return rsp;
            }
            if ("B20".equals(orderInfo.getOrderStatus())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u8fc7\uff0c\u5e76\u5c1d\u8bd5\u8fc7\u9000\u6b3e\u4f46\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u518d\u652f\u4ed8\uff01");
                return rsp;
            }
            Long merchant_id = orderInfo.getMerchantId();
            if (StringUtils.isEmpty((Object)merchant_id)) {
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\u4e2d\u65e0\u5546\u6237\u53f7\uff01");
            }
            if (!StringUtils.isEmpty((Object)req.getAuthCode()) && StringUtils.isEmpty((Object)req.getPayMethod())) {
                String beginTwo = req.getAuthCode().substring(0, 2);
                String aliRegular = "^(2[5-9]|30)$";
                Pattern aliHumpPattern = Pattern.compile(aliRegular);
                Matcher aliMatcher = aliHumpPattern.matcher(beginTwo);
                String wxRegular = "^(1[0-5])$";
                Pattern wxHumpPattern = Pattern.compile(wxRegular);
                Matcher wxMatcher = wxHumpPattern.matcher(beginTwo);
                if (aliMatcher.find()) {
                    req.setPayMethod("20");
                } else if (wxMatcher.find()) {
                    req.setPayMethod("10");
                }
            }
            if ("30".equals(req.getPayMethod())) {
                CashPayBusiReqBo cashPayBusiReq = new CashPayBusiReqBo();
                cashPayBusiReq.setOrderId(req.getOrderId());
                cashPayBusiReq.setMerchantId(String.valueOf(merchant_id));
                cashPayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                CashPayBusiRspBo cashPayBusiRsp = this.cashPayBusiService.dealCashPay(cashPayBusiReq);
                BeanUtils.copyProperties((Object)cashPayBusiRsp, (Object)rsp);
                if ("0000".equals(rsp.getRspCode()) && "SUCCESS".equals(rsp.getPayStatus())) {
                    CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                    callBackNoticeReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                    CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                    if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                        log.info(req.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                    }
                }
                return rsp;
            }
            QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
            paraReq.setMerchantId(String.valueOf(merchant_id));
            paraReq.setPayMethod(req.getPayMethod());
            QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
            if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
            }
            if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
                throw new ResourceException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
            }
            Map<String, Object> paramMap = this.getParamMap(paraInfo);
            if ("10".equals(req.getPayMethod())) {
                WXMicroPayBusiReqBO wXMicroPayBusiReq = new WXMicroPayBusiReqBO();
                wXMicroPayBusiReq.setOrderId(req.getOrderId());
                wXMicroPayBusiReq.setMerchantId(String.valueOf(merchant_id));
                wXMicroPayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                wXMicroPayBusiReq.setParamMap(paramMap);
                wXMicroPayBusiReq.setAuthCode(req.getAuthCode());
                WXMicroPayBusiRspBO wXMicroPayBusiRsp = this.wXMicroPayBusiService.dealWXMicroPay(wXMicroPayBusiReq);
                BeanUtils.copyProperties((Object)wXMicroPayBusiRsp, (Object)rsp);
            } else if ("11".equals(req.getPayMethod())) {
                WXQrCodePayBusiReqBO wXQrCodePayBusiReq = new WXQrCodePayBusiReqBO();
                wXQrCodePayBusiReq.setOrderId(req.getOrderId());
                wXQrCodePayBusiReq.setMerchantId(String.valueOf(merchant_id));
                wXQrCodePayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                wXQrCodePayBusiReq.setParamMap(paramMap);
                WXQrCodePayBusiRspBO wXQrCodePayBusiRsp = this.wXQrCodePayBusiService.dealWxQrCodePay(wXQrCodePayBusiReq);
                BeanUtils.copyProperties((Object)wXQrCodePayBusiRsp, (Object)rsp);
            } else if ("20".equals(req.getPayMethod())) {
                AliScanPayReqBO aliScanPayReqBO = new AliScanPayReqBO();
                aliScanPayReqBO.setOrderId(req.getOrderId());
                aliScanPayReqBO.setMerchantId(String.valueOf(merchant_id));
                aliScanPayReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                aliScanPayReqBO.setParamMap(paramMap);
                aliScanPayReqBO.setAuthCode(req.getAuthCode());
                AliScanPayRspBO aliScanPayRspBO = this.aliScanPayBusiService.dealAliScanPay(aliScanPayReqBO);
                BeanUtils.copyProperties((Object)aliScanPayRspBO, (Object)rsp);
            } else if ("21".equals(req.getPayMethod())) {
                AliQrCodePayReqBO aliQrCodePayReqBO = new AliQrCodePayReqBO();
                aliQrCodePayReqBO.setMerchantId(String.valueOf(merchant_id));
                aliQrCodePayReqBO.setOrderId(req.getOrderId());
                aliQrCodePayReqBO.setParamMap(paramMap);
                aliQrCodePayReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                AlipayQrCodeRspBo alipayQrCodeRsp = this.aliQrCodePayBusiService.dealAliQrCodePay(aliQrCodePayReqBO);
                BeanUtils.copyProperties((Object)alipayQrCodeRsp, (Object)rsp);
            } else if ("24".equals(req.getPayMethod())) {
                AliWebPayReqBo aliWebPayReqBo = new AliWebPayReqBo();
                aliWebPayReqBo.setMerchantId(merchant_id);
                aliWebPayReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                aliWebPayReqBo.setParamMap(paramMap);
                aliWebPayReqBo.setTotalFee(new BigDecimal(req.getRealFee()));
                AliWebPayRspBo aliWebPayRspBo = this.aliWebPayBusiService.dealAliWebPay(aliWebPayReqBo);
                BeanUtils.copyProperties((Object)aliWebPayRspBo, (Object)rsp);
            } else if ("13".equals(req.getPayMethod())) {
                WXH5PayBusiReqBO wXH5PayBusiReqBO = new WXH5PayBusiReqBO();
                wXH5PayBusiReqBO.setOrderId(req.getOrderId());
                wXH5PayBusiReqBO.setMerchantId(String.valueOf(merchant_id));
                wXH5PayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                wXH5PayBusiReqBO.setParamMap(paramMap);
                WXH5PayBusiRspBO wXH5PayBusiRspBO = this.wXH5PayBusiService.dealWxH5Pay(wXH5PayBusiReqBO);
                BeanUtils.copyProperties((Object)wXH5PayBusiRspBO, (Object)rsp);
            } else if ("23".equals(req.getPayMethod())) {
                AliH5PayBusiReqBO aliH5PayBusiReq = new AliH5PayBusiReqBO();
                aliH5PayBusiReq.setOrderId(req.getOrderId());
                aliH5PayBusiReq.setMerchantId(String.valueOf(merchant_id));
                aliH5PayBusiReq.setTotalFee(new BigDecimal(req.getRealFee()));
                aliH5PayBusiReq.setParamMap(paramMap);
                AliH5PayBusiRspBO aliH5PayBusiRsp = this.aliH5PayBusiService.dealAliH5Pay(aliH5PayBusiReq);
                BeanUtils.copyProperties((Object)aliH5PayBusiRsp, (Object)rsp);
            } else if ("22".equals(req.getPayMethod())) {
                AliAppPayReqBo aliAppPayReqBo = new AliAppPayReqBo();
                aliAppPayReqBo.setMerchantId(String.valueOf(merchant_id));
                aliAppPayReqBo.setOrderId(req.getOrderId());
                aliAppPayReqBo.setTotalFee(new BigDecimal(req.getRealFee()));
                aliAppPayReqBo.setParamMap(paramMap);
                AliAppPayRspBo aliAppPayRspBo = this.aliAppPayBusiService.dealPay(aliAppPayReqBo);
                BeanUtils.copyProperties((Object)aliAppPayRspBo, (Object)rsp);
                if ("0000".equals(aliAppPayRspBo.getRspCode()) && "SUCCESS".equals(aliAppPayRspBo.getPayStatus())) {
                    params = new HashMap<String, String>();
                    params.put("body", aliAppPayRspBo.getBody());
                    params.put("redirectUrl", aliAppPayRspBo.getRedirectUrl());
                    rsp.setParams(params);
                }
            } else if ("12".equals(req.getPayMethod())) {
                WXAppPayBusiReqBO wXAppPayBusiReqBO = new WXAppPayBusiReqBO();
                wXAppPayBusiReqBO.setMerchantId(String.valueOf(merchant_id));
                wXAppPayBusiReqBO.setOrderId(req.getOrderId());
                wXAppPayBusiReqBO.setTotalFee(new BigDecimal(req.getRealFee()));
                wXAppPayBusiReqBO.setParamMap(paramMap);
                WXAppPayBusiRspBO wXAppPayBusiRspBO = this.wXAppPayBusiService.dealWXAppPay(wXAppPayBusiReqBO);
                BeanUtils.copyProperties((Object)wXAppPayBusiRspBO, (Object)rsp);
                if ("0000".equals(wXAppPayBusiRspBO.getRspCode()) && "SUCCESS".equals(wXAppPayBusiRspBO.getPayStatus())) {
                    params = new HashMap();
                    params.put("appId", wXAppPayBusiRspBO.getAppId());
                    params.put("nonceStr", wXAppPayBusiRspBO.getNonceStr());
                    params.put("package_", wXAppPayBusiRspBO.getPacKage());
                    params.put("partnerId", wXAppPayBusiRspBO.getPartnerId());
                    params.put("prepayId", wXAppPayBusiRspBO.getPrepayId());
                    params.put("sign", wXAppPayBusiRspBO.getSign());
                    params.put("timeStamp", wXAppPayBusiRspBO.getTimeStamp());
                    params.put("redirectUrl", wXAppPayBusiRspBO.getRedirectUrl());
                    rsp.setParams(params);
                }
            }
            if ("0000".equals(rsp.getRspCode()) && "SUCCESS".equals(rsp.getPayStatus()) && ("20".equals(req.getPayMethod()) || "30".equals(req.getPayMethod()) || "10".equals(req.getPayMethod()))) {
                CallBackNoticeReqBo callBackNoticeReqBo = new CallBackNoticeReqBo();
                callBackNoticeReqBo.setOrderId(Long.valueOf(Long.parseLong(req.getOrderId())));
                CallBackNoticeRspBo callBackNoticeRspBo = this.callBackNoticeService.dealPayPutMq(callBackNoticeReqBo);
                if ("0000".equals(callBackNoticeRspBo.getRspCode())) {
                    log.info(req.getOrderId() + "\u53d1\u9001\u6d88\u606f\u961f\u5217\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rsp.setRspCode("8888");
            rsp.setRspName("\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void checkInputParas(UniPayCombReqBO req) {
        if (req == null) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getRealFee())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010RealFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getPayMethod())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u652f\u4ed8\u65b9\u5f0f\u3010payMethod\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("10".equals(req.getPayMethod()) && StringUtils.isEmpty((Object)req.getAuthCode())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u6761\u7801\u4e32\u3010authCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("14".equals(req.getPayMethod()) && StringUtils.isEmpty((Object)req.getOpenid())) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u7edf\u4e00\u652f\u4ed8\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u7528\u6237\u6807\u8bc6\u3010openid\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, Object> getParamMap(QueryCashierInfoPayParaAttrRspBo paraInfo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }

    private boolean checkExpTime(Date expTime) {
        if (expTime == null) {
            log.info("\u8ba2\u5355\u8868\u6ca1\u4fdd\u5b58\u8ba2\u5355\u903e\u671f\u65f6\u95f4");
            return false;
        }
        Date nowDate = this.queryDBDateBusiService.getDBDate();
        log.info("\u67e5\u51fa\u6765\u7684\u65f6\u95f4\uff1a" + new SimpleDateFormat("yyyyMMddHHmmss").format(nowDate));
        return expTime.after(nowDate);
    }
}

