/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.BusiSystemMerchantRelAtomService;
import com.tydic.payment.pay.atom.InfoStoreAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.InfoStorePo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.web.bo.req.InfoStoreCreateWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.InfoStoreCreateWebRspBo;
import com.tydic.payment.pay.web.service.InfoStoreCreateWebService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="infoStoreCreateWebService")
public class InfoStoreCreateWebServiceImpl
implements InfoStoreCreateWebService {
    private static final Logger log = LoggerFactory.getLogger(InfoStoreCreateWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private InfoStoreAtomService infoStoreAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private BusiSystemMerchantRelAtomService busiSystemMerchantRelAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;

    public InfoStoreCreateWebRspBo createStoreForMerchant(InfoStoreCreateWebReqBo reqbo) {
        log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqbo));
        InfoStoreCreateWebRspBo rspBo = new InfoStoreCreateWebRspBo();
        this.validateArg(reqbo);
        Long merchantId = Long.valueOf(reqbo.getMerchantId());
        MerChantInfoPo merchantPo = this.merchantInfoAtomService.queryMerchantInfoById(merchantId);
        if (merchantPo == null) {
            log.info("\u5546\u6237ID\u9519\u8bef\uff0c\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u67e5\u8be2\u5230\u8be5\u5546\u6237ID\uff1a" + reqbo.getMerchantId() + "\u7684\u5546\u6237\u4fe1\u606f");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff1a\u8be5\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBo;
        }
        if (!merchantPo.getFlag().equals("1")) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u5931\u8d25\uff1a\u8be5\u5546\u6237\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u4f7f\u7528\u72b6\u6001");
            return rspBo;
        }
        BusiSystemMerchantRelPo busiMerRelPo = new BusiSystemMerchantRelPo();
        busiMerRelPo.setMerchantId(merchantId);
        List<BusiSystemMerchantRelPo> qryBusiMerL = this.busiSystemMerchantRelAtomService.queryBusiSystemMerchantByCondition(busiMerRelPo);
        if (CollectionUtils.isEmpty(qryBusiMerL)) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u65b0\u589e\u95e8\u5e97\u5931\u8d25\uff1a\u8be5\u5546\u6237\u5c1a\u672a\u914d\u7f6e\u4e1a\u52a1\u7cfb\u7edf\uff0c\u65e0\u6cd5\u65b0\u589e\u95e8\u5e97");
            return rspBo;
        }
        if (StringUtils.isEmpty((Object)reqbo.getStoreId())) {
            InfoStorePo po = new InfoStorePo();
            this.beforeCopy(reqbo, po);
            Date createDate = this.queryDBDateBusiService.getDBDate();
            if (!StringUtils.isEmpty((Object)reqbo.getOperId())) {
                po.setCreateOperId(reqbo.getOperId());
            }
            po.setCreateTime(createDate);
            Long storeId = this.infoStoreAtomService.createInfoStore(po);
            if (storeId == null) {
                rspBo.setRspCode("0000");
                rspBo.setRspName("\u65b0\u589e\u6210\u529f\uff1a\u672a\u8fd4\u56de\u95e8\u5e97\u4fe1\u606f");
                return rspBo;
            }
            rspBo.setStoreId(po.getStoreId().toString());
        } else {
            InfoStorePo qryStore = this.infoStoreAtomService.queryInfoStoreByStoreId(Long.valueOf(reqbo.getStoreId()));
            if (qryStore != null) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u63d2\u5165\u5931\u8d25\uff0c\u95e8\u5e97id\u5df2\u5b58\u5728\uff0c\u8bf7\u6362\u4e00\u4e2a\uff0c\u6216\u8005\u4e0d\u586b\u5165\u95e8\u5e97id");
                return rspBo;
            }
            InfoStorePo addpo = new InfoStorePo();
            this.beforeCopy(reqbo, addpo);
            if (!StringUtils.isEmpty((Object)reqbo.getOperId())) {
                addpo.setCreateOperId(reqbo.getOperId());
            }
            addpo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            Long storeId = this.infoStoreAtomService.createInfoStoreWithId(addpo);
            if (StringUtils.isEmpty((Object)storeId)) {
                rspBo.setRspCode("8888");
                rspBo.setRspName("\u95e8\u5e97\u65b0\u589e\u5931\u8d25");
                return rspBo;
            }
            rspBo.setStoreId(addpo.getStoreId().toString());
        }
        InfoStorePo qryStoreById = this.infoStoreAtomService.queryInfoStoreByStoreId(Long.valueOf(rspBo.getStoreId()));
        if (qryStoreById == null) {
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u95e8\u5e97\u65b0\u589e\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u6b64\u95e8\u5e97\u7684\u4fe1\u606f");
            return rspBo;
        }
        BeanUtils.copyProperties((Object)qryStoreById, (Object)rspBo);
        rspBo.setMerchantId(qryStoreById.getMerchantId().toString());
        rspBo.setRspCode("0000");
        rspBo.setRspName("\u95e8\u5e97\u65b0\u589e\u6210\u529f");
        return rspBo;
    }

    private void beforeCopy(InfoStoreCreateWebReqBo reqbo, InfoStorePo po) {
        BeanUtils.copyProperties((Object)reqbo, (Object)po);
        po.setMerchantId(Long.valueOf(reqbo.getMerchantId()));
        if (!StringUtils.isEmpty((Object)reqbo.getStoreId())) {
            po.setStoreId(Long.valueOf(reqbo.getStoreId()));
        }
    }

    private void validateArg(InfoStoreCreateWebReqBo reqbo) {
        if (StringUtils.isEmpty((Object)reqbo)) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u95e8\u5e97\u65b0\u589e\u5165\u53c2bo\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getMerchantId())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u95e8\u5e97\u65b0\u589e\u5165\u53c2bo\u7684\u5546\u6237id(merchantId)\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqbo.getStoreName())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u95e8\u5e97\u65b0\u589e\u5165\u53c2bo\u7684\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

