/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.InfoStoreAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.dao.po.InfoStorePo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.web.bo.req.InfoStoreDeleteWebReqBo;
import com.tydic.payment.pay.web.service.InfoStoreDeleteWebService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="infoStoreDeleteWebService")
public class InfoStoreDeleteWebServiceImpl
implements InfoStoreDeleteWebService {
    private static final Logger log = LoggerFactory.getLogger(InfoStoreDeleteWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private InfoStoreAtomService infoStoreAtomService;

    public BaseRspInfoBO deleteInfoStore(InfoStoreDeleteWebReqBo reqbo) {
        log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqbo));
        BaseRspInfoBO rspbo = new BaseRspInfoBO();
        this.validateArg(reqbo);
        MerChantInfoPo merPo = new MerChantInfoPo();
        merPo.setMerchantId(Long.valueOf(reqbo.getMerchantId()));
        List<MerChantInfoPo> merList = this.merchantInfoAtomService.queryMerChantInfoByCondition(merPo);
        if (merList == null || merList.isEmpty()) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u5931\u8d25\uff1a\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
            rspbo.setRspCode("8888");
            rspbo.setRspName("\u5220\u9664\u5931\u8d25\uff1a\u8be5\u5546\u6237\u4e0d\u5b58\u5728");
            return rspbo;
        }
        InfoStorePo storePo = new InfoStorePo();
        storePo.setMerchantId(Long.valueOf(reqbo.getMerchantId()));
        storePo.setStoreId(Long.valueOf(reqbo.getStoreId()));
        List<InfoStorePo> storeList = this.infoStoreAtomService.queryInfoStoreByCondition(storePo);
        if (storeList == null || storeList.isEmpty()) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u5931\u8d25\uff1a\u8be5\u5546\u6237" + reqbo.getMerchantId() + "\u4e0d\u5b58\u5728\u5e97\u94faid(" + reqbo.getStoreId() + ")\u7684\u5e97\u94fa");
            rspbo.setRspCode("8888");
            rspbo.setRspName("\u5220\u9664\u5931\u8d25\uff1a\u8be5\u5546\u6237\u6ca1\u6709\u8be5\u5e97\u94fa");
            return rspbo;
        }
        int deleteStore = this.infoStoreAtomService.deleteInfoStore(storePo);
        if (deleteStore < 1) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u5931\u8d25\uff1a\u65e0\u6cd5\u5220\u9664\u5e97\u94faid(" + reqbo.getStoreId() + ")\u7684\u5e97\u94fa");
            rspbo.setRspCode("8888");
            rspbo.setRspName("\u5220\u9664\u5931\u8d25\uff1a\u6570\u636e\u5e93\u9519\u8bef");
            return rspbo;
        }
        rspbo.setRspCode("0000");
        rspbo.setRspName("\u5220\u9664\u6210\u529f");
        return rspbo;
    }

    private void validateArg(InfoStoreDeleteWebReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo)) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u5165\u53c2bo\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u5165\u53c2bo\u7684\u5546\u6237id(merchantId)\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getStoreId())) {
            log.info("\u95e8\u5e97\u914d\u7f6e-\u5e97\u94fa\u5220\u9664\u5165\u53c2bo\u7684\u5e97\u94faid(storeId)\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u5e97\u94faid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

