/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.MerchantPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayInfoFileMappingAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAtomService;
import com.tydic.payment.pay.atom.PayParaInfoAttrAtomService;
import com.tydic.payment.pay.atom.PayRuleParaAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.bo.busi.ValidatePaymentInsReqBo;
import com.tydic.payment.pay.bo.busi.ValidatePaymentInsRspBo;
import com.tydic.payment.pay.busi.api.QueryDBDateBusiService;
import com.tydic.payment.pay.busi.api.ValidatePaymentInsBusiService;
import com.tydic.payment.pay.constant.PayConfigConstants;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.MerchantPayMethodRelPo;
import com.tydic.payment.pay.dao.po.PayParaInfoAttrPo;
import com.tydic.payment.pay.dao.po.PayParaInfoPo;
import com.tydic.payment.pay.dao.po.PayRuleParaPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.rsa.util.RsaEncodeUtil;
import com.tydic.payment.pay.web.bo.req.InfoMechartPaymentInsReqBO;
import com.tydic.payment.pay.web.bo.req.MerchantInfoPaymentManagerParaAttrReqBo;
import com.tydic.payment.pay.web.bo.req.MerchantInfoPaymentManagerPayMethodReqBo;
import com.tydic.payment.pay.web.bo.req.MerchantInfoPaymentManagerReqBO;
import com.tydic.payment.pay.web.service.MerchantInfoPaymentManagerService;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="merchantInfoPaymentManagerService")
public class MerchantInfoPaymentManagerServiceImpl
implements MerchantInfoPaymentManagerService {
    private static final Logger log = LoggerFactory.getLogger(MerchantInfoPaymentManagerServiceImpl.class);
    @Autowired
    private ValidatePaymentInsBusiService validatePaymentInsBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    @Autowired
    private PayParaInfoAtomService payParaInfoAtomService;
    @Autowired
    private PayParaInfoAttrAtomService payParaInfoAttrAtomService;
    @Autowired
    private PayInfoFileMappingAtomService payInfoFileMappingAtomService;
    @Autowired
    private MerchantPayMethodRelAtomService merchantPayMethodRelAtomService;
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private PayRuleParaAtomService payRuleParaAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseRspInfoBO dealMerchantInfoPaymentManager(MerchantInfoPaymentManagerReqBO req) {
        log.info("api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u5165\u53c2\uff1a" + req);
        BaseRspInfoBO rsp = new BaseRspInfoBO();
        try {
            if (StringUtils.isEmpty((Object)req.getInfoBusiListStr())) {
                rsp.setRspCode("8888");
                rsp.setRspName("\u5165\u53c2\u3010infoBusiListStr\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return rsp;
            }
            List infoBusiListStr = JSON.parseArray((String)req.getInfoBusiListStr(), InfoMechartPaymentInsReqBO.class);
            req.setInfoBusiList(infoBusiListStr);
            log.info("api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u5165\u53c22\uff1a" + req);
            if (!"2".equals(req.getOperType())) {
                this.validateReq(req);
            } else {
                List infoPaymentInsList = req.getInfoBusiList();
                if (infoPaymentInsList == null) throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010InfoBusiList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                if (infoPaymentInsList.isEmpty()) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010InfoBusiList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                for (InfoMechartPaymentInsReqBO paymentBo : infoPaymentInsList) {
                    if (paymentBo == null) {
                        throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010\u652f\u4ed8\u673a\u6784\u5217\u8868\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (paymentBo.getPaymentInsId() == null) throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010paymentInsId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    if (!paymentBo.getPaymentInsId().trim().isEmpty()) continue;
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010paymentInsId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!"2".equals(req.getOperType())) {
                List infoPaymentInsList2 = req.getInfoBusiList();
                ArrayList<InfoMechartPaymentInsReqBO> infoPaymentInsListNew = new ArrayList<InfoMechartPaymentInsReqBO>();
                ArrayList<MerchantInfoPaymentManagerPayMethodReqBo> payMethodListNew = new ArrayList<MerchantInfoPaymentManagerPayMethodReqBo>();
                for (InfoMechartPaymentInsReqBO pbo : infoPaymentInsList2) {
                    Object tmpo2;
                    ArrayList<Long> payMethodList;
                    ValidatePaymentInsReqBo validateBo;
                    block22: {
                        String paymentInsId = pbo.getPaymentInsId();
                        this.addNoCommitValue(pbo);
                        validateBo = new ValidatePaymentInsReqBo();
                        validateBo.setPaymentInsId(Long.valueOf(paymentInsId));
                        payMethodList = new ArrayList<Long>();
                        if (pbo.getPayMethodList() == null || pbo.getPayMethodList().size() <= 0) {
                            MerChantInfoPo qryMerChantInfoPo = new MerChantInfoPo();
                            qryMerChantInfoPo.setMerchantId(Long.valueOf(req.getMerchantId()));
                            List<MerChantInfoPo> qryMerChantInfoPoList = this.merchantInfoAtomService.queryMerChantInfoByCondition(qryMerChantInfoPo);
                            Long mainMerchantId = qryMerChantInfoPoList.get(0).getMainMerchantId();
                            MerchantPayMethodRelPo qryMPRelPo = new MerchantPayMethodRelPo();
                            qryMPRelPo.setMerchantId((long)mainMerchantId);
                            qryMPRelPo.setPaymentInsId(Long.valueOf(paymentInsId));
                            List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryMPRelPo);
                            if (queryMerchantPayMethodRelByCondition != null && queryMerchantPayMethodRelByCondition.size() > 0) {
                                for (MerchantPayMethodRelPo merchantPayMethodRel : queryMerchantPayMethodRelByCondition) {
                                    payMethodList.add(merchantPayMethodRel.getPayMethod());
                                    MerchantInfoPaymentManagerPayMethodReqBo merchantInfoPaymentManagerPayMethodReqBo = new MerchantInfoPaymentManagerPayMethodReqBo();
                                    merchantInfoPaymentManagerPayMethodReqBo.setPayMethod(String.valueOf(merchantPayMethodRel.getPayMethod()));
                                    payMethodListNew.add(merchantInfoPaymentManagerPayMethodReqBo);
                                }
                                pbo.setPayMethodList(payMethodListNew);
                                infoPaymentInsListNew.add(pbo);
                                req.setInfoBusiList(infoPaymentInsListNew);
                                validateBo.setSubFlag("1");
                                break block22;
                            } else {
                                PaymentInsPo qryPayPo = new PaymentInsPo();
                                qryPayPo.setPaymentInsId(Long.parseLong(pbo.getPaymentInsId()));
                                List<PaymentInsPo> qryPaymentL = this.paymentInsAtomService.queryPaymentInf(qryPayPo);
                                if (CollectionUtils.isEmpty(qryPaymentL)) {
                                    log.info("\u652f\u4ed8\u673a\u6784ID\u4e3a" + pbo.getPaymentInsId() + "\u5728\u6570\u636e\u5e93\u8868p_info_payment_ins\u4e2d\u4e0d\u5b58\u5728");
                                    throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u652f\u4ed8\u673a\u6784ID\u4e3a" + pbo.getPaymentInsId() + "\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
                                }
                                log.info("\u8be5\u5546\u6237\u3010" + req.getMerchantId() + "\u3011\u5bf9\u5e94\u7684\u4e3b\u5546\u6237\u3010" + mainMerchantId + "\u3011\u6ca1\u6709\u76f8\u5e94\u7684\u673a\u6784\u3010" + pbo.getPaymentInsId() + pbo.getPaymentInsName() + "\u3011\u652f\u4ed8\u65b9\u5f0f\uff0c\u8bf7\u5148\u5bf9\u4e3b\u5546\u6237\u7ba1\u7406\uff01");
                                throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e3b\u5546\u6237\u3010" + mainMerchantId + "\u3011\u6ca1\u6709\u76f8\u5e94\u7684\u673a\u6784:[" + qryPaymentL.get(0).getPaymentInsName() + "]\u7684\u652f\u4ed8\u65b9\u5f0f\uff0c\u8bf7\u5148\u5bf9\u4e3b\u5546\u6237\u7ba1\u7406\uff01");
                            }
                        }
                        for (Object tmpo2 : pbo.getPayMethodList()) {
                            payMethodList.add(Long.valueOf(tmpo2.getPayMethod()));
                        }
                    }
                    validateBo.setPayMethodList(payMethodList);
                    ArrayList<String> payParaList = new ArrayList<String>();
                    validateBo.setPayParaList(payParaList);
                    tmpo2 = pbo.getRulePayParaList().iterator();
                    while (tmpo2.hasNext()) {
                        MerchantInfoPaymentManagerParaAttrReqBo tmbo = (MerchantInfoPaymentManagerParaAttrReqBo)tmpo2.next();
                        payParaList.add(tmbo.getAttrCode());
                    }
                    ValidatePaymentInsRspBo validatePaymentIns = this.validatePaymentInsBusiService.validatePaymentIns(validateBo);
                    if ("0000".equals(validatePaymentIns.getRspCode())) continue;
                    throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", validatePaymentIns.getRspName());
                }
            }
            if ("0".equals(req.getOperType())) {
                this.addAttrAndMethod(req);
            } else if ("1".equals(req.getOperType())) {
                this.updateAttrAndMethod(req);
            } else if ("2".equals(req.getOperType())) {
                this.deleteAttrAndMethod(req);
            }
            rsp.setRspCode("0000");
            rsp.setRspName("\u6210\u529f");
            return rsp;
        }
        catch (Exception e) {
            log.info("api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u5f02\u5e38\uff1a" + e);
            rsp.setRspCode("8888");
            rsp.setRspName("api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void addNoCommitValue(InfoMechartPaymentInsReqBO pbo) throws NoSuchAlgorithmException {
        PayRuleParaPo payParaRulePo = new PayRuleParaPo();
        long paymentInsId = Long.valueOf(pbo.getPaymentInsId());
        List rulePayParaList = pbo.getRulePayParaList();
        payParaRulePo.setPaymentInsId(paymentInsId);
        payParaRulePo.setNoNeedInput(PayConfigConstants.PAY_PARA_NO_NEED_INPUT);
        List<PayRuleParaPo> queryPayParaRuleByConditionResult = this.payRuleParaAtomService.queryPayRuleParaByCondition(payParaRulePo);
        if (!queryPayParaRuleByConditionResult.isEmpty() && "10".equals(paymentInsId + "")) {
            Map stringStringMap = RsaEncodeUtil.generateRSAKeysForWopay();
            String privateKey = (String)stringStringMap.get("private");
            String publicKey = (String)stringStringMap.get("public");
            MerchantInfoPaymentManagerParaAttrReqBo privateBo = new MerchantInfoPaymentManagerParaAttrReqBo();
            privateBo.setAttrCode("privateKey");
            privateBo.setAttrValue(privateKey);
            privateBo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            privateBo.setRemark("\u81ea\u52a8\u6dfb\u52a0");
            rulePayParaList.add(privateBo);
            MerchantInfoPaymentManagerParaAttrReqBo publicBo = new MerchantInfoPaymentManagerParaAttrReqBo();
            publicBo.setAttrCode("publicKey");
            publicBo.setAttrValue(publicKey);
            publicBo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            publicBo.setRemark("\u81ea\u52a8\u6dfb\u52a0");
            rulePayParaList.add(publicBo);
        }
    }

    private void validateReq(MerchantInfoPaymentManagerReqBO req) {
        List infoPaymentInsList = req.getInfoBusiList();
        if (infoPaymentInsList == null || infoPaymentInsList.isEmpty()) {
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010InfoBusiList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (InfoMechartPaymentInsReqBO paymentBo : infoPaymentInsList) {
            if (paymentBo == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010\u652f\u4ed8\u673a\u6784\u5217\u8868\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (paymentBo.getPaymentInsId() == null || paymentBo.getPaymentInsId().trim().isEmpty()) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010paymentInsId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList rulePayParaList = paymentBo.getRulePayParaList();
            if (rulePayParaList == null) {
                rulePayParaList = new ArrayList();
                paymentBo.setRulePayParaList(rulePayParaList);
            }
            for (MerchantInfoPaymentManagerParaAttrReqBo attrBo : rulePayParaList) {
                if (attrBo == null) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u53c2\u6570\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (attrBo.getAttrCode() == null || attrBo.getAttrCode().trim().isEmpty()) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010attrCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (attrBo.getAttrValue() != null && !attrBo.getAttrValue().trim().isEmpty()) continue;
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010attrValue\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ("1".equals(paymentBo.getPaymentInsId())) continue;
            List payMethodList = paymentBo.getPayMethodList();
            if (payMethodList == null) {
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (MerchantInfoPaymentManagerPayMethodReqBo methodBo : payMethodList) {
                if (methodBo == null) {
                    throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010\u652f\u4ed8\u673a\u6784\u652f\u4ed8\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (methodBo.getPayMethod() != null && !methodBo.getPayMethod().trim().isEmpty()) continue;
                throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "api-\u5546\u6237\u652f\u4ed8\u673a\u6784\u7ba1\u7406\u670d\u52a1\u3010payMethod\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void addAttrAndMethod(MerchantInfoPaymentManagerReqBO req) {
        List infoPaymentInsList = req.getInfoBusiList();
        for (InfoMechartPaymentInsReqBO bo : infoPaymentInsList) {
            List rulePayParaList = bo.getRulePayParaList();
            List payMethodList = bo.getPayMethodList();
            String paymentInsId = bo.getPaymentInsId();
            Long payParaId = 0L;
            MerchantPayMethodRelPo merchantPayMethodRelPo = new MerchantPayMethodRelPo();
            merchantPayMethodRelPo.setMerchantId(Long.valueOf(req.getMerchantId()));
            merchantPayMethodRelPo.setPaymentInsId(Long.valueOf(paymentInsId));
            List<MerchantPayMethodRelPo> merchantPayMethodRelList = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(merchantPayMethodRelPo);
            if (merchantPayMethodRelList != null && merchantPayMethodRelList.size() > 0) {
                throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be5\u5546\u6237\u3010" + req.getMerchantId() + "\u3011\u5df2\u7ecf\u65b0\u589e\u8fc7\u8be5\u673a\u6784\u3010" + paymentInsId + "\u3011\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u65b0\u589e\uff01");
            }
            PayParaInfoPo payParaPo = new PayParaInfoPo();
            payParaPo.setParaName("\u5546\u6237(" + req.getMerchantId() + ")\u7684\u652f\u4ed8\u53c2\u6570(" + paymentInsId + ")");
            payParaPo.setPaymentInsId(Long.valueOf(paymentInsId));
            payParaPo.setState("1");
            payParaPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
            payParaId = this.payParaInfoAtomService.createPayParaInfo(payParaPo);
            for (MerchantInfoPaymentManagerParaAttrReqBo attrBo : rulePayParaList) {
                PayParaInfoAttrPo attrPo = new PayParaInfoAttrPo();
                BeanUtils.copyProperties((Object)attrBo, (Object)attrPo);
                attrPo.setPayParaId(payParaId);
                attrPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
                this.payParaInfoAttrAtomService.createPayParaInfoAttr(attrPo);
            }
            for (MerchantInfoPaymentManagerPayMethodReqBo meBo : payMethodList) {
                MerchantPayMethodRelPo mPo = new MerchantPayMethodRelPo();
                mPo.setPaymentInsId(Long.valueOf(paymentInsId));
                mPo.setMerchantId(Long.valueOf(req.getMerchantId()));
                mPo.setPayMethod(Long.valueOf(meBo.getPayMethod()));
                mPo.setPayParaId(payParaId);
                mPo.setCreateTime(this.queryDBDateBusiService.getDBDate());
                this.merchantPayMethodRelAtomService.createMerchantPayMethodRel(mPo);
            }
        }
    }

    private void updateAttrAndMethod(MerchantInfoPaymentManagerReqBO req) {
        this.deleteAttrAndMethod(req);
        this.addAttrAndMethod(req);
    }

    private void deleteAttrAndMethod(MerchantInfoPaymentManagerReqBO req) {
        List infoPaymentInsList = req.getInfoBusiList();
        for (InfoMechartPaymentInsReqBO paymentBo : infoPaymentInsList) {
            MerchantPayMethodRelPo qryMPRelPo = new MerchantPayMethodRelPo();
            qryMPRelPo.setMerchantId(Long.valueOf(req.getMerchantId()));
            qryMPRelPo.setPaymentInsId(Long.valueOf(paymentBo.getPaymentInsId()));
            List<MerchantPayMethodRelPo> queryMerchantPayMethodRelByCondition = this.merchantPayMethodRelAtomService.queryMerchantPayMethodRelByCondition(qryMPRelPo);
            MerchantPayMethodRelPo delMerPo = new MerchantPayMethodRelPo();
            delMerPo.setMerchantId(Long.valueOf(req.getMerchantId()));
            delMerPo.setPaymentInsId(Long.valueOf(paymentBo.getPaymentInsId()));
            int count = this.merchantPayMethodRelAtomService.deleteMerchantPayMethodRelByCondition(delMerPo);
            log.info("\u5220\u9664\u65e7\u7684\u5546\u6237-\u652f\u4ed8\u5173\u7cfb\u6570\u636e\u6210\u529f\uff1a" + count + "\u6761");
            for (MerchantPayMethodRelPo mppo : queryMerchantPayMethodRelByCondition) {
                Long l = mppo.getPaymentInsId();
            }
        }
    }
}

