/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.PorderRefundTransAtomService;
import com.tydic.payment.pay.bo.busi.req.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.bo.busi.req.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.bo.busi.rsp.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.bo.busi.rsp.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.busi.api.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.api.QueryPCodeInfoService;
import com.tydic.payment.pay.common.util.MoneyUtils;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PorderPageReqPO;
import com.tydic.payment.pay.dao.po.PorderPayTransPo;
import com.tydic.payment.pay.dao.po.PorderPo;
import com.tydic.payment.pay.dao.po.PorderRefundTransPo;
import com.tydic.payment.pay.web.bo.req.MyPayOrderListQryWebReqBo;
import com.tydic.payment.pay.web.bo.rsp.MyPayOrderListRspBO;
import com.tydic.payment.pay.web.service.MyPayOrderListQryWebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="myPayOrderListQryWebService")
public class MyPayOrderListQryWebServiceImpl
implements MyPayOrderListQryWebService {
    private static final Logger log = LoggerFactory.getLogger(MyPayOrderListQryWebServiceImpl.class);
    @Autowired
    OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    PayOrderAtomService payOrderAtomService;
    @Autowired
    PorderPayTransAtomService porderPayTransAtomService;
    @Autowired
    BusiSystemInfoAtomService busiSystemInfoAtomService;
    @Autowired
    QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    PayMethodAtomService payMethodAtomService;
    @Autowired
    private PorderRefundTransAtomService porderRefundTransAtomService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RspPage<MyPayOrderListRspBO> qryMyPayOrderList(MyPayOrderListQryWebReqBo reqBo) {
        List<PorderPo> qryPorderL;
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        RspPage retBo = new RspPage();
        ArrayList<MyPayOrderListRspBO> rspList = new ArrayList<MyPayOrderListRspBO>();
        retBo.setRows(rspList);
        this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            OrderQueryConstructionReqBo queryConstructionReqBo = new OrderQueryConstructionReqBo();
            queryConstructionReqBo.setOutOrderId(reqBo.getOutOrderId());
            OrderQueryConstructionRspBo queryConstructionRspBo = this.orderQueryConstructionBusiService.queryConstructionByOutOrderId(queryConstructionReqBo);
            if (queryConstructionRspBo.getOrderId() == null) {
                log.info("\u672a\u67e5\u8be2\u5230\u5916\u90e8\u8ba2\u5355\u53f7\u5173\u8054\u7684\u8ba2\u5355\u53f7,p_order_query\u4e2d\u4e0d\u5b58\u5728\u8bb0\u5f55,\u5916\u90e8\u8ba2\u5355\u53f7(outOrderId)\u4e3a\uff1a" + reqBo.getOutOrderId());
                retBo.setPageNo(1);
                retBo.setTotal(0);
                retBo.setRecordsTotal(0);
                return retBo;
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
                if (!queryConstructionRspBo.getOrderId().equals(reqBo.getOrderId())) {
                    log.info("\u901a\u8fc7p_order_query\u7684\u5916\u90e8\u8ba2\u5355\u53f7\u4e0e\u5165\u53c2\u7684orderId" + reqBo.getOrderId() + "\u4e0d\u4e00\u81f4\uff0c\u4e0d\u662f\u540c\u4e00\u7b14\u8ba2\u5355");
                    retBo.setTotal(0);
                    retBo.setRecordsTotal(0);
                    retBo.setPageNo(1);
                    return retBo;
                }
                reqBo.setOrderId("" + queryConstructionRspBo.getOrderId());
            } else {
                reqBo.setOrderId(queryConstructionRspBo.getOrderId().toString());
            }
        }
        MerChantInfoPo qryMerPo = new MerChantInfoPo();
        qryMerPo.setCreateOperId(reqBo.getOperId());
        List<MerChantInfoPo> qryMerL = this.merchantInfoAtomService.queryMerChantIdAndNameByCondition(qryMerPo);
        if (CollectionUtils.isEmpty(qryMerL)) {
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            retBo.setPageNo(1);
            return retBo;
        }
        HashSet<Long> merchantIdSet = new HashSet<Long>();
        for (MerChantInfoPo temp : qryMerL) {
            if (merchantIdSet.contains(temp.getMerchantId())) continue;
            merchantIdSet.add(temp.getMerchantId());
        }
        HashSet<Long> orderIdSet = new HashSet<Long>();
        String payMethod = reqBo.getPayMethod();
        PorderPayTransPo qryPorderPayTranasPo = new PorderPayTransPo();
        PorderRefundTransPo qryRefundPBo = new PorderRefundTransPo();
        if (!StringUtils.isEmpty((Object)payMethod)) {
            qryPorderPayTranasPo.setPayMethod(Long.parseLong(payMethod));
            qryRefundPBo.setPayMethod(Long.parseLong(reqBo.getPayMethod()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            qryPorderPayTranasPo.setOrderId(Long.parseLong(reqBo.getOrderId()));
            qryRefundPBo.setOrderId(Long.parseLong(reqBo.getOrderId()));
        }
        List<Long> payTransAtomList = this.porderPayTransAtomService.queryOrderIdOfMerchantIdSetByCondition(qryPorderPayTranasPo, merchantIdSet);
        List<Long> porderRefundTransAtomList = this.porderRefundTransAtomService.queryOrderRefundTransOfMerchantIdSetByCondition(qryRefundPBo, merchantIdSet);
        if (CollectionUtils.isEmpty(payTransAtomList) && CollectionUtils.isEmpty(porderRefundTransAtomList)) {
            log.info("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u673a\u6784\u4e0b\u7684\u8ba2\u5355\uff1a\u5165\u53c2" + JSON.toJSONString((Object)qryPorderPayTranasPo));
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            retBo.setPageNo(1);
            return retBo;
        }
        if (!CollectionUtils.isEmpty(payTransAtomList)) {
            orderIdSet.addAll(payTransAtomList);
        }
        for (Long temx : porderRefundTransAtomList) {
            if (orderIdSet.contains(temx)) continue;
            orderIdSet.add(temx);
        }
        PorderPageReqPO qryPorderPo = new PorderPageReqPO();
        Date dateEnd = null;
        Long payFeeLess = null;
        Long payFeeMore = null;
        try {
            if (!StringUtils.isEmpty((Object)reqBo.getPayFeeLess())) {
                payFeeLess = MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(reqBo.getPayFeeLess()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getPayFeeMore())) {
                payFeeMore = MoneyUtils.fenToHaoToLong((BigDecimal)new BigDecimal(reqBo.getPayFeeMore()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getDataEnd())) {
                dateEnd = new DateTime((Object)reqBo.getDataEnd()).plusDays(1).withMillisOfDay(0).toDate();
            }
            if (!StringUtils.isEmpty((Object)reqBo.getDateBegin())) {
                qryPorderPo.setCreateTime(new DateTime((Object)reqBo.getDateBegin()).withMillisOfDay(0).toDate());
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOrderId())) {
                qryPorderPo.setOrderId(Long.parseLong(reqBo.getOrderId()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getBusiId())) {
                qryPorderPo.setBusiId(Long.parseLong(reqBo.getBusiId()));
            }
        }
        catch (Exception e) {
            log.info("\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff0c\u4ee3\u7801\u9519\u8bef\uff0cMoneyUtil\u65e0\u6cd5\u8fdb\u884c\u6570\u636e\u8f6c\u6362");
            e.printStackTrace();
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6570\u636e\u8f6c\u6362\u51fa\u9519:\u4ee3\u7801\u9519\u8bef");
        }
        Page page = new Page();
        BeanUtils.copyProperties((Object)reqBo, (Object)page);
        if (page.getPageNo() < 1) {
            page.setPageNo(1);
        }
        if (page.getPageSize() < 1) {
            page.setPageSize(10);
        }
        if (CollectionUtils.isEmpty(qryPorderL = this.payOrderAtomService.queryPorderByMerSetAndOrderIdSetCondition((Page<PorderPageReqPO>)page, qryPorderPo, dateEnd, payFeeLess, payFeeMore, orderIdSet, merchantIdSet))) {
            log.info("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            retBo.setRecordsTotal(0);
            retBo.setTotal(0);
            retBo.setPageNo(1);
            return retBo;
        }
        this.generateRspList(qryPorderL, rspList);
        retBo.setRecordsTotal(page.getTotalCount());
        retBo.setTotal(page.getTotalPages());
        retBo.setPageNo(page.getPageNo());
        return retBo;
    }

    private void generateRspList(List<PorderPo> qryPorderL, List<MyPayOrderListRspBO> rspList) {
        try {
            for (PorderPo porderPo : qryPorderL) {
                QueryPCodeInfoRspBO qryPCodeRspBo;
                QueryPCodeInfoReqBO qryPCodeBo;
                MyPayOrderListRspBO rspBo = new MyPayOrderListRspBO();
                BeanUtils.copyProperties((Object)porderPo, (Object)rspBo);
                rspBo.setOrderId(porderPo.getOrderId() == null ? "" : porderPo.getOrderId().toString());
                rspBo.setCreateTime(porderPo.getCreateTime() == null ? "" : new DateTime((Object)porderPo.getCreateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                if (porderPo.getTotalFee() == null) {
                    rspBo.setTotalFee("");
                } else {
                    BigDecimal totalFee = MoneyUtils.haoToFen((Long)porderPo.getTotalFee());
                    rspBo.setTotalFee(totalFee.toPlainString());
                }
                if (porderPo.getRealFee() == null) {
                    rspBo.setRealFee("");
                } else {
                    BigDecimal realFee = MoneyUtils.haoToFen((Long)porderPo.getRealFee());
                    rspBo.setRealFee(realFee.toPlainString());
                }
                if (porderPo.getBusiId() != null) {
                    BusiSystemInfoPO busiResultPo;
                    rspBo.setBusiId(porderPo.getBusiId().toString());
                    BusiSystemInfoPO busiPo = new BusiSystemInfoPO();
                    busiPo.setBusiId(porderPo.getBusiId());
                    List<BusiSystemInfoPO> busiL = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiPo);
                    if (busiL == null || busiL.size() < 1) {
                        rspBo.setBusiId("");
                        rspBo.setBusiName("");
                    }
                    rspBo.setBusiName(StringUtils.isEmpty((Object)(busiResultPo = busiL.get(0)).getBusiName()) ? "" : busiResultPo.getBusiName());
                }
                if (!StringUtils.isEmpty((Object)porderPo.getOrderType().trim())) {
                    qryPCodeBo = new QueryPCodeInfoReqBO();
                    qryPCodeBo.setTypeCode("P_ORDER_ORDER_TYPE");
                    qryPCodeBo.setCodeValue(porderPo.getOrderType());
                    qryPCodeRspBo = this.queryPCodeInfoService.queryPCodeInfo(qryPCodeBo);
                    if (qryPCodeRspBo.getRespCode().equals("0000")) {
                        rspBo.setOrderTypeName(qryPCodeRspBo == null ? "" : qryPCodeRspBo.getCodeInfo());
                    } else {
                        rspBo.setOrderTypeName(rspBo.getOrderType());
                    }
                }
                if (!StringUtils.isEmpty((Object)porderPo.getOrderStatus().trim())) {
                    qryPCodeBo = new QueryPCodeInfoReqBO();
                    qryPCodeBo.setTypeCode("P_ORDER_ORDER_STATUS");
                    qryPCodeBo.setCodeValue(porderPo.getOrderStatus());
                    qryPCodeRspBo = this.queryPCodeInfoService.queryPCodeInfo(qryPCodeBo);
                    if (qryPCodeRspBo.getRespCode().equals("0000")) {
                        rspBo.setOrderStatusName(qryPCodeRspBo == null ? "" : qryPCodeRspBo.getCodeInfo());
                    } else {
                        rspBo.setOrderStatusName(rspBo.getOrderStatus());
                    }
                }
                PorderPayTransPo transPo = new PorderPayTransPo();
                transPo.setOrderId(porderPo.getOrderId());
                List<PorderPayTransPo> transPoList = this.porderPayTransAtomService.queryOrderPayTrans(transPo);
                if (transPoList == null || transPoList.size() < 1) {
                    rspBo.setPayMethod("");
                    rspBo.setPayMethodName("");
                } else {
                    rspBo.setPayMethod(transPoList.get(0).getPayMethod().toString());
                    PayMethodPo qryPayMethodPo = new PayMethodPo();
                    qryPayMethodPo.setPayMethod(transPoList.get(0).getPayMethod());
                    List<PayMethodPo> payMethodL = this.payMethodAtomService.queryPayMethod(qryPayMethodPo);
                    if (payMethodL == null || payMethodL.size() < 1) {
                        log.info("pay_method:" + qryPayMethodPo.getPayMethod() + "\u5728\u6570\u636e\u5e93\u8868p_code_pay_method\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664");
                        rspBo.setPayMethod("");
                        rspBo.setPayMethodName("");
                    } else {
                        PayMethodPo payMethodPo = payMethodL.get(0);
                        rspBo.setPayMethodName(StringUtils.isEmpty((Object)payMethodPo.getPayMethodName()) ? "" : payMethodPo.getPayMethodName());
                    }
                }
                rspList.add(rspBo);
            }
        }
        catch (Exception e) {
            throw new ResourceException("RSP_CODE_BUSI_SERVICE_ERROR", "\u51fa\u53c2\u5c01\u88c5\u9519\u8bef");
        }
    }

    private void validateArg(MyPayOrderListQryWebReqBo reqBo) {
        if (reqBo == null) {
            log.info("\u5165\u53c2bo\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOperId())) {
            log.info("\u5165\u53c2bo\u5bf9\u8c61\u7684operId\uff08\u5de5\u53f7\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ResourceException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

