/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.busi.impl;

import com.tydic.payment.bill.busi.PaymentInsIdBusiService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.dao.BillCompareParaMapper;
import com.tydic.payment.pay.dao.po.BillCompareParaPO;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.exception.BusinessException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="paymentInsIdBusiService")
public class PaymentInsIdBusiServiceImpl
implements PaymentInsIdBusiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private BillCompareParaMapper billCompareParaMapper;

    public Long getPaymentInsIdByPayMethod(Long payMethod) {
        if (payMethod == null) {
            return null;
        }
        PayMethodPo reqPO = new PayMethodPo();
        reqPO.setPayMethod(payMethod);
        List<PayMethodPo> pos = this.payMethodAtomService.queryPayMethod(reqPO);
        if (pos == null || pos.size() < 1) {
            throw new RuntimeException("\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5bf9\u5e94\u652f\u4ed8\u673a\u6784ID\u6570\u636e\u4e3a\u7a7a\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e3a\u3010" + payMethod + "\u3011");
        }
        return pos.get(0).getPaymentInsId();
    }

    public Long getBillDate() {
        BillCompareParaPO rspPO = this.billCompareParaMapper.getByAttrCode("pay_bill_day");
        Long billDate = Long.valueOf(LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        if (Objects.isNull(rspPO) || StringUtils.isEmpty((Object)rspPO.getAttrValue()) || Objects.equals("ok", rspPO.getAttrValue())) {
            return billDate;
        }
        return Long.parseLong(rspPO.getAttrValue());
    }

    public Long getBillSplitTotal() {
        BillCompareParaPO rspPO = this.billCompareParaMapper.getByAttrCode("bill_split_total");
        Long total = Long.parseLong("1");
        if (rspPO == null) {
            return total;
        }
        if (StringUtils.isEmpty((Object)rspPO.getAttrValue())) {
            return total;
        }
        try {
            return Long.parseLong(rspPO.getAttrValue());
        }
        catch (Exception ex) {
            this.logger.warn("get [bill_split_total] from [p_bill_compare_para] parse long exception, use default value. ", (Throwable)ex);
            return total;
        }
    }

    public List<Long> listPayMethodByPaymentInsId(Long paymentInsId) {
        if (Objects.isNull(paymentInsId)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5165\u53c2\u652f\u4ed8\u673a\u6784ID\u4e3a\u7a7a");
        }
        PayMethodPo reqPO = new PayMethodPo();
        reqPO.setPaymentInsId(paymentInsId);
        List<PayMethodPo> payMethodPoList = this.payMethodAtomService.queryPayMethod(reqPO);
        if (ObjectUtils.isEmpty(payMethodPoList)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> payMethods = new ArrayList<Long>(16);
        for (PayMethodPo tempPO : payMethodPoList) {
            payMethods.add(tempPO.getPayMethod());
        }
        return payMethods;
    }
}

