/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.bill.comb.impl;

import com.tydic.payment.bill.BillExecuteRequest;
import com.tydic.payment.bill.busi.BillCompareDiffCreateBusiService;
import com.tydic.payment.bill.busi.BillCompareDiffQueryBusiService;
import com.tydic.payment.bill.busi.BillPayBillDayCreateBusiService;
import com.tydic.payment.bill.busi.BillPayTransUpdateSuccessBusiService;
import com.tydic.payment.bill.busi.BillRefundTransUpdateSuccessBusiService;
import com.tydic.payment.bill.busi.QueryPayTransBusiService;
import com.tydic.payment.bill.busi.QueryRefundBusiService;
import com.tydic.payment.bill.busi.bo.BillCompareDiffQueryReqBO;
import com.tydic.payment.bill.busi.bo.BillCompareDiffQueryRspBO;
import com.tydic.payment.bill.busi.bo.BillPayBillDayCreateReqBO;
import com.tydic.payment.bill.busi.bo.BillPayTransUpdateSuccessReqBO;
import com.tydic.payment.bill.busi.bo.BillRefundTransUpdateSuccessReqBO;
import com.tydic.payment.bill.busi.bo.QueryPayTransRspBO;
import com.tydic.payment.bill.busi.bo.QueryRefundRspBO;
import com.tydic.payment.bill.comb.BillPayBalanceCombService;
import com.tydic.payment.bill.exception.BillBalanceException;
import com.tydic.payment.pay.LoggerProUtils;
import com.tydic.payment.pay.busi.CallBackNoticeService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billPayBalanceCombService")
public class BillPayBalanceCombServiceImpl
implements BillPayBalanceCombService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private BillCompareDiffQueryBusiService billCompareDiffQueryBusiService;
    private BillPayBillDayCreateBusiService billPayBillDayCreateBusiService;
    private BillPayTransUpdateSuccessBusiService billPayTransUpdateSuccessBusiService;
    private BillRefundTransUpdateSuccessBusiService billRefundTransUpdateSuccessBusiService;
    private BillCompareDiffCreateBusiService billCompareDiffCreateBusiService;
    private CallBackNoticeService callBackNoticeService;
    @Autowired
    private QueryPayTransBusiService queryPayTransBusiService;
    @Autowired
    private QueryRefundBusiService queryRefundBusiService;

    @Autowired
    public BillPayBalanceCombServiceImpl(BillCompareDiffQueryBusiService billCompareDiffQueryBusiService, BillPayBillDayCreateBusiService billPayBillDayCreateBusiService, BillPayTransUpdateSuccessBusiService billPayTransUpdateSuccessBusiService, BillRefundTransUpdateSuccessBusiService billRefundTransUpdateSuccessBusiService, BillCompareDiffCreateBusiService billCompareDiffCreateBusiService, CallBackNoticeService callBackNoticeService) {
        this.billCompareDiffQueryBusiService = billCompareDiffQueryBusiService;
        this.billPayBillDayCreateBusiService = billPayBillDayCreateBusiService;
        this.billPayTransUpdateSuccessBusiService = billPayTransUpdateSuccessBusiService;
        this.billRefundTransUpdateSuccessBusiService = billRefundTransUpdateSuccessBusiService;
        this.billCompareDiffCreateBusiService = billCompareDiffCreateBusiService;
        this.callBackNoticeService = callBackNoticeService;
    }

    public void doBalanceClean(BillExecuteRequest request) throws BillBalanceException {
    }

    public void doBalance(BillExecuteRequest request) throws BillBalanceException {
        BillCompareDiffQueryReqBO billCompareDiffQueryReqBO = new BillCompareDiffQueryReqBO();
        billCompareDiffQueryReqBO.setBillDate(request.getBillDate());
        billCompareDiffQueryReqBO.setPaymentInsId(request.getPaymentInsId());
        billCompareDiffQueryReqBO.setPaymentMchId(request.getPaymentMchId());
        List billCompareDiffQueryRspBOS = this.billCompareDiffQueryBusiService.query(billCompareDiffQueryReqBO);
        if (billCompareDiffQueryRspBOS == null || billCompareDiffQueryRspBOS.size() < 1) {
            LoggerProUtils.debug(this.logger, "\u67e5\u8be2\u5f02\u5e38\u8ba2\u5355\u6570\u636e\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6\uff1a" + request.toString());
            return;
        }
        for (BillCompareDiffQueryRspBO diff : billCompareDiffQueryRspBOS) {
            if (!Objects.equals(0L, diff.getDealFlag())) continue;
            if (2 == diff.getDiffType()) {
                this.updateDiffDealFlagTodo(diff);
                this.updatePayBillDayFlag(diff, "2");
                continue;
            }
            if (3 == diff.getDiffType()) {
                this.billDayCreate(diff);
                continue;
            }
            if (4 != diff.getDiffType()) continue;
            this.updateDiffDealFlagTodo(diff);
            this.updatePayBillDayFlag(diff, "4");
        }
    }

    private void updatePayBillDayFlag(BillCompareDiffQueryRspBO diff, String flag) {
        BillPayBillDayCreateReqBO reqBO = new BillPayBillDayCreateReqBO();
        reqBO.setOrderId(diff.getOrderId());
        reqBO.setPayOrderId(diff.getPayOrderId());
        reqBO.setRefundOrderId(diff.getRefundOrderId());
        reqBO.setFlag(flag);
        this.billPayBillDayCreateBusiService.updateFlag(reqBO);
    }

    private void updateDiffDealFlagTodo(BillCompareDiffQueryRspBO diff) {
        this.billCompareDiffCreateBusiService.updateDealFlag(diff.getId(), diff.getOrderId(), Long.valueOf(-1L));
    }

    private void billDayCreate(BillCompareDiffQueryRspBO diff) {
        if ("01".equals(diff.getOrderType())) {
            BillPayTransUpdateSuccessReqBO reqBO = new BillPayTransUpdateSuccessReqBO();
            QueryPayTransRspBO queryPayTransRspBO = this.queryPayTransBusiService.queryByPayOrderId(diff.getPayOrderId());
            if (queryPayTransRspBO != null && !"A10".equals(queryPayTransRspBO.getOrderStatus())) {
                reqBO.setOrderId(diff.getOrderId());
                reqBO.setPayOrderId(diff.getPayOrderId());
                reqBO.setPayNotifyTransId(diff.getBillTransId());
                reqBO.setTradeTime(String.valueOf(diff.getBillDate()));
                reqBO.setPayMsg("\u4ea4\u6613\u6210\u529f");
                reqBO.setRealFee(diff.getPayTotalFee());
                this.billPayTransUpdateSuccessBusiService.updateSuccess(reqBO);
                this.updatePayBillDayFlag(diff, "1");
                this.billCompareDiffCreateBusiService.updateDealFlag(diff.getId(), diff.getOrderId(), Long.valueOf(1L));
                return;
            }
        } else if ("02".equals(diff.getOrderType())) {
            BillRefundTransUpdateSuccessReqBO reqBO = new BillRefundTransUpdateSuccessReqBO();
            QueryRefundRspBO queryRefundRspBO = this.queryRefundBusiService.queryByRefundOrderId(diff.getRefundOrderId());
            if (queryRefundRspBO != null && !"B10".equals(queryRefundRspBO.getOrderStatus())) {
                reqBO.setOrderId(diff.getOrderId());
                reqBO.setRefundOrderId(diff.getRefundOrderId());
                reqBO.setPayNotifyTransId(diff.getBillTransId());
                reqBO.setTradeTime(String.valueOf(diff.getBillDate()));
                reqBO.setPayMsg("\u4ea4\u6613\u6210\u529f");
                reqBO.setRealFee(diff.getPayTotalFee());
                this.billRefundTransUpdateSuccessBusiService.updateSuccess(reqBO);
                this.updatePayBillDayFlag(diff, "1");
                this.billCompareDiffCreateBusiService.updateDealFlag(diff.getId(), diff.getOrderId(), Long.valueOf(1L));
                return;
            }
        }
        this.updateDiffDealFlagTodo(diff);
    }
}

