/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import com.tydic.payment.pay.comb.PayProOrderCombService;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceReqBo;
import com.tydic.payment.pay.comb.bo.PayProOrderCombServiceRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"PAY_GROUP_LOCAL/2.0-SNAPSHOT/com.tydic.payment.pay.ability.PayProOrderAbilityService"})
public class PayProOrderAbilityServiceImpl
implements PayProOrderAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PayProOrderAbilityService.class);
    private static final String SERVICE_NAME = "\u7edf\u4e00\u652f\u4ed8ability\u670d\u52a1";
    @Autowired
    private PayProOrderCombService payProUniPayCombService;
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;

    @PostMapping(value={"dealOrder"})
    public PayProOrderAbilityServiceRspBo dealOrder(@RequestBody PayProOrderAbilityServiceReqBo reqBo) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7edf\u4e00\u652f\u4ed8ability\u670d\u52a1->\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        PayProOrderAbilityServiceRspBo retBo = new PayProOrderAbilityServiceRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("3010");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("4019");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("4019");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        PayProOrderCombServiceReqBo combReqBo = new PayProOrderCombServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setBusiId(busiCodeRspBo.getBusiId().toString());
        PayProOrderCombServiceRspBo combRetBo = this.payProUniPayCombService.dealOrder(combReqBo);
        BeanUtils.copyProperties((Object)combRetBo, (Object)retBo);
        return retBo;
    }

    private String validateArg(PayProOrderAbilityServiceReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027busiCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

